/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

import net.minecraft.class_3532;

public class AnimatedAction {
    public static final AnimatedAction VANILLA_ATTACK = new AnimatedAction(20, 1, "vanilla");
    public static final AnimatedAction[] VANILLA_ATTACK_ONLY = new AnimatedAction[]{VANILLA_ATTACK};
    private final int length;
    private final int attackTime;
    private final boolean shouldRunOut;
    private final String id;
    private final String animationClient;
    private final float speed;
    private float ticker;

    public AnimatedAction(double length, String id) {
        this((int)Math.ceil(length * 20.0), id);
    }

    public AnimatedAction(int length, String id) {
        this(length, 1, id, id, 1.0f, true);
    }

    public AnimatedAction(double length, double attackTime, String id) {
        this((int)Math.ceil(length * 20.0), (int)Math.ceil(attackTime * 20.0), id, id, 1.0f, true);
    }

    public AnimatedAction(int length, int attackTime, String id) {
        this(length, attackTime, id, id, 1.0f, true);
    }

    private AnimatedAction(int length, int attackTime, String id, String animationClient, float speedMod, boolean shouldRunOut) {
        this.speed = speedMod;
        this.length = Math.max(1, length);
        this.attackTime = class_3532.method_15340((int)attackTime, (int)1, (int)this.length);
        this.id = id;
        this.animationClient = animationClient;
        this.shouldRunOut = shouldRunOut;
    }

    public static AnimatedAction copyOf(AnimatedAction animatedAction, String id) {
        return new AnimatedAction(animatedAction.length, animatedAction.attackTime, id, animatedAction.animationClient, animatedAction.speed, animatedAction.shouldRunOut);
    }

    public static Builder builder(int length, String id) {
        return new Builder(length, id);
    }

    public AnimatedAction create() {
        return this.create(this.speed);
    }

    public AnimatedAction create(float speed) {
        return new AnimatedAction(this.length, this.attackTime, this.id, this.animationClient, speed, this.shouldRunOut);
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int offSet) {
        float f;
        this.ticker += this.speed;
        return f >= (float)(this.length + offSet) && this.shouldRunOut;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean canAttack() {
        return this.isAtTick(this.attackTime);
    }

    public int getTick() {
        return (int)this.ticker;
    }

    public float getTickRaw() {
        return this.ticker;
    }

    public boolean isAtTick(double tick) {
        return this.isAtTick((int)Math.ceil(tick * 20.0));
    }

    public boolean isAtTick(int tick) {
        if (this.speed == 1.0f) {
            return this.getTick() == tick;
        }
        if (this.speed < 1.0f) {
            int lower = (int)(this.ticker - this.speed);
            return lower != tick && this.getTick() == tick;
        }
        float next = this.ticker + this.speed;
        return this.ticker <= (float)tick && (float)tick < next;
    }

    public boolean isPastTick(double tick) {
        return this.isPastTick((int)Math.ceil(tick * 20.0));
    }

    public boolean isPastTick(int tick) {
        return this.getTick() >= tick;
    }

    public int getLength() {
        return this.length;
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public void reset() {
        this.ticker = 0.0f;
    }

    public String getID() {
        return this.id;
    }

    public boolean is(AnimatedAction ... others) {
        for (AnimatedAction other : others) {
            if (other == null || !this.id.equals(other.id)) continue;
            return true;
        }
        return false;
    }

    public String getAnimationClient() {
        return this.animationClient;
    }

    public boolean shouldRunOut() {
        return this.shouldRunOut;
    }

    public String toString() {
        return "ID: " + this.id + "; length: " + this.length + "; attackTime: " + this.attackTime + "; speed: " + this.speed;
    }

    public boolean equals(Object o) {
        if (o instanceof AnimatedAction) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder {
        private final int length;
        private int attackTime = 1;
        private boolean shouldRunOut = true;
        private final String id;
        private String animationClient;
        private float speed = 1.0f;

        public Builder(int length, String id) {
            this.length = Math.max(1, length);
            this.id = id;
            this.animationClient = id;
        }

        public Builder withClientID(String id) {
            this.animationClient = id;
            return this;
        }

        public Builder marker(int time) {
            this.attackTime = class_3532.method_15340((int)time, (int)1, (int)this.length);
            return this;
        }

        public Builder infinite() {
            this.shouldRunOut = false;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public AnimatedAction build() {
            return new AnimatedAction(this.length, this.attackTime, this.id, this.animationClient, this.speed, this.shouldRunOut);
        }
    }
}

