/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.hexblade.client.entity;

import com.cleannrooster.hexblade.Hexblade;
import com.cleannrooster.hexblade.client.entity.MagusModel;
import com.cleannrooster.hexblade.client.entity.RenderLayerItemMagus;
import com.cleannrooster.hexblade.entity.Magus;
import java.time.LocalDate;
import java.time.Month;
import mod.azure.azurelib.common.api.client.renderer.DynamicGeoEntityRenderer;
import mod.azure.azurelib.common.api.client.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.common.internal.client.renderer.GeoRenderer;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class MagusRenderer<T extends Magus, M extends class_572<T>>
extends DynamicGeoEntityRenderer<Magus> {
    private static final class_2960 DEFAULT_LOCATION = class_2960.method_60655((String)"hexblade", (String)"textures/mob/magus.png");
    private static final class_2960 FIRE = class_2960.method_60655((String)"hexblade", (String)"textures/mob/magus.png");
    private static final class_2960 FROST = class_2960.method_60655((String)"hexblade", (String)"textures/mob/magus_frost.png");
    private static final class_2960 ARCANE = class_2960.method_60655((String)"hexblade", (String)"textures/mob/magus_arcane.png");
    private static final class_2960 STEVE = class_2960.method_60655((String)"hexblade", (String)"textures/mob/stevetexture.png");
    private static final class_2960 BLANK = class_2960.method_60655((String)"hexblade", (String)"textures/mob/blank.png");
    private int stage;
    public static final class_2960 textureIDArcane = class_2960.method_60655((String)"hexblade", (String)"item/arcaneaura");
    public static final class_2960 textureIDFrost = class_2960.method_60655((String)"hexblade", (String)"item/frostaura");
    public static final class_2960 textureIDFire = class_2960.method_60655((String)"hexblade", (String)"item/flameaura");

    public MagusRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new MagusModel());
        this.addRenderLayer((GeoRenderLayer)new RenderLayerItemMagus((GeoRenderer<Magus>)this));
    }

    public void renderRecursively(class_4587 poseStack, Magus animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        boolean bool = bone.getName().equals("rightArm");
        boolean bool2 = bone.getName().equals("leftArm");
        if (bone.getName().equals("head")) {
            poseStack.method_22903();
            RenderUtils.translateMatrixToBone((class_4587)poseStack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((class_4587)poseStack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((class_4587)poseStack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((class_4587)poseStack, (CoreGeoBone)bone);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15363((float)(animatable.field_6283 - animatable.method_5705(partialTick)), (float)-55.0f, (float)55.0f)));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-animatable.method_5695(partialTick)));
            if (bone.isTrackingMatrices()) {
                Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
                Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
                bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
                bone.setLocalSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.method_23169((class_1297)((Magus)this.animatable), 1.0f).method_46409()));
                bone.setWorldSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)((Magus)this.animatable).method_19538().method_46409()));
            }
            RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (CoreGeoBone)bone);
            this.textureOverride = this.getTextureOverrideForBone(bone, (class_1297)((Magus)this.animatable), partialTick);
            class_2960 texture = this.textureOverride == null ? this.getTexture((Magus)this.animatable) : this.textureOverride;
            class_1921 renderTypeOverride = this.getRenderTypeOverrideForBone(bone, (class_1297)((Magus)this.animatable), texture, bufferSource, partialTick);
            if (texture != null && renderTypeOverride == null) {
                renderTypeOverride = this.getRenderType((GeoAnimatable)((Magus)this.animatable), texture, bufferSource, partialTick);
            }
            if (renderTypeOverride != null) {
                buffer = bufferSource.getBuffer(renderTypeOverride);
            }
            if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour)) {
                super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, colour);
            }
            if (renderTypeOverride != null) {
                buffer = bufferSource.getBuffer(this.getRenderType((GeoAnimatable)((Magus)this.animatable), this.getTexture((Magus)this.animatable), bufferSource, partialTick));
            }
            if (!isReRender) {
                this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            }
            super.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
            poseStack.method_22909();
        } else {
            super.renderRecursively(poseStack, (class_1297)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        }
    }

    public Color getRenderColor(Magus animatable, float partialTick, int packedLight) {
        Color color = Color.WHITE;
        if (this.stage != 0) {
            if (animatable.getMagicSchool().equals(SpellSchools.FROST)) {
                return Color.ofHSB((float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (animatable.getMagicSchool().equals(SpellSchools.ARCANE)) {
                return Color.ofHSB((float)0.7916667f, (float)1.0f, (float)1.0f);
            }
            if (animatable.getMagicSchool().equals(SpellSchools.FIRE)) {
                return Color.ofHSB((float)0.9166667f, (float)1.0f, (float)1.0f);
            }
        }
        return color;
    }

    @NotNull
    public class_2960 getTexture(@NotNull Magus animatable) {
        return super.method_3931((class_1297)animatable);
    }

    public void render(Magus entity, float entityYaw, float partialTick, class_4587 matrices, class_4597 vertexConsumerProvider, int packedLight) {
        this.stage = 0;
        entity.stage = 0;
        super.method_3936((class_1297)entity, entityYaw, partialTick, matrices, vertexConsumerProvider, packedLight);
        this.stage = 1;
        entity.stage = 1;
        matrices.method_22905((float)(1.0 + (double)(0.1f * (1.0f + (float)(entity.field_6012 % 2)))), (float)(1.0 + (double)(0.1f * (1.0f + (float)(entity.field_6012 % 2)))), (float)(1.0 + (double)(0.1f * (1.0f + (float)(entity.field_6012 % 2)))));
        class_243 distance = class_310.method_1551().field_1773.method_19418().method_19326().method_1020(entity.method_19538()).method_1021(-1.0).method_1029();
        matrices.method_22904(distance.method_10216() * (double)0.4f, distance.method_10214() * (double)0.4f, distance.method_10215() * (double)0.4f);
        super.method_3936((class_1297)entity, entityYaw, partialTick, matrices, vertexConsumerProvider, 0xF000F0);
    }

    public static void drawFireVertex(class_4587.class_4665 entry, class_4588 vertices, float x, float y, float z, float u, float v, int light) {
        vertices.method_56824(entry, x, y, z).method_39415(-1).method_22913(u, v).method_60796(0, 10).method_60803(light).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    public static void drawFireVertex(class_4587.class_4665 entry, class_4588 vertices, float x, float y, float z, float u, float v) {
        vertices.method_56824(entry, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 0.65f).method_22913(u, v).method_60796(0, 10).method_60803(240).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    public class_2960 getTextureMagus(class_1309 livingEntity) {
        if (livingEntity instanceof Magus) {
            Magus magus = (Magus)livingEntity;
            if (magus.getMagicSchool().equals(SpellSchools.ARCANE)) {
                return textureIDArcane;
            }
            if (magus.getMagicSchool().equals(SpellSchools.FROST)) {
                return textureIDFrost;
            }
            if (magus.getMagicSchool().equals(SpellSchools.FIRE)) {
                return textureIDFire;
            }
        }
        return textureIDArcane;
    }

    public class_2960 getTextureLocation(Magus p_114891_) {
        if (this.stage == 1) {
            return BLANK;
        }
        if (((Boolean)p_114891_.method_5841().method_12789(Magus.APRILFOOLS)).booleanValue() || Hexblade.config.aprilFools || LocalDate.now().getDayOfMonth() == 1 && LocalDate.now().getMonth() == Month.APRIL) {
            return STEVE;
        }
        if (p_114891_.getMagicSchool().equals(SpellSchools.FIRE)) {
            return FIRE;
        }
        if (p_114891_.getMagicSchool().equals(SpellSchools.FROST)) {
            return FROST;
        }
        if (p_114891_.getMagicSchool().equals(SpellSchools.ARCANE)) {
            return ARCANE;
        }
        return DEFAULT_LOCATION;
    }

    protected int getBlockLight(Magus entity, class_2338 pos) {
        return super.method_24087((class_1297)entity, pos);
    }
}

