/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.EntryList;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.slot.SlotContainer;
import dev.huskuraft.effortless.api.gui.slot.SlotData;
import dev.huskuraft.effortless.api.gui.slot.TextSlot;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;

public final class TransformerList
extends EditableEntryList<Transformer> {
    public TransformerList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
    }

    @Override
    protected EditableEntryList.Entry createHolder(Transformer transformer) {
        return switch (transformer.getType()) {
            default -> throw new MatchException(null, null);
            case Transformers.ARRAY -> new ArrayEntry((Entrance)this.getEntrance(), (EntryList)this, (ArrayTransformer)transformer);
            case Transformers.MIRROR -> new MirrorEntry((Entrance)this.getEntrance(), (EntryList)this, (MirrorTransformer)transformer);
            case Transformers.RADIAL -> new RadialEntry((Entrance)this.getEntrance(), (EntryList)this, (RadialTransformer)transformer);
            case Transformers.RANDOMIZER -> new ItemRandomizerEntry((Entrance)this.getEntrance(), (EntryList)this, (ItemRandomizer)transformer);
        };
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public static class ArrayEntry
    extends Entry<ArrayTransformer> {
        public ArrayEntry(Entrance entrance, EntryList entryList, ArrayTransformer arrayTransformer) {
            super(entrance, entryList, arrayTransformer);
        }

        @Override
        protected List<SlotData> getData() {
            return List.of(new SlotData.TextSymbol(ArrayEntry.formatDouble(((ArrayTransformer)this.getItem()).offset().x()), Axis.X.getDisplayName()), new SlotData.TextSymbol(ArrayEntry.formatDouble(((ArrayTransformer)this.getItem()).offset().y()), Axis.Y.getDisplayName()), new SlotData.TextSymbol(ArrayEntry.formatDouble(((ArrayTransformer)this.getItem()).offset().z()), Axis.Z.getDisplayName()), new SlotData.TextSymbol(ArrayEntry.formatDouble(((ArrayTransformer)this.getItem()).count()), Text.text("C")));
        }
    }

    public static class MirrorEntry
    extends Entry<MirrorTransformer> {
        public MirrorEntry(Entrance entrance, EntryList entryList, MirrorTransformer mirrorTransformer) {
            super(entrance, entryList, mirrorTransformer);
        }

        @Override
        protected List<SlotData> getData() {
            return List.of(new SlotData.TextSymbol(MirrorEntry.formatDouble(((MirrorTransformer)this.getItem()).position().x()), Axis.X.getDisplayName()), new SlotData.TextSymbol(MirrorEntry.formatDouble(((MirrorTransformer)this.getItem()).position().y()), Axis.Y.getDisplayName()), new SlotData.TextSymbol(MirrorEntry.formatDouble(((MirrorTransformer)this.getItem()).position().z()), Axis.Z.getDisplayName()), new SlotData.TextSymbol(((MirrorTransformer)this.getItem()).axis().getDisplayName(), Text.text("A")), new SlotData.TextSymbol(MirrorEntry.formatDouble(((MirrorTransformer)this.getItem()).size()), Text.text("S")));
        }
    }

    public static class RadialEntry
    extends Entry<RadialTransformer> {
        public RadialEntry(Entrance entrance, EntryList entryList, RadialTransformer radialTransformer) {
            super(entrance, entryList, radialTransformer);
        }

        @Override
        protected List<SlotData> getData() {
            return List.of(new SlotData.TextSymbol(RadialEntry.formatDouble(((RadialTransformer)this.getItem()).position().x()), Axis.X.getDisplayName()), new SlotData.TextSymbol(RadialEntry.formatDouble(((RadialTransformer)this.getItem()).position().y()), Axis.Y.getDisplayName()), new SlotData.TextSymbol(RadialEntry.formatDouble(((RadialTransformer)this.getItem()).position().z()), Axis.Z.getDisplayName()), new SlotData.TextSymbol(((RadialTransformer)this.getItem()).axis().getDisplayName(), Text.text("A")), new SlotData.TextSymbol(RadialEntry.formatDouble(((RadialTransformer)this.getItem()).slices()), Text.text("S")), new SlotData.TextSymbol(RadialEntry.formatDouble(((RadialTransformer)this.getItem()).radius()), Text.text("R")), new SlotData.TextSymbol(RadialEntry.formatDouble(((RadialTransformer)this.getItem()).length()), Text.text("L")));
        }
    }

    public static class ItemRandomizerEntry
    extends Entry<ItemRandomizer> {
        public ItemRandomizerEntry(Entrance entrance, EntryList entryList, ItemRandomizer randomizer) {
            super(entrance, entryList, randomizer);
        }

        @Override
        protected List<SlotData> getData() {
            if (((ItemRandomizer)this.getItem()).getSource() == ItemRandomizer.Source.CUSTOMIZE) {
                return ((ItemRandomizer)this.getItem()).getChances().stream().map(chance -> new SlotData.ItemStackSymbol(((Item)chance.content()).getDefaultStack(), Text.text(String.valueOf(chance.chance())))).collect(Collectors.toList());
            }
            return List.of();
        }
    }

    public static abstract class Entry<T extends Transformer>
    extends EditableEntryList.Entry<T> {
        protected TextSlot textSlot;
        protected AbstractWidget titleTextWidget;
        protected SlotContainer slotContainer;

        public Entry(Entrance entrance, EntryList entryList, T transformer) {
            super(entrance, entryList, transformer);
        }

        protected static String formatDouble(double number) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            return decimalFormat.format(number);
        }

        public static Text getSymbol(Transformer transformer) {
            return switch (transformer.getType()) {
                default -> throw new MatchException(null, null);
                case Transformers.ARRAY -> Text.text("AT");
                case Transformers.MIRROR -> Text.text("MT");
                case Transformers.RADIAL -> Text.text("RT");
                case Transformers.RANDOMIZER -> Text.text("IR");
            };
        }

        @Override
        public void onCreate() {
            this.textSlot = this.addWidget(new TextSlot(this.getEntrance(), this.getX(), this.getY(), 30, 30, this.getSymbol()));
            this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 30 + 2, this.getY() + 2, ((Transformer)this.getItem()).getName()));
            this.slotContainer = this.addWidget(new SlotContainer(this.getEntrance(), this.getX() + 30 + 2, this.getY() + 12, 0, 0));
        }

        @Override
        public void onReload() {
            this.slotContainer.setWrapLines(this.getEntryList().getSelected() == this);
            this.textSlot.setMessage(this.getSymbol());
            this.slotContainer.setEntries(this.getData());
        }

        protected abstract List<SlotData> getData();

        protected Text getSymbol() {
            return Entry.getSymbol((Transformer)this.getItem());
        }

        @Override
        public int getHeight() {
            return 34;
        }
    }
}

