/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.Typeface;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.gui.tooltip.TooltipHelper;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.building.config.PatternConfig;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import dev.huskuraft.effortless.screen.transformer.EffortlessItemRandomizerEditScreen;
import dev.huskuraft.effortless.screen.transformer.EffortlessTransformerEditScreen;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class EffortlessTransformerPresetsScreen
extends AbstractPanelScreen {
    private final List<Button> tabButtons = new ArrayList<Button>();
    private Consumer<List<? extends Transformer>> consumer;
    private Map<Transformers, List<? extends Transformer>> builtInTransformers;
    private Map<Transformers, List<? extends Transformer>> defaultConfig;
    private Map<Transformers, List<? extends Transformer>> originalConfig;
    private Map<Transformers, List<? extends Transformer>> config;
    private TransformerList entries;
    private TextWidget titleTextWidget;
    private Button editButton;
    private Button deleteButton;
    private Button clearButton;
    private Button addButton;
    private Button cancelButton;
    private Button saveButton;
    private Transformers selectedType = Transformers.ARRAY;

    public EffortlessTransformerPresetsScreen(Entrance entrance) {
        super(entrance, Text.translate("effortless.transformer_presets.title").withStyle(ChatFormatting.DARK_GRAY), 264, 238);
        this.consumer = transformers -> this.getEntrance().getConfigStorage().update(config -> config.withPatternConfig(new PatternConfig((List<? extends Transformer>)transformers)));
        this.builtInTransformers = PatternConfig.getBuiltInPresets().getByType();
        this.defaultConfig = ((ClientConfig)this.getEntrance().getConfigStorage().get()).patternConfig().getByType();
        this.originalConfig = ((ClientConfig)this.getEntrance().getConfigStorage().get()).patternConfig().getByType();
        this.config = ((ClientConfig)this.getEntrance().getConfigStorage().get()).patternConfig().getByType();
    }

    public EffortlessTransformerPresetsScreen(Entrance entrance, Consumer<List<? extends Transformer>> consumer) {
        this(entrance);
        this.consumer = consumer;
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.editButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.edit"), button -> {
            if (this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
                this.editTransformer((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.25f).build());
        this.deleteButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.delete"), button -> {
            if (this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
                this.entries.deleteSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.25f, 0.25f).build());
        this.clearButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.clear"), button -> this.entries.reset(this.entries.items().stream().filter(transformer1 -> transformer1.isBuiltIn()).toList())).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.5f, 0.25f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.add"), button -> this.editTransformer(switch (this.selectedType) {
            default -> throw new MatchException(null, null);
            case Transformers.ARRAY -> ArrayTransformer.DEFAULT.withRandomId();
            case Transformers.MIRROR -> MirrorTransformer.DEFAULT_X.withRandomId();
            case Transformers.RADIAL -> RadialTransformer.DEFAULT.withRandomId();
            case Transformers.RANDOMIZER -> ItemRandomizer.EMPTY.withRandomId();
        })).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.75f, 0.25f).build());
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.save"), button -> {
            this.detachAll();
            this.consumer.accept(this.config.values().stream().flatMap(Collection::stream).toList());
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        this.tabButtons.clear();
        for (Transformers type : Transformers.values()) {
            this.tabButtons.add(this.addWidget(Button.builder((Entrance)this.getEntrance(), type.getTitleText(), button -> this.setSelectedType(type)).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), 48, 0.0f, 1.0f * (float)type.ordinal() / (float)Transformers.values().length, 1.0f / (float)Transformers.values().length).build()));
        }
        this.entries = this.addWidget(new TransformerList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + 28, this.getWidth() - 12 - 8, this.getHeight() - 18 - 28 - 54));
        this.entries.setAlwaysShowScrollbar(true);
        this.setSelectedType(this.selectedType);
    }

    @Override
    public void onReload() {
        for (Button tabButton : this.tabButtons) {
            tabButton.setActive(!tabButton.getMessage().equals(this.selectedType.getTitleText()));
        }
        this.editButton.setActive(this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn());
        this.deleteButton.setActive(this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn());
        this.config.put(this.selectedType, this.entries.items().stream().filter(transformer1 -> !transformer1.isBuiltIn()).filter(transformer1 -> transformer1.getType() == this.selectedType).toList());
        if (this.entries.getSelected() != null && ((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
            this.editButton.setTooltip(Stream.concat(Stream.of(Text.translate("effortless.transformer.edit.tooltip.cannot_edit_built_in.title")), TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.edit.tooltip.cannot_edit_built_in.message").withStyle(ChatFormatting.GRAY)).stream()).toList());
        } else {
            this.editButton.clearTooltip();
        }
        if (this.entries.getSelected() != null && ((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
            this.deleteButton.setTooltip(Stream.concat(Stream.of(Text.translate("effortless.transformer.delete.tooltip.cannot_delete_built_in.title")), TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.delete.tooltip.cannot_delete_built_in.message").withStyle(ChatFormatting.GRAY)).stream()).toList());
        } else {
            this.deleteButton.clearTooltip();
        }
        Stream<Text> stream = switch (this.selectedType) {
            default -> throw new MatchException(null, null);
            case Transformers.ARRAY -> Stream.of(Text.translate("effortless.transformer.add.tooltip.array.title"));
            case Transformers.MIRROR -> Stream.of(Text.translate("effortless.transformer.add.tooltip.mirror.title"));
            case Transformers.RADIAL -> Stream.of(Text.translate("effortless.transformer.add.tooltip.radial.title"));
            case Transformers.RANDOMIZER -> Stream.of(Text.translate("effortless.transformer.add.tooltip.random.title"));
        };
        Typeface typeface = this.getTypeface();
        this.addButton.setTooltip(Stream.concat(stream, TooltipHelper.wrapLines(typeface, (switch (this.selectedType) {
            default -> throw new MatchException(null, null);
            case Transformers.ARRAY -> Text.translate("effortless.transformer.add.tooltip.array.message");
            case Transformers.MIRROR -> Text.translate("effortless.transformer.add.tooltip.mirror.message");
            case Transformers.RADIAL -> Text.translate("effortless.transformer.add.tooltip.radial.message");
            case Transformers.RANDOMIZER -> Text.translate("effortless.transformer.add.tooltip.random.message");
        }).withStyle(ChatFormatting.GRAY)).stream()).toList());
        this.addButton.setActive(this.selectedType == Transformers.RANDOMIZER);
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected() && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
            this.editTransformer((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
        }
    }

    private void setSelectedType(Transformers type) {
        this.selectedType = type;
        this.entries.setSelected(null);
        this.entries.reset(Stream.concat(this.builtInTransformers.get((Object)this.selectedType).stream(), this.config.get((Object)this.selectedType).stream()).toList());
        this.entries.setScrollAmount(0.0);
    }

    private void editTransformer(Transformer transformer) {
        switch (transformer.getType()) {
            case ARRAY: 
            case MIRROR: 
            case RADIAL: {
                new EffortlessTransformerEditScreen(this.getEntrance(), result -> {
                    if (this.entries.hasSelected()) {
                        this.entries.replaceSelect(result);
                    } else {
                        this.entries.insertSelected(result);
                    }
                    this.onReload();
                }, transformer).attach();
                break;
            }
            case RANDOMIZER: {
                new EffortlessItemRandomizerEditScreen(this.getEntrance(), result -> {
                    if (this.entries.hasSelected()) {
                        this.entries.replaceSelect(result);
                    } else {
                        this.entries.insertSelected(result);
                    }
                    this.onReload();
                }, (ItemRandomizer)transformer).attach();
            }
        }
    }
}

