/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.slot.TextSlot;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.screen.settings.SettingOptionsList;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class EffortlessTransformerEditScreen
extends AbstractPanelScreen {
    private final Consumer<Transformer> consumer;
    private Transformer transformer;
    private AbstractWidget titleTextWidget;
    private TransformerList transformerEntries;
    private SettingOptionsList entries;
    private Button moveToPlayerButton;
    private Button moveToCornerOrCenterButton;
    private Button saveButton;
    private Button cancelButton;
    private TextSlot textSlot;

    public EffortlessTransformerEditScreen(Entrance entrance, Consumer<Transformer> consumer, Transformer transformer) {
        super(entrance, Text.translate("effortless.transformer.edit.title"), 264, 238);
        this.consumer = consumer;
        this.transformer = transformer;
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.transformerEntries = this.addWidget(new TransformerList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, 38));
        this.transformerEntries.setShowScrollBar(false);
        this.transformerEntries.setRenderSelection(false);
        this.transformerEntries.reset(List.of(this.transformer));
        this.entries = this.addWidget(new SettingOptionsList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + this.transformerEntries.getHeight() + 4, this.getWidth() - 12 - 8, this.getHeight() - 18 - this.transformerEntries.getHeight() - 4 - (this.transformer.getType() == Transformers.MIRROR || this.transformer.getType() == Transformers.RADIAL ? 54 : 30), true, false));
        this.entries.setAlwaysShowScrollbar(true);
        this.moveToPlayerButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.position.move_to_player"), button -> {
            Vector3d playerPosition = this.getEntrance().getClient().getPlayer().getPosition();
            this.transformer = switch (this.transformer.getType()) {
                default -> throw new MatchException(null, null);
                case Transformers.ARRAY -> this.transformer;
                case Transformers.MIRROR -> ((MirrorTransformer)this.transformer).withPosition(Transformer.roundAllHalf(playerPosition));
                case Transformers.RADIAL -> ((RadialTransformer)this.transformer).withPosition(Transformer.roundAllHalf(playerPosition));
                case Transformers.RANDOMIZER -> this.transformer;
            };
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.5f).build());
        this.moveToPlayerButton.setVisible(this.transformer.getType() == Transformers.MIRROR || this.transformer.getType() == Transformers.RADIAL);
        this.moveToPlayerButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.position.move_to_player"), button -> {
            Vector3d playerPosition = this.getEntrance().getClient().getPlayer().getPosition();
            this.transformer = switch (this.transformer.getType()) {
                default -> throw new MatchException(null, null);
                case Transformers.ARRAY -> this.transformer;
                case Transformers.MIRROR -> ((MirrorTransformer)this.transformer).withPosition(Transformer.roundAllHalf(playerPosition));
                case Transformers.RADIAL -> ((RadialTransformer)this.transformer).withPosition(Transformer.roundAllHalf(playerPosition));
                case Transformers.RANDOMIZER -> this.transformer;
            };
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.5f).build());
        this.moveToPlayerButton.setVisible(this.transformer.getType() == Transformers.MIRROR || this.transformer.getType() == Transformers.RADIAL);
        this.moveToCornerOrCenterButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.position.move_to_center_or_corner"), button -> {
            this.transformer = switch (this.transformer.getType()) {
                default -> throw new MatchException(null, null);
                case Transformers.ARRAY -> this.transformer;
                case Transformers.MIRROR -> ((MirrorTransformer)this.transformer).withPosition(Transformer.roundHalf(((MirrorTransformer)this.transformer).position()));
                case Transformers.RADIAL -> ((RadialTransformer)this.transformer).withPosition(Transformer.roundHalf(((RadialTransformer)this.transformer).position()));
                case Transformers.RANDOMIZER -> this.transformer;
            };
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.5f, 0.5f).build());
        this.moveToCornerOrCenterButton.setVisible(this.transformer.getType() == Transformers.MIRROR || this.transformer.getType() == Transformers.RADIAL);
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.edit.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.edit.save"), button -> {
            this.consumer.accept(this.transformer);
            this.detach();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        switch (this.transformer.getType()) {
            case ARRAY: {
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.array.offset.x"), Text.text("X"), ((ArrayTransformer)this.transformer).offset().x(), ArrayTransformer.OFFSET_BOUND.minX(), ArrayTransformer.OFFSET_BOUND.maxX(), value -> {
                    this.transformer = ((ArrayTransformer)this.transformer).withOffsetX((int)value);
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.array.offset.y"), Text.text("Y"), ((ArrayTransformer)this.transformer).offset().y(), ArrayTransformer.OFFSET_BOUND.minY(), ArrayTransformer.OFFSET_BOUND.maxY(), value -> {
                    this.transformer = ((ArrayTransformer)this.transformer).withOffsetY((int)value);
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.array.offset.z"), Text.text("Z"), ((ArrayTransformer)this.transformer).offset().z(), ArrayTransformer.OFFSET_BOUND.minZ(), ArrayTransformer.OFFSET_BOUND.maxZ(), value -> {
                    this.transformer = ((ArrayTransformer)this.transformer).withOffsetZ((int)value);
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.array.count"), Text.text("C"), ((ArrayTransformer)this.transformer).count(), ArrayTransformer.COUNT_RANGE.min(), ArrayTransformer.COUNT_RANGE.max(), value -> {
                    this.transformer = ((ArrayTransformer)this.transformer).withCount((int)value);
                });
                break;
            }
            case MIRROR: {
                this.entries.addPositionEntry(Axis.X.getPositionName(), Axis.X.getDisplayName(), ((MirrorTransformer)this.transformer).position().x(), Transformer.POSITION_RANGE.low(), Transformer.POSITION_RANGE.high(), value -> {
                    this.transformer = ((MirrorTransformer)this.transformer).withPositionX(Transformer.roundHalf(value));
                });
                this.entries.addPositionEntry(Axis.Y.getPositionName(), Axis.Y.getDisplayName(), ((MirrorTransformer)this.transformer).position().y(), Transformer.POSITION_RANGE.low(), Transformer.POSITION_RANGE.high(), value -> {
                    this.transformer = ((MirrorTransformer)this.transformer).withPositionY(Transformer.roundHalf(value));
                });
                this.entries.addPositionEntry(Axis.Z.getPositionName(), Axis.Z.getDisplayName(), ((MirrorTransformer)this.transformer).position().z(), Transformer.POSITION_RANGE.low(), Transformer.POSITION_RANGE.high(), value -> {
                    this.transformer = ((MirrorTransformer)this.transformer).withPositionZ(Transformer.roundHalf(value));
                });
                this.entries.addSelectorEntry(Text.translate("effortless.transformer.mirror.axis"), Text.text("A"), Arrays.stream(Axis.values()).map(Axis::getDisplayName).toList(), Arrays.stream(Axis.values()).toList(), ((MirrorTransformer)this.transformer).axis(), value -> {
                    this.transformer = ((MirrorTransformer)this.transformer).withAxis((Axis)((Object)value));
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.mirror.size"), Text.text("S"), ((MirrorTransformer)this.transformer).size(), MirrorTransformer.SIZE_RANGE.min(), MirrorTransformer.SIZE_RANGE.max(), value -> {
                    this.transformer = ((MirrorTransformer)this.transformer).withSize((int)value);
                });
                break;
            }
            case RADIAL: {
                this.entries.addPositionEntry(Axis.X.getPositionName(), Axis.X.getDisplayName(), ((RadialTransformer)this.transformer).position().x(), Transformer.POSITION_RANGE.low(), Transformer.POSITION_RANGE.high(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withPositionX(Transformer.roundHalf(value));
                });
                this.entries.addPositionEntry(Axis.Y.getPositionName(), Axis.Y.getDisplayName(), ((RadialTransformer)this.transformer).position().y(), Transformer.POSITION_RANGE.low(), Transformer.POSITION_RANGE.high(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withPositionY(Transformer.roundHalf(value));
                });
                this.entries.addPositionEntry(Axis.Z.getPositionName(), Axis.Z.getDisplayName(), ((RadialTransformer)this.transformer).position().z(), Transformer.POSITION_RANGE.low(), Transformer.POSITION_RANGE.high(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withPositionZ(Transformer.roundHalf(value));
                });
                this.entries.addSelectorEntry(Text.translate("effortless.transformer.radial.axis"), Text.text("A"), Arrays.stream(Axis.values()).map(Axis::getDisplayName).toList(), Arrays.stream(Axis.values()).toList(), ((RadialTransformer)this.transformer).axis(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withAxis((Axis)((Object)value));
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.radial.slices"), Text.text("S"), ((RadialTransformer)this.transformer).slices(), RadialTransformer.SLICE_RANGE.min(), RadialTransformer.SLICE_RANGE.max(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withSlice((int)value);
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.radial.radius"), Text.text("R"), ((RadialTransformer)this.transformer).radius(), RadialTransformer.RADIUS_RANGE.min(), RadialTransformer.RADIUS_RANGE.max(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withRadius((int)value);
                });
                this.entries.addIntegerEntry(Text.translate("effortless.transformer.radial.length"), Text.text("L"), ((RadialTransformer)this.transformer).length(), RadialTransformer.LENGTH_RANGE.min(), RadialTransformer.LENGTH_RANGE.max(), value -> {
                    this.transformer = ((RadialTransformer)this.transformer).withLength((int)value);
                });
                break;
            }
        }
    }

    @Override
    public void onReload() {
        this.transformerEntries.reset(List.of(this.transformer));
        for (SettingOptionsList.Entry entry : this.entries.children()) {
            SettingOptionsList.PositionEntry positionEntry;
            if (!(entry instanceof SettingOptionsList.PositionEntry) || (positionEntry = (SettingOptionsList.PositionEntry)entry).isFocused()) continue;
            positionEntry.setItem(Transformer.roundHalf((Double)positionEntry.getItem()));
        }
    }
}

