/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.settings;

import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.EntryList;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.AbstractEntryList;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.input.NumberField;
import dev.huskuraft.effortless.api.gui.slot.TextSlot;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SettingOptionsList
extends AbstractEntryList<Entry<?>> {
    private boolean showIcon;
    private boolean showButton;

    public SettingOptionsList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
        this.showIcon = false;
        this.showButton = false;
    }

    public SettingOptionsList(Entrance entrance, int x, int y, int width, int height, boolean showIcon, boolean showButton) {
        super(entrance, x, y, width, height);
        this.showIcon = showIcon;
        this.showButton = showButton;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public void setShowIcon(boolean visible) {
        this.showIcon = visible;
        this.recreateChildren();
    }

    public boolean isShowButton() {
        return this.showButton;
    }

    public void setShowButton(boolean visible) {
        this.showButton = visible;
        this.recreateChildren();
    }

    public PositionEntry addPositionEntry(Text title, Text symbol, Double value, Double min, Double max, Consumer<Double> consumer) {
        return this.addEntry(new PositionEntry(this.getEntrance(), this, title, symbol, value, min, max, consumer));
    }

    public NumberEntry addNumberEntry(Text title, Text symbol, Double value, Double min, Double max, Consumer<Double> consumer) {
        return this.addEntry(new NumberEntry(this.getEntrance(), this, title, symbol, value, min, max, consumer));
    }

    public IntegerEntry addIntegerEntry(Text title, Text symbol, int value, int min, int max, Consumer<Integer> consumer) {
        return this.addEntry(new IntegerEntry(this.getEntrance(), this, title, symbol, value, min, max, consumer));
    }

    public IntegerEntry addIntegerEntry(Text title, Text symbol, int value, int min, int max, int step, Consumer<Integer> consumer) {
        return this.addEntry(new IntegerEntry(this.getEntrance(), this, title, symbol, value, min, max, step, consumer));
    }

    public SelectorEntry<Boolean> addSwitchEntry(Text title, Text symbol, Boolean value, Consumer<Boolean> consumer) {
        return this.addEntry(new SelectorEntry<Boolean>(this.getEntrance(), this, title, symbol, List.of(Text.translate("effortless.option.on").withStyle(ChatFormatting.GREEN), Text.translate("effortless.option.off").withStyle(ChatFormatting.RED)), List.of(Boolean.TRUE, Boolean.FALSE), value, consumer));
    }

    public <T> SelectorEntry<T> addSelectorEntry(Text title, Text symbol, List<Text> messages, List<T> values, T value, Consumer<T> consumer) {
        return this.addEntry(new SelectorEntry<T>(this.getEntrance(), this, title, symbol, messages, values, value, consumer));
    }

    public <T> ButtonEntry<T> addTab(Text title, Text symbol, T value, Consumer<T> consumer, BiConsumer<ButtonEntry<T>, T> buttonConsumer) {
        return this.addEntry(new ButtonEntry<T>(this.getEntrance(), this, title, symbol, value, consumer, buttonConsumer));
    }

    public static final class PositionEntry
    extends SettingsEntry<Double> {
        private final Double min;
        private final Double max;
        private NumberField numberField;
        private Button positionRoundButton;

        public PositionEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, Double value, Double min, Double max, Consumer<Double> consumer) {
            super(entrance, entryList, title, symbol, value, consumer);
            this.min = min;
            this.max = max;
        }

        @Override
        public void onCreate() {
            super.onCreate();
            this.numberField = this.addWidget(new NumberField((Entrance)this.getEntrance(), this.getInnerRight() - 72 - 20, this.getTop(), 72, 20, 1));
            this.numberField.setValueRange(this.min, this.max);
            this.numberField.setValue((Number)this.getItem());
            this.numberField.setValueChangeListener(value -> super.setItem(value.doubleValue()));
            this.positionRoundButton = this.addWidget(new Button((Entrance)this.getEntrance(), this.getInnerRight() - 20, this.getTop(), 20, 20, Text.empty()));
            this.titleTextWidget.setWidth(this.getInnerRight() - this.getInnerLeft() - 8 - this.numberField.getWidth());
        }

        @Override
        public void setItem(Double item) {
            super.setItem(item);
            this.numberField.setValue((Number)this.getItem());
        }

        @Override
        public void onReload() {
            if ((double)Math.round((Double)this.getItem() * 2.0) / 2.0 % 1.0 == 0.0) {
                this.positionRoundButton.setMessage(".0");
                this.positionRoundButton.setOnPressListener(button -> this.setItem(Math.floor((Double)this.getItem()) + 0.5));
            } else {
                this.positionRoundButton.setMessage(".5");
                this.positionRoundButton.setOnPressListener(button -> this.setItem(Math.floor((Double)this.getItem())));
            }
        }
    }

    public static final class NumberEntry
    extends SettingsEntry<Double> {
        private final Double min;
        private final Double max;
        private NumberField numberField;

        public NumberEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, Double value, Double min, Double max, Consumer<Double> consumer) {
            super(entrance, entryList, title, symbol, value, consumer);
            this.min = min;
            this.max = max;
        }

        @Override
        public void onCreate() {
            super.onCreate();
            this.numberField = this.addWidget(new NumberField((Entrance)this.getEntrance(), this.getInnerRight() - 72, this.getTop(), 72, 20, 1));
            this.numberField.setValueRange(this.min, this.max);
            this.numberField.setValue((Number)this.getItem());
            this.numberField.setValueChangeListener(value -> super.setItem(value.doubleValue()));
            this.titleTextWidget.setWidth(this.getInnerRight() - this.getInnerLeft() - 8 - this.numberField.getWidth());
        }

        @Override
        public void setItem(Double item) {
            super.setItem(item);
            this.numberField.setValue((Number)this.getItem());
        }
    }

    public static final class IntegerEntry
    extends SettingsEntry<Integer> {
        private final int min;
        private final int max;
        private final int step;
        private NumberField numberField;

        public IntegerEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, Integer value, int min, int max, Consumer<Integer> consumer) {
            this(entrance, entryList, title, symbol, value, min, max, 1, consumer);
        }

        public IntegerEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, Integer value, int min, int max, int step, Consumer<Integer> consumer) {
            super(entrance, entryList, title, symbol, value, consumer);
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public void onCreate() {
            super.onCreate();
            this.numberField = this.addWidget(new NumberField((Entrance)this.getEntrance(), this.getInnerRight() - 72, this.getTop(), 72, 20, 0));
            this.numberField.setValueRange(this.min, this.max);
            this.numberField.setValue((Number)this.getItem());
            this.numberField.setValueChangeListener(value -> super.setItem(value.intValue()));
            this.numberField.setStep(this.step);
            this.titleTextWidget.setWidth(this.getInnerRight() - this.getInnerLeft() - 8 - this.numberField.getWidth());
        }

        @Override
        public void setItem(Integer item) {
            super.setItem(item);
            this.numberField.setValue((Number)this.getItem());
        }
    }

    public static final class SelectorEntry<T>
    extends SettingsEntry<T> {
        private final List<Text> messages;
        private final List<T> values;
        private Button button;
        private T value;

        public SelectorEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, List<Text> messages, List<T> values, T value, Consumer<T> consumer) {
            super(entrance, entryList, title, symbol, value, consumer);
            assert (messages.size() == values.size());
            this.messages = messages;
            this.values = values;
        }

        @Override
        public void onCreate() {
            super.onCreate();
            this.button = this.addWidget(new Button((Entrance)this.getEntrance(), this.getInnerRight() - 72, this.getTop(), 72, 20, this.getButtonMessage()));
            this.button.setOnPressListener(button -> this.setItem(this.getNextItem()));
            this.titleTextWidget.setWidth(this.getInnerRight() - this.getInnerLeft() - 8 - this.button.getWidth());
        }

        private int getIndex() {
            return this.getItem() == null ? -1 : this.values.indexOf(this.getItem());
        }

        private T getNextItem() {
            return this.values.get((this.getIndex() + 1) % this.values.size());
        }

        private Text getButtonMessage() {
            int index = this.getIndex();
            if (index == -1 || index >= this.messages.size()) {
                return Text.empty();
            }
            return this.messages.get(index);
        }

        @Override
        public void setItem(T item) {
            super.setItem(item);
            this.button.setMessage(this.getButtonMessage());
        }
    }

    public static final class ButtonEntry<T>
    extends SettingsEntry<T> {
        private final BiConsumer<ButtonEntry<T>, T> entryConsumer;
        private Button button;

        public ButtonEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, T value, Consumer<T> consumer, BiConsumer<ButtonEntry<T>, T> entryConsumer) {
            super(entrance, entryList, title, symbol, value, consumer);
            this.entryConsumer = entryConsumer;
        }

        @Override
        public void onCreate() {
            super.onCreate();
            this.button = this.addWidget(new Button((Entrance)this.getEntrance(), this.getInnerRight() - 72, this.getTop(), 72, 20, Text.empty()));
            this.entryConsumer.accept(this, (ButtonEntry)this.getItem());
            this.titleTextWidget.setWidth(this.getInnerRight() - this.getInnerLeft() - 8 - this.button.getWidth());
        }

        @Override
        public void setItem(T item) {
            super.setItem(item);
            this.entryConsumer.accept(this, (ButtonEntry)item);
        }

        public Button getButton() {
            return this.button;
        }
    }

    public static abstract class SettingsEntry<T>
    extends Entry<T> {
        protected TextSlot textSlot;
        protected AbstractWidget titleTextWidget;
        protected Button altButton;
        private Text symbol;
        private Consumer<T> consumer;

        protected SettingsEntry(Entrance entrance, SettingOptionsList entryList, Text title, Text symbol, T value, Consumer<T> consumer) {
            super(entrance, entryList, value);
            super.setMessage(title);
            this.symbol = symbol;
            this.consumer = consumer;
        }

        @Override
        public void onCreate() {
            this.textSlot = this.addWidget(new TextSlot((Entrance)this.getEntrance(), this.getLeft() + 1, this.getTop() + 1, 18, 18, Text.empty(), this.getSymbol()));
            this.textSlot.setVisible(this.getEntryList().isShowIcon());
            this.altButton = this.addWidget(new Button((Entrance)this.getEntrance(), this.getRight() - 20, this.getTop(), 20, 20, Text.empty()));
            this.altButton.setVisible(this.getEntryList().isShowButton());
            this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getInnerLeft() + 4, this.getTop() + 6, this.getMessage()));
        }

        @Override
        public void setMessage(Text text) {
            super.setMessage(text);
            this.titleTextWidget.setMessage(this.getMessage());
        }

        public Text getSymbol() {
            return this.symbol;
        }

        public void setSymbol(Text symbol) {
            this.symbol = symbol;
            this.recreate();
        }

        public Button getAltButton() {
            return this.altButton;
        }

        public int getInnerLeft() {
            return this.getEntryList().isShowIcon() ? this.getLeft() + 20 : this.getLeft();
        }

        public int getInnerRight() {
            return this.getEntryList().isShowButton() ? this.getRight() - 20 : this.getRight();
        }

        @Override
        public int getHeight() {
            return 24;
        }

        @Override
        public void setItem(T item) {
            super.setItem(item);
            if (this.consumer != null) {
                this.consumer.accept(item);
            }
        }

        @Override
        public SettingOptionsList getEntryList() {
            return (SettingOptionsList)super.getEntryList();
        }

        public void setConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public AbstractWidget getTitleTextWidget() {
            return this.titleTextWidget;
        }
    }

    public static abstract class Entry<T>
    extends EditableEntryList.Entry<T> {
        protected Entry(Entrance entrance, T item) {
            super(entrance, item);
        }

        protected Entry(Entrance entrance, EntryList entryList, T item) {
            super(entrance, entryList, item);
        }
    }
}

