/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.pattern;

import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.Dimens;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.api.text.Text;
import java.awt.Color;

public class RadialTextIcon
extends AbstractWidget {
    private int index;

    public RadialTextIcon(Entrance entrance, int x, int y, int width, int height, int index, Text message) {
        super(entrance, x, y, width, height, message);
        this.index = index;
    }

    private static void renderRadialSlices(Renderer renderer, double middleX, double middleY, double ringInnerEdge, double ringOuterEdge, int selected) {
        int totalModes = MathUtils.max(3, 12);
        double innerGap = 0.12566370614359174;
        double outerGap = innerGap * ringInnerEdge / ringOuterEdge;
        double rad = Math.PI * 2 / (double)totalModes;
        for (int i = 0; i < 12; ++i) {
            double begRad = ((double)i - 0.5) * rad - 1.5707963267948966;
            double endRad = ((double)i + 0.5) * rad - 1.5707963267948966;
            double x1m1 = MathUtils.cos(begRad + innerGap) * ringInnerEdge;
            double x2m1 = MathUtils.cos(endRad - innerGap) * ringInnerEdge;
            double y1m1 = MathUtils.sin(begRad + innerGap) * ringInnerEdge;
            double y2m1 = MathUtils.sin(endRad - innerGap) * ringInnerEdge;
            double x1m2 = MathUtils.cos(begRad + outerGap) * ringOuterEdge;
            double x2m2 = MathUtils.cos(endRad - outerGap) * ringOuterEdge;
            double y1m2 = MathUtils.sin(begRad + outerGap) * ringOuterEdge;
            double y2m2 = MathUtils.sin(endRad - outerGap) * ringOuterEdge;
            Color color = Dimens.CellRing.RADIAL_COLOR;
            if (selected % 12 == i) {
                color = Dimens.CellRing.HIGHLIGHT_COLOR;
            }
            renderer.renderQuad((int)(middleX + x1m1), (int)(middleY + y1m1), (int)(middleX + x2m1), (int)(middleY + y2m1), (int)(middleX + x2m2), (int)(middleY + y2m2), (int)(middleX + x1m2), (int)(middleY + y1m2), 0, color.getRGB());
        }
    }

    @Override
    public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
        super.renderWidget(renderer, mouseX, mouseY, deltaTick);
        renderer.renderRect(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -1620284308);
        RadialTextIcon.renderRadialSlices(renderer, this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, 6.0, 15.0, this.index + 1);
        renderer.pushPose();
        renderer.translate((float)this.getX() + (float)this.getWidth() / 2.0f + 1.0f, (float)this.getY() + (float)this.getHeight() / 2.0f - 8.0f, 0.0f);
        renderer.scale(2.0f, 2.0f, 0.0f);
        renderer.renderTextFromCenter(this.getTypeface(), this.getMessage(), 0, 0, -1, true);
        renderer.popPose();
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

