/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.general;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.PlayerInfo;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.screen.item.EffortlessItemsScreen;
import dev.huskuraft.effortless.screen.player.PlayerInfoList;
import dev.huskuraft.effortless.screen.settings.SettingOptionsList;
import dev.huskuraft.effortless.session.config.ConstraintConfig;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class EffortlessPlayerGeneralSettingsScreen
extends AbstractPanelScreen {
    private final PlayerInfo playerInfo;
    private final BiConsumer<PlayerInfo, ConstraintConfig> consumer;
    private ConstraintConfig defaultConfig;
    private ConstraintConfig originalConfig;
    private ConstraintConfig config;
    private ConstraintConfig globalConfig;
    private AbstractWidget resetButton;
    private AbstractWidget saveButton;

    public EffortlessPlayerGeneralSettingsScreen(Entrance entrance, PlayerInfo playerInfo, ConstraintConfig config, BiConsumer<PlayerInfo, ConstraintConfig> consumer) {
        super(entrance, Text.translate("effortless.general_settings.title"), 264, 238);
        this.playerInfo = playerInfo;
        this.defaultConfig = ConstraintConfig.NULL;
        this.originalConfig = config;
        this.config = config;
        this.globalConfig = this.getEntrance().getSessionManager().getServerSessionConfigOrEmpty().getGlobalConfig();
        this.consumer = consumer;
    }

    @Override
    public void onCreate() {
        TextWidget titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        PlayerInfoList playerEntries = this.addWidget(new PlayerInfoList((Entrance)this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, 36, true));
        playerEntries.setShowScrollBar(false);
        playerEntries.setRenderSelection(false);
        playerEntries.reset(List.of(this.playerInfo));
        SettingOptionsList entries = this.addWidget(new SettingOptionsList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + playerEntries.getHeight() + 4, this.getWidth() - 12 - 8, this.getHeight() - 18 - playerEntries.getHeight() - 4 - 30, false, true));
        entries.setAlwaysShowScrollbar(true);
        this.bindEntry(entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_use_mod"), null, null, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), (Boolean)value, this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockPlaceVolume(), this.config.maxBlockBreakVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.allowUseMod(), () -> this.config.allowUseMod());
        this.bindEntry(entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_break_blocks"), null, null, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), (Boolean)value, this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.allowBreakBlocks(), () -> this.config.allowBreakBlocks());
        this.bindEntry(entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_place_blocks"), null, null, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), (Boolean)value, this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.allowPlaceBlocks(), () -> this.config.allowPlaceBlocks());
        this.bindEntry(entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_interact_blocks"), null, null, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), (Boolean)value, this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.allowInteractBlocks(), () -> this.config.allowInteractBlocks());
        this.bindEntry(entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_copy_paste_structures"), null, null, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), (Boolean)value, this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.allowCopyPasteStructures(), () -> this.config.allowCopyPasteStructures());
        this.bindEntry(entries.addSwitchEntry(Text.translate("effortless.general_settings.use_proper_tools"), null, null, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), (Boolean)value, this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.useProperToolsOnly(), () -> this.config.useProperToolsOnly());
        this.bindEntry(entries.addIntegerEntry(Text.translate("effortless.general_settings.max_reach_distance"), null, 0, 0, Short.MAX_VALUE, 8, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), (Integer)value, this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.maxReachDistance(), () -> this.config.maxReachDistance());
        this.bindEntry(entries.addIntegerEntry(Text.translate("effortless.general_settings.max_block_break_volume"), null, 0, 0, 1000000, 100, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), (Integer)value, this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.maxBlockBreakVolume(), () -> this.config.maxBlockBreakVolume());
        this.bindEntry(entries.addIntegerEntry(Text.translate("effortless.general_settings.max_block_place_volume"), null, 0, 0, 1000000, 100, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), (Integer)value, this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.maxBlockPlaceVolume(), () -> this.config.maxBlockPlaceVolume());
        this.bindEntry(entries.addIntegerEntry(Text.translate("effortless.general_settings.max_block_interact_volume"), null, 0, 0, 1000000, 100, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), (Integer)value, this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.maxBlockInteractVolume(), () -> this.config.maxBlockInteractVolume());
        this.bindEntry(entries.addIntegerEntry(Text.translate("effortless.general_settings.max_structure_copy_paste_volume"), null, 0, 0, 1000000, 100, null), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), (Integer)value, this.config.whitelistedItems(), this.config.blacklistedItems());
        }, () -> this.globalConfig.maxStructureCopyPasteVolume(), () -> this.config.maxStructureCopyPasteVolume());
        this.bindEntry(entries.addTab(Text.translate("effortless.general_settings.whitelisted_items"), null, null, null, (entry, value) -> {
            entry.getButton().setOnPressListener(button1 -> new EffortlessItemsScreen((Entrance)this.getEntrance(), Text.translate("effortless.general_settings.whitelisted_items"), value.stream().map(Item::fromId).toList(), value1 -> entry.setItem(value1.stream().map(Item::getId).toList())).attach());
            entry.getButton().setMessage(Text.translate("effortless.general_settings.items", value == null ? null : Integer.valueOf(value.size())));
        }), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), (List<ResourceLocation>)value, this.config.blacklistedItems());
        }, () -> this.globalConfig.whitelistedItems(), () -> this.config.whitelistedItems());
        this.bindEntry(entries.addTab(Text.translate("effortless.general_settings.blacklisted_items"), null, null, null, (entry, value) -> {
            entry.getButton().setOnPressListener(button1 -> new EffortlessItemsScreen((Entrance)this.getEntrance(), Text.translate("effortless.general_settings.blacklisted_items"), value.stream().map(Item::fromId).toList(), value1 -> entry.setItem(value1.stream().map(Item::getId).toList())).attach());
            entry.getButton().setMessage(Text.translate("effortless.general_settings.items", value == null ? null : Integer.valueOf(value.size())));
        }), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), (List<ResourceLocation>)value);
        }, () -> this.globalConfig.blacklistedItems(), () -> this.config.blacklistedItems());
        this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.33333334f).build());
        this.resetButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.reset"), button -> {
            this.config = this.defaultConfig;
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.33333334f, 0.33333334f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.save"), button -> {
            this.consumer.accept(this.playerInfo, this.config);
            this.detach();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.6666667f, 0.33333334f).build());
        this.resetButton.setActive(false);
    }

    @Override
    public void onReload() {
        this.resetButton.setActive(!this.config.equals(this.defaultConfig));
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    private <T> void bindEntryState(SettingOptionsList.SettingsEntry<T> entry, Consumer<T> setter, Supplier<T> globalGetter, Supplier<T> playerGetter) {
        boolean isGlobal = playerGetter.get() == null;
        entry.children().forEach(child -> child.setActive(!isGlobal));
        entry.getAltButton().setActive(true);
        entry.getTitleTextWidget().setMessage(entry.getTitleTextWidget().getMessage().withStyle(isGlobal ? ChatFormatting.ITALIC : ChatFormatting.RESET, isGlobal ? ChatFormatting.GRAY : ChatFormatting.WHITE));
        entry.setConsumer(null);
        entry.setItem(isGlobal ? globalGetter.get() : playerGetter.get());
        entry.setConsumer(setter);
        entry.getAltButton().setMessage(isGlobal ? "O" : "X");
        entry.getAltButton().setTooltip(isGlobal ? "Click to Override" : "Click to Use Global");
    }

    private <T> void bindEntry(SettingOptionsList.SettingsEntry<T> entry, Consumer<T> setter, Supplier<T> globalGetter, Supplier<T> playerGetter) {
        this.bindEntryState(entry, setter, globalGetter, playerGetter);
        entry.getAltButton().setOnPressListener(button -> {
            setter.accept(playerGetter.get() == null ? (Object)globalGetter.get() : null);
            this.bindEntryState(entry, setter, globalGetter, playerGetter);
        });
    }
}

