/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.general;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.OfflinePlayerInfo;
import dev.huskuraft.effortless.api.core.PlayerInfo;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.screen.general.EffortlessPlayerGeneralSettingsScreen;
import dev.huskuraft.effortless.screen.player.EffortlessOnlinePlayersScreen;
import dev.huskuraft.effortless.screen.player.PlayerInfoList;
import dev.huskuraft.effortless.session.config.ConstraintConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EffortlessPlayerGeneralSettingsListScreen
extends AbstractPanelScreen {
    private final Consumer<Map<UUID, ConstraintConfig>> consumer;
    private Map<UUID, ConstraintConfig> defaultConfig = new LinkedHashMap<UUID, ConstraintConfig>();
    private Map<UUID, ConstraintConfig> originalConfig;
    private Map<UUID, ConstraintConfig> config;
    private PlayerInfoList entries;
    private Button editButton;
    private Button deleteButton;
    private Button addButton;
    private Button saveButton;
    private Button cancelButton;

    public EffortlessPlayerGeneralSettingsListScreen(Entrance entrance, Map<UUID, ConstraintConfig> config, Consumer<Map<UUID, ConstraintConfig>> editConsumer) {
        super(entrance, Text.translate("effortless.player_general_settings.title"), 264, 238);
        this.originalConfig = new LinkedHashMap<UUID, ConstraintConfig>(config);
        this.config = new LinkedHashMap<UUID, ConstraintConfig>(config);
        this.consumer = editConsumer;
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onCreate() {
        TextWidget titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.editButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.edit"), button -> {
            if (this.entries.hasSelected()) {
                new EffortlessPlayerGeneralSettingsScreen((Entrance)this.getEntrance(), (PlayerInfo)((EditableEntryList.Entry)this.entries.getSelected()).getItem(), this.config.getOrDefault(((PlayerInfo)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).getId(), ConstraintConfig.NULL), (playerInfo1, config) -> {
                    this.entries.insertSelected(playerInfo1);
                    this.config.put(playerInfo1.getId(), (ConstraintConfig)config);
                    this.onReload();
                }).attach();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.33333334f).build());
        this.deleteButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.delete"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.deleteSelected();
                this.onReload();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.33333334f, 0.33333334f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.add"), button -> new EffortlessOnlinePlayersScreen((Entrance)this.getEntrance(), playerInfo -> new EffortlessPlayerGeneralSettingsScreen((Entrance)this.getEntrance(), (PlayerInfo)playerInfo, this.config.getOrDefault(playerInfo.getId(), ConstraintConfig.NULL), (playerInfo1, config) -> {
            this.entries.insertSelected(playerInfo1);
            this.config.put(playerInfo1.getId(), (ConstraintConfig)config);
            this.onReload();
        }).attach()).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.6666667f, 0.33333334f).build());
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.save"), button -> {
            this.consumer.accept(this.config);
            this.detachAll();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        this.entries = this.addWidget(new PlayerInfoList((Entrance)this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12 - 8, this.getHeight() - 18 - 54, true));
        this.entries.reset(this.getConfigurablePlayers());
        this.entries.setAlwaysShowScrollbar(true);
    }

    @Override
    public void onReload() {
        this.deleteButton.setActive(this.entries.hasSelected());
        this.editButton.setActive(this.entries.hasSelected());
        this.config = this.entries.items().stream().map(PlayerInfo::getId).collect(Collectors.toMap(Function.identity(), this.config::get, (e1, e2) -> e1, LinkedHashMap::new));
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected()) {
            new EffortlessPlayerGeneralSettingsScreen((Entrance)this.getEntrance(), (PlayerInfo)((EditableEntryList.Entry)this.entries.getSelected()).getItem(), this.config.getOrDefault(((PlayerInfo)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).getId(), ConstraintConfig.NULL), (playerInfo1, config) -> {
                this.entries.insertSelected(playerInfo1);
                this.config.put(playerInfo1.getId(), (ConstraintConfig)config);
                this.onReload();
            }).attach();
        }
    }

    public List<PlayerInfo> getConfigurablePlayers() {
        Map id2Players = this.getEntrance().getClient().getOnlinePlayers().stream().collect(Collectors.toMap(PlayerInfo::getId, Function.identity()));
        return this.config.keySet().stream().map(id -> id2Players.computeIfAbsent((UUID)id, OfflinePlayerInfo::new)).collect(Collectors.toList());
    }
}

