/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.general;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.gui.tooltip.TooltipHelper;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.networking.packets.player.PlayerPermissionCheckPacket;
import dev.huskuraft.effortless.screen.general.EffortlessGlobalGeneralSettingsScreen;
import dev.huskuraft.effortless.screen.general.EffortlessPlayerGeneralSettingsListScreen;
import dev.huskuraft.effortless.screen.settings.EffortlessNotAnOperatorScreen;
import dev.huskuraft.effortless.screen.settings.EffortlessSessionStatusScreen;
import dev.huskuraft.effortless.session.config.ConstraintConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public class EffortlessGeneralSettingsScreen
extends AbstractPanelScreen {
    private Button globalButton;
    private Button playerButton;

    public EffortlessGeneralSettingsScreen(Entrance entrance) {
        super(entrance, Text.translate("effortless.general_settings.title"), 192, 96);
    }

    @Override
    public void onCreate() {
        this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.globalButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.global_general_settings.title"), button -> {
            if (!this.getEntrance().getSessionManager().isSessionValid()) {
                this.getEntrance().getClient().execute(() -> new EffortlessSessionStatusScreen(this.getEntrance()).attach());
            } else {
                this.getEntrance().getChannel().sendPacket(new PlayerPermissionCheckPacket(this.getEntrance().getClient().getPlayer().getId()), packet -> {
                    if (packet.granted()) {
                        this.getEntrance().getClient().execute(() -> new EffortlessGlobalGeneralSettingsScreen(this.getEntrance(), this.getEntrance().getSessionManager().getServerSessionConfigOrEmpty().getGlobalConfig(), config -> this.getEntrance().getSessionManager().updateGlobalConfig((ConstraintConfig)config)).attach());
                    } else {
                        this.getEntrance().getClient().execute(() -> new EffortlessNotAnOperatorScreen(this.getEntrance()).attach());
                    }
                });
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 2.0f, 0.0f, 1.0f).build());
        this.playerButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.player_general_settings.title"), button -> this.getEntrance().getChannel().sendPacket(new PlayerPermissionCheckPacket(this.getEntrance().getClient().getPlayer().getId()), packet -> {
            if (!this.getEntrance().getSessionManager().isSessionValid()) {
                this.getEntrance().getClient().execute(() -> new EffortlessSessionStatusScreen(this.getEntrance()).attach());
            } else if (packet.granted()) {
                this.getEntrance().getClient().execute(() -> new EffortlessPlayerGeneralSettingsListScreen(this.getEntrance(), this.getEntrance().getSessionManager().getServerSessionConfigOrEmpty().playerConfigs(), playerConfigs -> this.getEntrance().getSessionManager().updatePlayerConfig((Map<UUID, ConstraintConfig>)playerConfigs)).attach());
            } else {
                this.getEntrance().getClient().execute(() -> new EffortlessNotAnOperatorScreen(this.getEntrance()).attach());
            }
        })).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 1.0f).build());
        this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.done"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 1.0f).build());
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onReload() {
        ArrayList<Text> globalTooltip = new ArrayList<Text>();
        globalTooltip.add(Text.translate("effortless.global_general_settings.title").withStyle(ChatFormatting.WHITE));
        globalTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            globalTooltip.add(Text.empty());
            globalTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.global_general_settings.tooltip", Text.text("[%s]".formatted("effortless.toml")).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.GRAY)));
        }
        this.globalButton.setTooltip(globalTooltip);
        ArrayList<Text> playerTooltip = new ArrayList<Text>();
        playerTooltip.add(Text.translate("effortless.player_general_settings.title").withStyle(ChatFormatting.WHITE));
        playerTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            playerTooltip.add(Text.empty());
            playerTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.player_general_settings.tooltip", Text.text("[%s]".formatted("effortless.toml")).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.GRAY)));
        }
        this.playerButton.setTooltip(playerTooltip);
    }
}

