/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.clipboard;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.MessageTextWidget;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.gui.tooltip.TooltipHelper;
import dev.huskuraft.effortless.api.input.OptionKeys;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.clipboard.Clipboard;
import dev.huskuraft.effortless.building.clipboard.Snapshot;
import dev.huskuraft.effortless.networking.packets.player.PlayerSnapshotSharePacket;
import dev.huskuraft.effortless.screen.clipboard.EffortlessStructureSnapshotsHistoryScreen;
import dev.huskuraft.effortless.screen.clipboard.StructureSnapshotWidget;
import dev.huskuraft.effortless.screen.player.EffortlessOnlinePlayersScreen;
import java.util.function.Consumer;

public class EffortlessClipboardScreen
extends AbstractPanelScreen {
    private final Consumer<Clipboard> consumer = clipboard -> this.getEntrance().getStructureBuilder().setClipboard(this.getEntrance().getClient().getPlayer(), this.clipboard);
    private Clipboard clipboard = this.getEntrance().getStructureBuilder().getContext(this.getEntrance().getClient().getPlayer()).clipboard();
    private AbstractWidget titleTextWidget;
    private MessageTextWidget textWidget;
    private StructureSnapshotWidget snapshotWidget;
    private Button enableButton;
    private Button doneButton;
    private Button libraryButton;
    private Button historyButton;
    private Button playerSharingButton;
    private Button clearButton;
    private Button editButton;
    private Button shareButton;

    public EffortlessClipboardScreen(Entrance entrance) {
        super(entrance, Text.translate("effortless.clipboard.edit.title"), 264, 238);
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    protected Player getPlayer() {
        return this.getEntrance().getClient().getPlayer();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.snapshotWidget = this.addWidget(new StructureSnapshotWidget((Entrance)this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, this.getHeight() - 18 - 54, this.clipboard.snapshot()));
        this.textWidget = this.addWidget(new MessageTextWidget(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, this.getHeight() - 18 - 54, Text.translate("effortless.clipboard.no_structure"), MessageTextWidget.Gravity.CENTER));
        this.editButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.edit"), button -> {}).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.75f, 0.25f).build());
        this.shareButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.share"), button -> new EffortlessOnlinePlayersScreen((Entrance)this.getEntrance(), playerInfo -> {
            this.getEntrance().getChannel().sendPacket(new PlayerSnapshotSharePacket(this.getPlayer().getId(), playerInfo.getId(), this.clipboard.snapshot()));
            this.detach();
        }).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.25f, 0.25f).build());
        this.clearButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.clear"), button -> {
            this.clipboard = this.clipboard.withSnapshot(Snapshot.EMPTY);
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.5f, 0.25f).build());
        this.historyButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.history"), button -> new EffortlessStructureSnapshotsHistoryScreen((Entrance)this.getEntrance(), snapshot -> {
            this.clipboard = this.clipboard.withSnapshot((Snapshot)snapshot);
        }).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.25f).build());
        this.doneButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.done"), button -> this.detachAll()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.enableButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), this.clipboard.enabled() ? Text.translate("effortless.clipboard.button.disable") : Text.translate("effortless.clipboard.button.enable"), button -> {
            this.clipboard = this.clipboard.withEnabled(!this.clipboard.enabled());
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
    }

    @Override
    public void onReload() {
        this.snapshotWidget.setSnapshot(this.clipboard.snapshot());
        this.consumer.accept(this.clipboard);
        this.textWidget.setVisible(this.clipboard.isEmpty());
        this.historyButton.setTooltip(TooltipHelper.makeSummary(this.getTypeface(), Text.translate("effortless.button.history"), Text.translate("effortless.clipboard.history.tooltip")));
        this.shareButton.setTooltip(TooltipHelper.makeSummary(this.getTypeface(), Text.translate("effortless.button.share"), Text.translate("effortless.clipboard.share.tooltip")));
        this.shareButton.setActive(!this.clipboard.isEmpty());
        this.clearButton.setTooltip(TooltipHelper.makeSummary(this.getTypeface(), Text.translate("effortless.button.clear"), Text.translate("effortless.clipboard.clear.tooltip")));
        this.clearButton.setActive(!this.clipboard.isEmpty());
        this.editButton.setTooltip(TooltipHelper.makeSummary(this.getTypeface(), Text.translate("effortless.button.edit"), Text.translate("effortless.clipboard.edit.tooltip")));
        this.editButton.setActive(!this.clipboard.isEmpty());
        this.enableButton.setTooltip(TooltipHelper.makeSummary(this.getTypeface(), this.clipboard.enabled() ? Text.translate("effortless.clipboard.button.disable") : Text.translate("effortless.clipboard.button.enable"), Text.translate("effortless.clipboard.enable_clipboard.tooltip", OptionKeys.KEY_ATTACK.getKeyBinding().getKey().getNameText(), OptionKeys.KEY_USE.getKeyBinding().getKey().getNameText())));
    }
}

