/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.tooltip;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.AxisDirection;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.core.Tuple2;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.api.text.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class TooltipRenderer {
    private final Entrance entrance;
    private final Map<Integer, Map<Object, Entry>> prioritiedMap = new TreeMap(Comparator.naturalOrder());

    public TooltipRenderer(Entrance entrance) {
        this.entrance = entrance;
    }

    public EffortlessClient getEntrance() {
        return (EffortlessClient)this.entrance;
    }

    public void showGroupEntry(Object id, int priority, List<Object> entry, boolean immediate) {
        List<Entry> entries = entry.stream().map(object -> {
            List list;
            if (object instanceof List && !(list = (List)object).isEmpty()) {
                Object patt0$temp = list.get(0);
                if (patt0$temp instanceof Text) {
                    Text text = (Text)patt0$temp;
                    return new ComponentsEntry(this, Collections.singletonList(text));
                }
                Object patt1$temp = list.get(0);
                if (patt1$temp instanceof Tuple2) {
                    Tuple2 tuple2 = (Tuple2)patt1$temp;
                    if (tuple2.value1() instanceof Text && tuple2.value2() instanceof Text) {
                        return new ComponentPairEntry(this, list);
                    }
                } else if (list.get(0) instanceof ItemStack) {
                    return new ItemsEntry(this, list);
                }
            } else {
                Tuple2 tuple2;
                Object patt0$temp;
                if (object instanceof Text) {
                    Text text = (Text)object;
                    return new ComponentsEntry(this, Collections.singletonList(text));
                }
                if (object instanceof ResourceLocation) {
                    ResourceLocation icon = (ResourceLocation)object;
                    return new IconEntry(this, icon);
                }
                if (object instanceof Tuple2 && (patt0$temp = (tuple2 = (Tuple2)object).value1()) instanceof List) {
                    List list2 = (List)patt0$temp;
                    Object patt1$temp = tuple2.value2();
                    if (patt1$temp instanceof Integer) {
                        Integer color = (Integer)patt1$temp;
                        if (!list2.isEmpty() && list2.get(0) instanceof ItemStack) {
                            return new ItemsEntry(this, list2, color);
                        }
                    }
                }
            }
            return null;
        }).filter(Objects::nonNull).toList();
        this.showEntry(id, priority, new GroupEntry(this, entries), immediate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEntry(Object id, int priority, Entry entry, boolean immediate) {
        Map<Integer, Map<Object, Entry>> map = this.prioritiedMap;
        synchronized (map) {
            this.prioritiedMap.compute(priority, (k, entry1) -> {
                if (entry1 == null) {
                    entry1 = new LinkedHashMap<Object, Entry>();
                }
                entry1.compute(id, (k1, v1) -> {
                    if (v1 != null && !immediate) {
                        if (v1.ticksTillRemoval < 10) {
                            entry.ticksAlive = (int)(10.0 * (MathUtils.lerp(1.0 * (double)v1.ticksTillRemoval / 10.0, 0.0, 1.0) * MathUtils.lerp(1.0 * (double)v1.ticksTillRemoval / 10.0, 0.0, 1.0)));
                            entry.ticksTillRemoval = 30;
                        } else {
                            entry.ticksAlive = v1.ticksAlive;
                        }
                    }
                    if (immediate) {
                        entry.ticksAlive = 10;
                    }
                    return entry;
                });
                return entry1;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideEntry(Object id, int priority, boolean immediate) {
        Map<Integer, Map<Object, Entry>> map = this.prioritiedMap;
        synchronized (map) {
            if (immediate) {
                ((Map)this.prioritiedMap.getOrDefault(priority, new LinkedHashMap())).remove(id);
            } else {
                ((Map)this.prioritiedMap.getOrDefault(priority, new LinkedHashMap())).computeIfPresent(id, (k, entry) -> {
                    entry.ticksTillRemoval = MathUtils.min(entry.ticksTillRemoval, 10);
                    entry.ticksAlive = 10;
                    return entry;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAllEntries(boolean immediate) {
        Map<Integer, Map<Object, Entry>> map = this.prioritiedMap;
        synchronized (map) {
            if (immediate) {
                this.prioritiedMap.clear();
            } else {
                for (Map<Object, Entry> value : this.prioritiedMap.values()) {
                    for (Entry entry : value.values()) {
                        entry.ticksTillRemoval = MathUtils.min(entry.ticksTillRemoval, 10);
                        entry.ticksAlive = 10;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Map<Integer, Map<Object, Entry>> map = this.prioritiedMap;
        synchronized (map) {
            Iterator<Map<Object, Entry>> iterator = this.prioritiedMap.values().iterator();
            while (iterator.hasNext()) {
                Map<Object, Entry> map2 = iterator.next();
                Iterator<Entry> iterator1 = map2.values().iterator();
                while (iterator1.hasNext()) {
                    Entry entry = iterator1.next();
                    entry.onTick();
                    if (entry.isAlive()) continue;
                    iterator1.remove();
                }
                if (!map2.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderGuiOverlay(Renderer renderer, float deltaTick) {
        AxisDirection contentSide = AxisDirection.POSITIVE;
        AxisDirection contentGravity = AxisDirection.NEGATIVE;
        renderer.pushPose();
        renderer.translate(0.0f, 0.0f, -200.0f);
        renderer.translate(0.0f, (float)renderer.getWindow().getGuiScaledHeight() * 1.0f, 0.0f);
        renderer.translate(-1.0f * (float)contentSide.getStep(), 0.0f, 0.0f);
        renderer.translate(0.0f, -8.0f, 0.0f);
        Map<Integer, Map<Object, Entry>> map = this.prioritiedMap;
        synchronized (map) {
            for (Map<Object, Entry> map2 : this.prioritiedMap.values()) {
                Iterator<Entry> iterator = new LinkedList<Entry>(map2.values()).descendingIterator();
                while (iterator.hasNext()) {
                    float appearTicks;
                    Entry entry = iterator.next();
                    if (!entry.isVisible()) continue;
                    entry.setContentSide(contentGravity);
                    renderer.pushPose();
                    float removalTicks = (float)entry.ticksTillRemoval - deltaTick;
                    if (removalTicks < 10.0f) {
                        renderer.translate((float)entry.getWidth() * (MathUtils.lerp(removalTicks / 10.0f, 1.0f, 0.0f) * MathUtils.lerp(removalTicks / 10.0f, 1.0f, 0.0f)), 0.0f, 0.0f);
                    }
                    if ((appearTicks = (float)entry.ticksAlive + deltaTick) < 10.0f) {
                        renderer.translate((float)entry.getWidth() * (MathUtils.lerp(appearTicks / 10.0f, 1.0f, 0.0f) * MathUtils.lerp(appearTicks / 10.0f, 1.0f, 0.0f)), 0.0f, 0.0f);
                    }
                    if (contentSide == AxisDirection.POSITIVE) {
                        renderer.translate(renderer.getWindow().getGuiScaledWidth() - entry.getWidth(), 0.0f, 0.0f);
                    }
                    renderer.renderRect(0, 0, entry.getWidth(), -entry.getHeight() - 8, renderer.optionColor(0.8f * entry.getAlpha()));
                    renderer.translate(0.0f, -4.0f, 0.0f);
                    renderer.pushPose();
                    renderer.translate(entry.getPaddingX(), -entry.getPaddingY(), 0.0f);
                    entry.render(renderer, 0, 0, deltaTick);
                    renderer.popPose();
                    renderer.popPose();
                    renderer.translate(0.0f, -entry.getHeight(), 0.0f);
                    renderer.translate(0.0f, -10.0f, 0.0f);
                }
            }
        }
        renderer.popPose();
    }

    private class GroupEntry
    extends Entry {
        private final List<Entry> entries;

        public GroupEntry(TooltipRenderer tooltipRenderer, List<Entry> entries) {
            super(tooltipRenderer);
            this.entries = entries;
        }

        @Override
        public int getPaddingY() {
            return this.entries.stream().mapToInt(Entry::getPaddingY).max().orElse(0);
        }

        @Override
        public int getWidth() {
            return this.getContentWidth() + this.getPaddingX() * 2;
        }

        @Override
        public int getHeight() {
            return this.getContentHeight() + this.getPaddingY() * 2;
        }

        @Override
        public int getContentWidth() {
            return this.entries.stream().mapToInt(Entry::getWidth).max().orElse(0);
        }

        @Override
        public int getContentHeight() {
            return this.entries.stream().mapToInt(Entry::getHeight).sum();
        }

        @Override
        public boolean isVisible() {
            return this.entries.stream().anyMatch(AbstractWidget::isVisible);
        }

        @Override
        public void onTick() {
            super.onTick();
            for (Entry entry : this.entries) {
                entry.onTick();
            }
        }

        @Override
        public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
            for (Entry entry : this.entries) {
                if (!entry.isVisible()) continue;
                renderer.pushPose();
                renderer.pushPose();
                renderer.translate(entry.getPaddingX(), -entry.getPaddingY(), 0.0f);
                entry.render(renderer, 0, 0, deltaTick);
                renderer.popPose();
                renderer.popPose();
                renderer.translate(0.0f, -entry.getHeight(), 0.0f);
            }
        }

        @Override
        public void setContentSide(AxisDirection contentSide) {
            super.setContentSide(contentSide);
            for (Entry entry : this.entries) {
                entry.setContentSide(contentSide);
            }
        }
    }

    private abstract class Entry
    extends AbstractWidget {
        private static final int FADE_TICKS = 10;
        private static final int ALIVE_TICKS = 30;
        private int ticksAlive = 0;
        private int ticksTillRemoval = 30;
        private AxisDirection contentSide = AxisDirection.POSITIVE;

        protected Entry(TooltipRenderer tooltipRenderer) {
            super(tooltipRenderer.entrance, Text.empty());
        }

        public int getContentWidth() {
            return 0;
        }

        public int getContentHeight() {
            return 0;
        }

        public int getPaddingX() {
            return 0;
        }

        public int getPaddingY() {
            return 0;
        }

        @Override
        public int getWidth() {
            return this.getContentWidth() + this.getPaddingX() * 2;
        }

        @Override
        public int getHeight() {
            return this.getContentHeight() + this.getPaddingY() * 2;
        }

        @Override
        public void onTick() {
            ++this.ticksAlive;
            --this.ticksTillRemoval;
        }

        public boolean isAlive() {
            return this.ticksTillRemoval >= 0;
        }

        public boolean isFading() {
            return this.ticksTillRemoval < 10 || this.ticksAlive < 10;
        }

        @Override
        public float getAlpha() {
            return this.isFading() ? MathUtils.min((float)this.ticksTillRemoval / 10.0f, (float)this.ticksAlive / 10.0f) : 1.0f;
        }

        public AxisDirection getContentSide() {
            return this.contentSide;
        }

        public void setContentSide(AxisDirection contentSide) {
            this.contentSide = contentSide;
        }
    }

    private class ComponentsEntry
    extends Entry {
        private final List<Text> texts;

        public ComponentsEntry(TooltipRenderer tooltipRenderer, Collection<Text> texts) {
            super(tooltipRenderer);
            ArrayList<Text> reverse = new ArrayList<Text>(texts);
            Collections.reverse(reverse);
            this.texts = reverse;
        }

        @Override
        public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
            super.renderWidget(renderer, mouseX, mouseY, deltaTick);
            renderer.translate(0.0f, 1.0f, 0.0f);
            int top = 0;
            for (Text text : this.texts) {
                renderer.renderTextFromStart(this.getTypeface(), text, this.getContentSide() == AxisDirection.POSITIVE ? this.getContentWidth() - this.getTypeface().measureWidth(text) : 0, top -= 10, -1, true);
            }
        }

        @Override
        public int getContentWidth() {
            return this.texts.stream().mapToInt(this.getTypeface()::measureWidth).max().orElse(0);
        }

        @Override
        public int getContentHeight() {
            return this.texts.size() * 10;
        }

        @Override
        public int getPaddingX() {
            return 10;
        }

        @Override
        public int getPaddingY() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return !this.texts.isEmpty();
        }
    }

    private class ComponentPairEntry
    extends Entry {
        private final List<Tuple2<Text, Text>> textPairs;

        public ComponentPairEntry(TooltipRenderer tooltipRenderer, Collection<Tuple2<Text, Text>> textPairs) {
            super(tooltipRenderer);
            ArrayList<Tuple2<Text, Text>> reverse = new ArrayList<Tuple2<Text, Text>>(textPairs);
            Collections.reverse(reverse);
            this.textPairs = reverse;
        }

        @Override
        public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
            super.renderWidget(renderer, mouseX, mouseY, deltaTick);
            renderer.translate(0.0f, 1.0f, 0.0f);
            int top = 0;
            for (Tuple2<Text, Text> textPair : this.textPairs) {
                renderer.renderTextFromStart(this.getTypeface(), textPair.value1(), 0, top -= 10, -1, true);
                renderer.renderTextFromStart(this.getTypeface(), textPair.value2(), this.getContentWidth() - this.getTypeface().measureWidth(textPair.value2()), top, -1, true);
            }
        }

        @Override
        public int getContentWidth() {
            return this.textPairs.stream().mapToInt(text -> this.getTypeface().measureWidth((Text)text.value1()) + this.getTypeface().measureWidth((Text)text.value2())).max().orElse(0) + this.getTypeface().measureWidth(" ");
        }

        @Override
        public int getContentHeight() {
            return this.textPairs.size() * 10;
        }

        @Override
        public int getPaddingX() {
            return 10;
        }

        @Override
        public int getPaddingY() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return !this.textPairs.isEmpty();
        }
    }

    public class ItemsEntry
    extends Entry {
        private static final int MAX_COLUMN = 9;
        private static final int ITEM_SPACING_X = 18;
        private static final int ITEM_SPACING_Y = 18;
        private final Collection<ItemStack> itemStacks;
        private final Integer color;

        public ItemsEntry(TooltipRenderer this$0, Collection<ItemStack> itemStacks, Integer color) {
            super(this$0);
            this.itemStacks = itemStacks;
            this.color = color;
        }

        public ItemsEntry(TooltipRenderer this$0, Collection<ItemStack> itemStacks) {
            super(this$0);
            this.itemStacks = itemStacks;
            this.color = null;
        }

        @Override
        public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
            super.renderWidget(renderer, mouseX, mouseY, deltaTick);
            int i = 0;
            int j = 0;
            for (ItemStack itemStack : this.itemStacks) {
                int x = this.getContentSide() == AxisDirection.NEGATIVE ? i * 18 : -(i + 1) * 18 + this.getContentWidth();
                int y = j * 18 - 18 * (int)MathUtils.ceil(1.0f * (float)this.itemStacks.size() / 9.0f);
                Text text = Text.text(String.valueOf(itemStack.getCount()));
                renderer.pushPose();
                renderer.translate(-1.0f, -1.0f, 0.0f);
                renderer.renderItem(itemStack, x + 1, y + 1);
                renderer.pushPose();
                renderer.translate(0.0f, 0.0f, 200.0f);
                renderer.renderText(this.getTypeface(), text, x + 19 - 2 - this.getTypeface().measureWidth(text), y + 6 + 3, this.color == null ? 0xFFFFFF : this.color, true);
                renderer.popPose();
                renderer.popPose();
                if (i < 8) {
                    ++i;
                    continue;
                }
                i = 0;
                ++j;
            }
        }

        @Override
        public int getContentWidth() {
            return MathUtils.min(9, this.itemStacks.size()) * 18 - 4;
        }

        @Override
        public int getContentHeight() {
            return (int)MathUtils.ceil(1.0f * (float)this.itemStacks.size() / 9.0f) * 18;
        }

        @Override
        public int getPaddingX() {
            return 10;
        }

        @Override
        public int getPaddingY() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    public class IconEntry
    extends Entry {
        private static final int MAX_COLUMN = 9;
        private static final int ITEM_SPACING_X = 18;
        private static final int ITEM_SPACING_Y = 18;
        private final ResourceLocation icon;

        public IconEntry(TooltipRenderer this$0, ResourceLocation icon) {
            super(this$0);
            this.icon = icon;
        }

        @Override
        public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
            super.renderWidget(renderer, mouseX, mouseY, deltaTick);
            renderer.pushPose();
            renderer.translate(0.0f, -18.0f, 200.0f);
            renderer.renderTexture(this.icon, 0, 0, 16, 16, 0.0f, 0.0f, 18, 18, 18, 18);
            renderer.popPose();
        }

        @Override
        public int getContentWidth() {
            return 18;
        }

        @Override
        public int getContentHeight() {
            return 18;
        }

        @Override
        public int getPaddingX() {
            return 10;
        }

        @Override
        public int getPaddingY() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    private class EmptyEntry
    extends Entry {
        private EmptyEntry(TooltipRenderer tooltipRenderer) {
            super(tooltipRenderer);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }

    private class TitledItemsEntry
    extends ItemsEntry {
        private final Text header;

        public TitledItemsEntry(TooltipRenderer tooltipRenderer, Text header, Collection<ItemStack> items) {
            super(tooltipRenderer, items);
            this.header = header;
        }

        @Override
        public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
            super.renderWidget(renderer, mouseX, mouseY, deltaTick);
            int positionX = this.getContentSide() == AxisDirection.POSITIVE ? this.getContentWidth() - this.getTypeface().measureWidth(this.header) : 0;
            renderer.renderTextFromStart(this.getTypeface(), this.header, positionX, -this.getContentHeight() + 1, -1, true);
        }

        @Override
        public int getContentHeight() {
            return super.getContentHeight() + 10;
        }

        @Override
        public int getContentWidth() {
            return MathUtils.max(super.getContentWidth(), this.getTypeface().measureWidth(this.header));
        }
    }
}

