/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.pattern;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.platform.ClientEntrance;
import dev.huskuraft.effortless.api.renderer.RenderLayer;
import dev.huskuraft.effortless.api.renderer.RenderUtils;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.opertaion.BlockRenderLayers;
import dev.huskuraft.effortless.renderer.outliner.OutlineRenderLayers;
import java.awt.Color;

public abstract class TransformerRenderer {
    private static final Color COLOR_PLANE = new Color(0, 0, 0, 72);
    private static final Color COLOR_LINE = new Color(0, 0, 0, 200);
    private static final Vector3d EPSILON = new Vector3d(0.001, 0.001, 0.001);
    private final ClientEntrance entrance;

    public EffortlessClient getEntrance() {
        return (EffortlessClient)this.entrance;
    }

    protected TransformerRenderer(ClientEntrance entrance) {
        this.entrance = entrance;
    }

    public abstract void render(Renderer var1, float var2);

    protected void renderRadialFloor(Renderer renderer, Vector3d center, Vector3d pos1, Vector3d pos2, int color) {
        Vector3d cam = renderer.getCamera().position();
        pos1 = pos1.sub(center);
        pos2 = pos2.sub(center);
        renderer.pushPose();
        renderer.translate(center.sub(cam));
        renderer.renderQuad(BlockRenderLayers.planes(), pos1, pos2, Vector3d.ZERO, Vector3d.ZERO, 0, color, null);
        renderer.popPose();
    }

    protected void renderRadialPlane(Renderer renderer, Vector3d pos1, Vector3d pos2, int length, Axis axis, int color) {
        Vector3d cam = renderer.getCamera().position();
        Vector3d min = switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> Vector3d.ZERO.withX(-length);
            case Axis.Y -> Vector3d.ZERO.withY(-length);
            case Axis.Z -> Vector3d.ZERO.withZ(-length);
        };
        Vector3d max = switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> pos2.sub(pos1).withX(length);
            case Axis.Y -> pos2.sub(pos1).withY(length);
            case Axis.Z -> pos2.sub(pos1).withZ(length);
        };
        renderer.pushPose();
        renderer.translate(pos1.sub(cam));
        Vector3d cen = Vector3d.ZERO;
        Vector3d v1 = Vector3d.ZERO;
        Vector3d v2 = Vector3d.ZERO;
        Vector3d v3 = Vector3d.ZERO;
        Vector3d v4 = Vector3d.ZERO;
        switch (axis) {
            case X: {
                v1 = new Vector3d(max.x(), max.y(), max.z());
                v2 = new Vector3d(min.x(), max.y(), max.z());
                v3 = new Vector3d(min.x(), min.y(), min.z());
                v4 = new Vector3d(max.x(), min.y(), min.z());
                break;
            }
            case Y: {
                v1 = new Vector3d(max.x(), max.y(), max.z());
                v2 = new Vector3d(max.x(), min.y(), max.z());
                v3 = new Vector3d(min.x(), min.y(), min.z());
                v4 = new Vector3d(min.x(), max.y(), min.z());
                break;
            }
            case Z: {
                v1 = new Vector3d(max.x(), max.y(), max.z());
                v2 = new Vector3d(max.x(), max.y(), min.z());
                v3 = new Vector3d(min.x(), min.y(), min.z());
                v4 = new Vector3d(min.x(), min.y(), max.z());
            }
        }
        renderer.renderQuad(BlockRenderLayers.planes(), v1, v2, v3, v4, 0, color, null);
        renderer.popPose();
    }

    protected void renderPlaneByAxis(Renderer renderer, Vector3d pos, Integer range, Axis axis, Color color) {
        Vector3d cam = renderer.getCamera().position();
        Vector3d min = new Vector3d(-range.intValue(), -range.intValue(), -range.intValue());
        Vector3d max = new Vector3d(range.intValue(), range.intValue(), range.intValue());
        renderer.pushPose();
        renderer.translate(pos.sub(cam));
        Vector3d cen = Vector3d.ZERO;
        Vector3d v1 = Vector3d.ZERO;
        Vector3d v2 = Vector3d.ZERO;
        Vector3d v3 = Vector3d.ZERO;
        Vector3d v4 = Vector3d.ZERO;
        switch (axis) {
            case Y: {
                v1 = new Vector3d(max.x(), cen.y(), max.z());
                v2 = new Vector3d(min.x(), cen.y(), max.z());
                v3 = new Vector3d(min.x(), cen.y(), min.z());
                v4 = new Vector3d(max.x(), cen.y(), min.z());
                break;
            }
            case Z: {
                v1 = new Vector3d(max.x(), min.y(), cen.z());
                v2 = new Vector3d(min.x(), min.y(), cen.z());
                v3 = new Vector3d(min.x(), max.y(), cen.z());
                v4 = new Vector3d(max.x(), max.y(), cen.z());
                break;
            }
            case X: {
                v1 = new Vector3d(cen.x(), min.y(), min.z());
                v2 = new Vector3d(cen.x(), min.y(), max.z());
                v3 = new Vector3d(cen.x(), max.y(), max.z());
                v4 = new Vector3d(cen.x(), max.y(), min.z());
            }
        }
        renderer.renderQuad(BlockRenderLayers.planes(), v1, v2, v3, v4, 0, color.getRGB(), null);
        renderer.popPose();
    }

    protected void renderFace(Renderer renderer, Direction direction, Vector3d p1, Vector3d p2, Vector3d p3, Vector3d p4, int color) {
        renderer.renderQuad(BlockRenderLayers.planes(), p1, p2, p3, p4, 0, color, null);
    }

    protected void renderBoundingBox(Renderer renderer, BoundingBox3d boundingBox3d, int color) {
        Vector3d cam = renderer.getCamera().position();
        Vector3d center = boundingBox3d.getCenter();
        BoundingBox3d box = boundingBox3d.move(center.mul(-1.0));
        Vector3d xyz = new Vector3d(box.minX(), box.minY(), box.minZ());
        Vector3d Xyz = new Vector3d(box.maxX(), box.minY(), box.minZ());
        Vector3d xYz = new Vector3d(box.minX(), box.maxY(), box.minZ());
        Vector3d XYz = new Vector3d(box.maxX(), box.maxY(), box.minZ());
        Vector3d xyZ = new Vector3d(box.minX(), box.minY(), box.maxZ());
        Vector3d XyZ = new Vector3d(box.maxX(), box.minY(), box.maxZ());
        Vector3d xYZ = new Vector3d(box.minX(), box.maxY(), box.maxZ());
        Vector3d XYZ = new Vector3d(box.maxX(), box.maxY(), box.maxZ());
        renderer.pushPose();
        renderer.translate(center.sub(cam));
        this.renderFace(renderer, Direction.NORTH, xYz, XYz, Xyz, xyz, color);
        this.renderFace(renderer, Direction.SOUTH, XYZ, xYZ, xyZ, XyZ, color);
        this.renderFace(renderer, Direction.EAST, XYz, XYZ, XyZ, Xyz, color);
        this.renderFace(renderer, Direction.WEST, xYZ, xYz, xyz, xyZ, color);
        this.renderFace(renderer, Direction.UP, xYZ, XYZ, XYz, xYz, color);
        this.renderFace(renderer, Direction.DOWN, xyz, Xyz, XyZ, xyZ, color);
        renderer.popPose();
    }

    protected void renderLine(Renderer renderer, Vector3d pos1, Vector3d pos2) {
        this.renderAACuboidLine(renderer, pos1, pos2, 0.03125f, 0xFFFFFF, true);
    }

    protected void renderLineByAxis(Renderer renderer, Vector3d pos, Integer range, Axis axis) {
        Vector3d min = pos.sub(range.intValue(), range.intValue(), range.intValue());
        Vector3d max = pos.add(range.intValue(), range.intValue(), range.intValue());
        Vector3d v1 = Vector3d.ZERO;
        Vector3d v2 = Vector3d.ZERO;
        switch (axis) {
            case Y: {
                v1 = new Vector3d(pos.x(), min.y(), pos.z());
                v2 = new Vector3d(pos.x(), max.y(), pos.z());
                break;
            }
            case Z: {
                v1 = new Vector3d(pos.x(), pos.y(), min.z());
                v2 = new Vector3d(pos.x(), pos.y(), max.z());
                break;
            }
            case X: {
                v1 = new Vector3d(min.x(), pos.y(), pos.z());
                v2 = new Vector3d(max.x(), pos.y(), pos.z());
            }
        }
        this.renderAACuboidLine(renderer, v1, v2, 0.03125f, 0xFFFFFF, true);
    }

    protected void renderAACuboidLine(Renderer renderer, Vector3d start, Vector3d end, float width, int color, boolean disableNormals) {
        Vector3d camera = renderer.getCamera().position();
        start = start.sub(camera);
        end = end.sub(camera);
        if (width == 0.0f) {
            return;
        }
        RenderLayer renderLayer = OutlineRenderLayers.outlineSolid();
        Vector3d diff = end.sub(start);
        if (diff.x() + diff.y() + diff.z() < 0.0) {
            Vector3d temp = start;
            start = end;
            end = temp;
            diff = diff.mul(-1.0);
        }
        Vector3d extension = diff.normalize().mul(width / 2.0f);
        Vector3d plane = RenderUtils.calculateAxisAlignedPlane(diff);
        Direction face = Direction.getNearest(diff.x(), diff.y(), diff.z());
        Axis axis = face.getAxis();
        start = start.sub(extension);
        end = end.add(extension);
        plane = plane.mul(width / 2.0f);
        Vector3d a1 = plane.add(start);
        Vector3d b1 = plane.add(end);
        plane = RenderUtils.rotate(plane, -90.0, axis);
        Vector3d a2 = plane.add(start);
        Vector3d b2 = plane.add(end);
        plane = RenderUtils.rotate(plane, -90.0, axis);
        Vector3d a3 = plane.add(start);
        Vector3d b3 = plane.add(end);
        plane = RenderUtils.rotate(plane, -90.0, axis);
        Vector3d a4 = plane.add(start);
        Vector3d b4 = plane.add(end);
        if (disableNormals) {
            face = Direction.UP;
            renderer.renderQuad(renderLayer, b4, b3, b2, b1, 240, color, face);
            renderer.renderQuad(renderLayer, a1, a2, a3, a4, 240, color, face);
            renderer.renderQuad(renderLayer, a1, b1, b2, a2, 240, color, face);
            renderer.renderQuad(renderLayer, a2, b2, b3, a3, 240, color, face);
            renderer.renderQuad(renderLayer, a3, b3, b4, a4, 240, color, face);
            renderer.renderQuad(renderLayer, a4, b4, b1, a1, 240, color, face);
            return;
        }
        renderer.renderQuad(renderLayer, b4, b3, b2, b1, 240, color, face);
        renderer.renderQuad(renderLayer, a1, a2, a3, a4, 240, color, face.getOpposite());
        Vector3d vec = a1.sub(a4);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a1, b1, b2, a2, 240, color, face);
        vec = RenderUtils.rotate(vec, -90.0, axis);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a2, b2, b3, a3, 240, color, face);
        vec = RenderUtils.rotate(vec, -90.0, axis);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a3, b3, b4, a4, 240, color, face);
        vec = RenderUtils.rotate(vec, -90.0, axis);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a4, b4, b1, a1, 240, color, face);
    }
}

