/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.pattern;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.platform.ClientEntrance;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.renderer.pattern.TransformerRenderer;
import java.awt.Color;

public class RadialTransformerRenderer
extends TransformerRenderer {
    private final RadialTransformer transformer;
    private final boolean renderPlanes;

    public RadialTransformerRenderer(ClientEntrance entrance, RadialTransformer transformer, boolean renderPlanes) {
        super(entrance);
        this.transformer = transformer;
        this.renderPlanes = renderPlanes;
    }

    @Override
    public void render(Renderer renderer, float deltaTick) {
        Axis axis = this.transformer.axis();
        Vector3d center0 = this.transformer.position();
        int radius = this.transformer.radius();
        int length = this.transformer.length();
        int planeColor = new Color(0, 0, 0, 72).getRGB();
        int sidePlaneColor = new Color(0, 0, 0, 112).getRGB();
        for (int i = 0; i < this.transformer.slices(); ++i) {
            double ang1 = Math.PI * 2 / (double)this.transformer.slices() * (double)i;
            Vector3d pos1 = switch (axis) {
                default -> throw new MatchException(null, null);
                case Axis.X -> center0.withY(center0.y() + (double)radius * Math.cos(ang1)).withZ(center0.z() + (double)radius * Math.sin(ang1));
                case Axis.Y -> center0.withX(center0.x() + (double)radius * Math.cos(ang1)).withZ(center0.z() + (double)radius * Math.sin(ang1));
                case Axis.Z -> center0.withX(center0.x() + (double)radius * Math.cos(ang1)).withY(center0.y() + (double)radius * Math.sin(ang1));
            };
            this.renderRadialPlane(renderer, center0, pos1, length, axis, planeColor);
        }
        Vector3d center1 = center0.add(axis == Axis.X ? (double)length : 0.0, axis == Axis.Y ? (double)length : 0.0, axis == Axis.Z ? (double)length : 0.0);
        Vector3d center2 = center0.sub(axis == Axis.X ? (double)length : 0.0, axis == Axis.Y ? (double)length : 0.0, axis == Axis.Z ? (double)length : 0.0);
        int slices = 8 * radius;
        for (int i = 0; i < slices; ++i) {
            double ang1 = Math.PI * 2 / (double)slices * (double)i;
            double ang2 = Math.PI * 2 / (double)slices * (double)(i + 1);
            Vector3d pos10 = switch (axis) {
                default -> throw new MatchException(null, null);
                case Axis.X -> center0.withY(center0.y() + (double)radius * Math.cos(ang1)).withZ(center0.z() + (double)radius * Math.sin(ang1));
                case Axis.Y -> center0.withX(center0.x() + (double)radius * Math.cos(ang1)).withZ(center0.z() + (double)radius * Math.sin(ang1));
                case Axis.Z -> center0.withX(center0.x() + (double)radius * Math.cos(ang1)).withY(center0.y() + (double)radius * Math.sin(ang1));
            };
            Vector3d pos20 = switch (axis) {
                default -> throw new MatchException(null, null);
                case Axis.X -> center0.withY(center0.y() + (double)radius * Math.cos(ang2)).withZ(center0.z() + (double)radius * Math.sin(ang2));
                case Axis.Y -> center0.withX(center0.x() + (double)radius * Math.cos(ang2)).withZ(center0.z() + (double)radius * Math.sin(ang2));
                case Axis.Z -> center0.withX(center0.x() + (double)radius * Math.cos(ang2)).withY(center0.y() + (double)radius * Math.sin(ang2));
            };
            this.renderRadialPlane(renderer, pos10, pos20, length, axis, planeColor);
            Vector3d pos1a = pos10.add(axis == Axis.X ? (double)length : 0.0, axis == Axis.Y ? (double)length : 0.0, axis == Axis.Z ? (double)length : 0.0);
            Vector3d pos1b = pos10.sub(axis == Axis.X ? (double)length : 0.0, axis == Axis.Y ? (double)length : 0.0, axis == Axis.Z ? (double)length : 0.0);
            Vector3d pos2a = pos20.add(axis == Axis.X ? (double)length : 0.0, axis == Axis.Y ? (double)length : 0.0, axis == Axis.Z ? (double)length : 0.0);
            Vector3d pos2b = pos20.sub(axis == Axis.X ? (double)length : 0.0, axis == Axis.Y ? (double)length : 0.0, axis == Axis.Z ? (double)length : 0.0);
            this.renderRadialFloor(renderer, center1, pos1a, pos2a, sidePlaneColor);
            this.renderRadialFloor(renderer, center2, pos1b, pos2b, sidePlaneColor);
            for (Axis value : Axis.values()) {
                if (value == axis) continue;
                this.renderLine(renderer, pos10, pos20);
                this.renderLine(renderer, pos1a, pos2a);
                this.renderLine(renderer, pos1b, pos2b);
            }
        }
        this.renderLineByAxis(renderer, center0, length, axis);
        for (Axis value : Axis.values()) {
            if (value == axis) continue;
            this.renderLineByAxis(renderer, center0, radius, value);
            this.renderLineByAxis(renderer, center1, radius, value);
            this.renderLineByAxis(renderer, center2, radius, value);
        }
    }
}

