/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.outliner;

import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.outliner.BlockBoundingBoxOutline;
import dev.huskuraft.effortless.renderer.outliner.BlockClusterOutline;
import dev.huskuraft.effortless.renderer.outliner.ChasingBlockBoundingBoxOutline;
import dev.huskuraft.effortless.renderer.outliner.LineOutline;
import dev.huskuraft.effortless.renderer.outliner.Outline;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class OutlineRenderer {
    private final Map<Object, OutlineEntry> outlines = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Object, OutlineEntry> outlinesView = Collections.unmodifiableMap(this.outlines);

    public Outline.OutlineParams showLine(Object id, Vector3d start, Vector3d end) {
        if (!this.outlines.containsKey(id)) {
            LineOutline outline = new LineOutline();
            this.outlines.put(id, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(id);
        entry.ticksTillRemoval = 1;
        ((LineOutline)entry.outline).set(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams endChasingLine(Object id, Vector3d start, Vector3d end, float chasingProgress, boolean lockStart) {
        if (!this.outlines.containsKey(id)) {
            LineOutline.EndChasingLineOutline outline = new LineOutline.EndChasingLineOutline(lockStart);
            this.outlines.put(id, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(id);
        entry.ticksTillRemoval = 1;
        ((LineOutline.EndChasingLineOutline)entry.outline).setProgress(chasingProgress).set(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams showBoundingBox(Object id, BoundingBox3d boundingBox, int ttl) {
        this.createBoundingBoxOutlineIfMissing(id, boundingBox);
        ChasingBlockBoundingBoxOutline outline = this.getAndRefreshBoundingBox(id, ttl);
        outline.targetBB = outline.bb = boundingBox;
        outline.prevBB = outline.bb;
        return outline.getParams();
    }

    public Outline.OutlineParams showBoundingBox(Object id, BoundingBox3d boundingBox) {
        this.createBoundingBoxOutlineIfMissing(id, boundingBox);
        ChasingBlockBoundingBoxOutline outline = this.getAndRefreshBoundingBox(id);
        outline.targetBB = outline.bb = boundingBox;
        outline.prevBB = outline.bb;
        return outline.getParams();
    }

    public Outline.OutlineParams chaseBoundingBox(Object id, BoundingBox3d boundingBox) {
        this.createBoundingBoxOutlineIfMissing(id, boundingBox);
        ChasingBlockBoundingBoxOutline outline = this.getAndRefreshBoundingBox(id);
        outline.targetBB = boundingBox;
        return outline.getParams();
    }

    public Outline.OutlineParams showCluster(Object id, Iterable<BlockPosition> selection) {
        BlockClusterOutline outline = new BlockClusterOutline(selection);
        OutlineEntry entry = new OutlineEntry(outline);
        this.outlines.put(id, entry);
        return entry.getOutline().getParams();
    }

    public void keep(Object id) {
        if (this.outlines.containsKey(id)) {
            this.outlines.get((Object)id).ticksTillRemoval = 1;
        }
    }

    public void keep(Object id, int ticks) {
        if (this.outlines.containsKey(id)) {
            this.outlines.get((Object)id).ticksTillRemoval = ticks;
        }
    }

    public void remove(Object id) {
        this.outlines.remove(id);
    }

    public Optional<Outline.OutlineParams> edit(Object id) {
        this.keep(id);
        if (this.outlines.containsKey(id)) {
            return Optional.of(this.outlines.get(id).getOutline().getParams());
        }
        return Optional.empty();
    }

    public Map<Object, OutlineEntry> getOutlines() {
        return this.outlinesView;
    }

    private void createBoundingBoxOutlineIfMissing(Object id, BoundingBox3d bb) {
        if (!this.outlines.containsKey(id) || !(this.outlines.get((Object)id).outline instanceof BlockBoundingBoxOutline)) {
            ChasingBlockBoundingBoxOutline outline = new ChasingBlockBoundingBoxOutline(bb);
            this.outlines.put(id, new OutlineEntry(outline));
        }
    }

    private ChasingBlockBoundingBoxOutline getAndRefreshBoundingBox(Object id) {
        OutlineEntry entry = this.outlines.get(id);
        entry.ticksTillRemoval = 1;
        return (ChasingBlockBoundingBoxOutline)entry.getOutline();
    }

    private ChasingBlockBoundingBoxOutline getAndRefreshBoundingBox(Object id, int ttl) {
        OutlineEntry entry = this.outlines.get(id);
        entry.ticksTillRemoval = ttl;
        return (ChasingBlockBoundingBoxOutline)entry.getOutline();
    }

    public void tick() {
        Iterator<OutlineEntry> iterator = this.outlines.values().iterator();
        while (iterator.hasNext()) {
            OutlineEntry entry = iterator.next();
            entry.tick();
            if (entry.isAlive()) continue;
            iterator.remove();
        }
    }

    public void render(Renderer renderer, float deltaTick) {
        this.outlines.forEach((key, entry) -> {
            Outline outline = entry.getOutline();
            Outline.OutlineParams params = outline.getParams();
            params.alpha = 1.0f;
            if (entry.isFading()) {
                int prevTicks = entry.ticksTillRemoval + 1;
                float fadeticks = 10.0f;
                float lastAlpha = prevTicks >= 0 ? 1.0f : 1.0f + (float)prevTicks / fadeticks;
                float currentAlpha = 1.0f + (float)entry.ticksTillRemoval / fadeticks;
                float alpha = MathUtils.lerp(deltaTick, lastAlpha, currentAlpha);
                params.alpha = alpha * alpha * alpha;
                if (params.alpha < 0.125f) {
                    return;
                }
            }
            outline.render(renderer, deltaTick);
        });
    }

    public static class OutlineEntry {
        private static final int FADE_TICKS = 10;
        private final Outline outline;
        private int ticksTillRemoval;

        public OutlineEntry(Outline outline) {
            this.outline = outline;
            this.ticksTillRemoval = 1;
        }

        public void tick() {
            --this.ticksTillRemoval;
            this.outline.tick();
        }

        public boolean isAlive() {
            return this.ticksTillRemoval >= -10;
        }

        public boolean isFading() {
            return this.ticksTillRemoval < 0;
        }

        public Outline getOutline() {
            return this.outline;
        }
    }
}

