/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.outliner;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.AxisDirection;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.renderer.RenderLayer;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.outliner.Outline;
import dev.huskuraft.effortless.renderer.outliner.OutlineRenderLayers;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BlockClusterOutline
extends Outline {
    private static Vector3d xyz = new Vector3d(-0.5, -0.5, -0.5);
    private static Vector3d Xyz = new Vector3d(0.5, -0.5, -0.5);
    private static Vector3d xYz = new Vector3d(-0.5, 0.5, -0.5);
    private static Vector3d XYz = new Vector3d(0.5, 0.5, -0.5);
    private static Vector3d xyZ = new Vector3d(-0.5, -0.5, 0.5);
    private static Vector3d XyZ = new Vector3d(0.5, -0.5, 0.5);
    private static Vector3d xYZ = new Vector3d(-0.5, 0.5, 0.5);
    private static Vector3d XYZ = new Vector3d(0.5, 0.5, 0.5);
    private final Cluster cluster = new Cluster();

    public BlockClusterOutline(Iterable<BlockPosition> selection) {
        selection.forEach(this.cluster::include);
    }

    @Override
    public void render(Renderer renderer, float deltaTick) {
        this.cluster.visibleEdges.forEach(edge -> {
            Vector3d start = edge.blockPosition.toVector3d();
            Direction direction = Direction.get(AxisDirection.POSITIVE, edge.axis);
            this.renderAACuboidLine(renderer, start, edge.blockPosition.relative(direction).toVector3d());
        });
        Optional<ResourceLocation> faceTexture = this.params.faceTexture;
        if (!faceTexture.isPresent()) {
            return;
        }
        RenderLayer renderLayer = OutlineRenderLayers.outlineTranslucent(faceTexture.get(), true);
        this.cluster.visibleFaces.forEach((face, axisDirection) -> {
            Direction direction = Direction.get(axisDirection, face.axis);
            BlockPosition pos = face.blockPosition;
            if (axisDirection == AxisDirection.POSITIVE) {
                pos = pos.relative(direction.getOpposite());
            }
            this.renderBlockFace(renderer, renderLayer, pos, direction);
        });
    }

    protected void renderBlockFace(Renderer renderer, RenderLayer renderLayer, BlockPosition blockPosition, Direction face) {
        Vector3d camera = renderer.getCamera().position();
        Vector3d center = blockPosition.getCenter();
        Vector3d offset = face.getNormal().toVector3d();
        offset = offset.mul(0.0078125);
        center = center.sub(camera).add(offset);
        renderer.pushPose();
        renderer.translate(center);
        switch (face) {
            case DOWN: {
                renderer.renderQuad(renderLayer, xyz, Xyz, XyZ, xyZ, this.params.getLightMap(), this.params.getColor().getRGB(), face);
                break;
            }
            case EAST: {
                renderer.renderQuad(renderLayer, XYz, XYZ, XyZ, Xyz, this.params.getLightMap(), this.params.getColor().getRGB(), face);
                break;
            }
            case NORTH: {
                renderer.renderQuad(renderLayer, xYz, XYz, Xyz, xyz, this.params.getLightMap(), this.params.getColor().getRGB(), face);
                break;
            }
            case SOUTH: {
                renderer.renderQuad(renderLayer, XYZ, xYZ, xyZ, XyZ, this.params.getLightMap(), this.params.getColor().getRGB(), face);
                break;
            }
            case UP: {
                renderer.renderQuad(renderLayer, xYZ, XYZ, XYz, xYz, this.params.getLightMap(), this.params.getColor().getRGB(), face);
                break;
            }
            case WEST: {
                renderer.renderQuad(renderLayer, xYZ, xYz, xyz, xyZ, this.params.getLightMap(), this.params.getColor().getRGB(), face);
            }
        }
        renderer.popPose();
    }

    private static class Cluster {
        private final Map<MergeEntry, AxisDirection> visibleFaces;
        private final Set<MergeEntry> visibleEdges = new HashSet<MergeEntry>();

        public Cluster() {
            this.visibleFaces = new HashMap<MergeEntry, AxisDirection>();
        }

        public void include(BlockPosition blockPosition) {
            for (Axis axis : Iterate.axes) {
                Direction direction = Direction.get(AxisDirection.POSITIVE, axis);
                int[] nArray = Iterate.zeroAndOne;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int offset = nArray[i];
                    MergeEntry entry = new MergeEntry(axis, blockPosition.relative(direction, offset));
                    if (this.visibleFaces.remove(entry) != null) continue;
                    this.visibleFaces.put(entry, offset == 0 ? AxisDirection.NEGATIVE : AxisDirection.POSITIVE);
                }
            }
            block2: for (Axis axis : Iterate.axes) {
                for (Axis axis2 : Iterate.axes) {
                    if (axis == axis2) continue;
                    for (Axis axis3 : Iterate.axes) {
                        if (axis == axis3 || axis2 == axis3) continue;
                        Direction direction = Direction.get(AxisDirection.POSITIVE, axis2);
                        Direction direction2 = Direction.get(AxisDirection.POSITIVE, axis3);
                        for (int offset : Iterate.zeroAndOne) {
                            BlockPosition entryPos = blockPosition.relative(direction, offset);
                            for (int offset2 : Iterate.zeroAndOne) {
                                MergeEntry entry = new MergeEntry(axis, entryPos = entryPos.relative(direction2, offset2));
                                if (this.visibleEdges.remove(entry)) continue;
                                this.visibleEdges.add(entry);
                            }
                        }
                    }
                    continue block2;
                }
            }
        }
    }

    private static class MergeEntry {
        private final Axis axis;
        private final BlockPosition blockPosition;

        public MergeEntry(Axis axis, BlockPosition blockPosition) {
            this.axis = axis;
            this.blockPosition = blockPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeEntry)) {
                return false;
            }
            MergeEntry other = (MergeEntry)o;
            return this.axis == other.axis && this.blockPosition.equals(other.blockPosition);
        }

        public int hashCode() {
            return this.blockPosition.hashCode() * 31 + this.axis.ordinal();
        }
    }

    private static class Iterate {
        public static final boolean[] trueAndFalse = new boolean[]{true, false};
        public static final boolean[] falseAndTrue = new boolean[]{false, true};
        public static final int[] zeroAndOne = new int[]{0, 1};
        public static final int[] positiveAndNegative = new int[]{1, -1};
        public static final Direction[] DIRECTIONS = Direction.values();
        public static final Direction[] HORIZONTAL_DIRECTION = Iterate.getHorizontals();
        public static final Axis[] axes = Axis.values();
        public static final EnumSet<Axis> axisSet = EnumSet.allOf(Axis.class);

        private Iterate() {
        }

        private static Direction[] getHorizontals() {
            Direction[] directions = new Direction[4];
            for (int i = 0; i < 4; ++i) {
                directions[i] = Direction.from2DDataValue(i);
            }
            return directions;
        }

        public static Direction[] directionsInAxis(Axis axis) {
            Direction[] directionArray;
            switch (axis) {
                case X: {
                    Direction[] directionArray2 = new Direction[2];
                    directionArray2[0] = Direction.EAST;
                    directionArray = directionArray2;
                    directionArray2[1] = Direction.WEST;
                    break;
                }
                case Y: {
                    Direction[] directionArray3 = new Direction[2];
                    directionArray3[0] = Direction.UP;
                    directionArray = directionArray3;
                    directionArray3[1] = Direction.DOWN;
                    break;
                }
                default: {
                    Direction[] directionArray4 = new Direction[2];
                    directionArray4[0] = Direction.SOUTH;
                    directionArray = directionArray4;
                    directionArray4[1] = Direction.NORTH;
                }
            }
            return directionArray;
        }

        public static List<BlockPosition> hereAndBelow(BlockPosition blockPosition) {
            return Arrays.asList(blockPosition, blockPosition.below());
        }

        public static List<BlockPosition> hereBelowAndAbove(BlockPosition blockPosition) {
            return Arrays.asList(blockPosition, blockPosition.below(), blockPosition.above());
        }
    }
}

