/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.opertaion.children;

import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import dev.huskuraft.effortless.building.operation.block.BlockOperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockOperationResultType;
import dev.huskuraft.effortless.renderer.opertaion.BlockRenderLayers;
import dev.huskuraft.effortless.renderer.opertaion.OperationsRenderer;
import dev.huskuraft.effortless.renderer.opertaion.children.OperationRenderer;
import java.awt.Color;
import java.util.List;

public class BlockOperationRenderer
implements OperationRenderer {
    public static final Color BLOCK_PLACE_SUCCESS_COLOR = new Color(255, 255, 255);
    public static final Color BLOCK_PLACE_INSUFFICIENT_COLOR = new Color(235, 0, 0);
    public static final Color BLOCK_PLACE_FAIL_COLOR = new Color(128, 128, 128);
    public static final Color BLOCK_BREAK_SUCCESS_COLOR = new Color(235, 0, 0);
    public static final Color BLOCK_BREAK_FAIL_COLOR = BLOCK_PLACE_FAIL_COLOR;
    public static final Color BLOCK_INTERACT_SUCCESS_COLOR = Color.YELLOW;
    public static final Color BLOCK_INTERACT_FAIL_COLOR = BLOCK_PLACE_FAIL_COLOR;
    public static final Color BLOCK_COPY_SUCCESS_COLOR = new Color(0, 235, 0);
    public static final Color BLOCK_COPY_FAIL_COLOR = BLOCK_PLACE_FAIL_COLOR;
    public static final Color BLOCK_HIDEEN_COLOR = null;
    private final BlockOperationResult result;

    public BlockOperationRenderer(OperationsRenderer operationsRenderer, BlockOperationResult result) {
        this.result = result;
    }

    public static Color getColorByOpResult(BlockOperationResult blockOperationResult) {
        switch (blockOperationResult.getOperation().getType()) {
            case UPDATE: {
                if (blockOperationResult.getBlockStateToBreak() == null || blockOperationResult.getBlockStateToPlace() == null) {
                    return BLOCK_HIDEEN_COLOR;
                }
                if (!blockOperationResult.getBlockStateToPlace().isAir()) {
                    return switch (blockOperationResult.result()) {
                        case BlockOperationResultType.SUCCESS, BlockOperationResultType.SUCCESS_PARTIAL, BlockOperationResultType.CONSUME -> BLOCK_PLACE_SUCCESS_COLOR;
                        case BlockOperationResultType.FAIL_PLACE_ITEM_INSUFFICIENT, BlockOperationResultType.FAIL_PLACE_ITEM_NOT_BLOCK -> BLOCK_PLACE_INSUFFICIENT_COLOR;
                        case BlockOperationResultType.FAIL_WORLD_HEIGHT, BlockOperationResultType.FAIL_WORLD_BORDER, BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM -> BLOCK_HIDEEN_COLOR;
                        default -> BLOCK_PLACE_FAIL_COLOR;
                    };
                }
                return switch (blockOperationResult.result()) {
                    case BlockOperationResultType.SUCCESS, BlockOperationResultType.SUCCESS_PARTIAL, BlockOperationResultType.CONSUME -> BLOCK_BREAK_SUCCESS_COLOR;
                    case BlockOperationResultType.FAIL_WORLD_HEIGHT, BlockOperationResultType.FAIL_WORLD_BORDER, BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM -> BLOCK_HIDEEN_COLOR;
                    default -> BLOCK_BREAK_FAIL_COLOR;
                };
            }
            case INTERACT: {
                return switch (blockOperationResult.result()) {
                    case BlockOperationResultType.SUCCESS, BlockOperationResultType.SUCCESS_PARTIAL, BlockOperationResultType.CONSUME -> BLOCK_INTERACT_SUCCESS_COLOR;
                    case BlockOperationResultType.FAIL_WORLD_HEIGHT, BlockOperationResultType.FAIL_WORLD_BORDER, BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM -> BLOCK_HIDEEN_COLOR;
                    default -> BLOCK_INTERACT_FAIL_COLOR;
                };
            }
            case COPY: {
                return switch (blockOperationResult.result()) {
                    case BlockOperationResultType.SUCCESS, BlockOperationResultType.SUCCESS_PARTIAL, BlockOperationResultType.CONSUME -> BLOCK_COPY_SUCCESS_COLOR;
                    case BlockOperationResultType.FAIL_WORLD_HEIGHT, BlockOperationResultType.FAIL_WORLD_BORDER, BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM -> BLOCK_HIDEEN_COLOR;
                    default -> BLOCK_COPY_FAIL_COLOR;
                };
            }
        }
        return BLOCK_HIDEEN_COLOR;
    }

    public static List<Color> getAllColors() {
        return List.of(BLOCK_PLACE_SUCCESS_COLOR, BLOCK_PLACE_INSUFFICIENT_COLOR, BLOCK_PLACE_FAIL_COLOR, BLOCK_BREAK_SUCCESS_COLOR, BLOCK_BREAK_FAIL_COLOR, BLOCK_INTERACT_SUCCESS_COLOR, BLOCK_INTERACT_FAIL_COLOR, BLOCK_COPY_SUCCESS_COLOR, BLOCK_COPY_FAIL_COLOR);
    }

    public BlockOperationResult getResult() {
        return this.result;
    }

    @Override
    public void render(Renderer renderer, OperationRenderer.RenderContext renderContext, float deltaTick) {
        if (!renderContext.showBlockPreview()) {
            return;
        }
        BlockOperation operation = this.getResult().getOperation();
        if (renderContext.maxRenderVolume() < operation.getContext().getVolume()) {
            return;
        }
        World world = operation.getWorld();
        Player player = operation.getPlayer();
        BlockPosition blockPosition = operation.getBlockPosition();
        BlockState blockState = this.getResult().getBlockStateForRenderer();
        BlockEntity blockEntity = this.getResult().getBlockEntityForRenderer();
        if (world == null || player == null) {
            return;
        }
        float scale = 1.0078125f;
        Vector3d camera = renderer.getCamera().position();
        double distance = player.getPosition().distance(blockPosition.toVector3d());
        if (distance > (double)renderContext.maxRenderDistance()) {
            return;
        }
        Color color = BlockOperationRenderer.getColorByOpResult(this.getResult());
        if (color == null) {
            return;
        }
        renderer.pushPose();
        renderer.translate(blockPosition.toVector3d().sub(camera));
        if (blockEntity != null) {
            renderer.renderBlockEntity(BlockRenderLayers.block(color.getRGB()), world, blockPosition, blockEntity);
        }
        if (blockState != null) {
            renderer.translate((scale - 1.0f) / -2.0f, (scale - 1.0f) / -2.0f, (scale - 1.0f) / -2.0f);
            renderer.scale(scale, scale, scale);
            renderer.renderBlockState(BlockRenderLayers.block(color.getRGB()), world, blockPosition, blockState);
        }
        renderer.popPose();
    }
}

