/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.opertaion;

import dev.huskuraft.effortless.Effortless;
import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.renderer.RenderFadeEntry;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.building.operation.OperationResult;
import dev.huskuraft.effortless.building.operation.batch.BatchOperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockInteractOperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockStateCopyOperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockStateUpdateOperationResult;
import dev.huskuraft.effortless.renderer.opertaion.children.BatchOperationRenderer;
import dev.huskuraft.effortless.renderer.opertaion.children.BlockOperationRenderer;
import dev.huskuraft.effortless.renderer.opertaion.children.OperationRenderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class OperationsRenderer {
    private final Map<Object, RenderFadeEntry<? extends OperationRenderer>> results = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Class<?>, BiFunction<OperationsRenderer, OperationResult, ? extends OperationRenderer>> resultRendererMap = Collections.synchronizedMap(new HashMap());
    private final EffortlessClient entrance;

    public OperationsRenderer(EffortlessClient entrance) {
        this.entrance = entrance;
        this.registerRenderers();
    }

    public EffortlessClient getEntrance() {
        return this.entrance;
    }

    private <R extends OperationResult, O extends OperationRenderer> void registerRenderer(Class<R> result, BiFunction<OperationsRenderer, R, O> renderer) {
        this.resultRendererMap.put(result, renderer);
    }

    public <R extends OperationResult> OperationRenderer createRenderer(R result) {
        try {
            return this.resultRendererMap.get(result.getClass()).apply(this, result);
        }
        catch (Exception e) {
            Effortless.LOGGER.error("No renderer found for result: " + result.getClass().getSimpleName(), (Throwable)e);
            throw e;
        }
    }

    private void registerRenderers() {
        this.registerRenderer(BlockInteractOperationResult.class, BlockOperationRenderer::new);
        this.registerRenderer(BlockStateCopyOperationResult.class, BlockOperationRenderer::new);
        this.registerRenderer(BlockStateUpdateOperationResult.class, BlockOperationRenderer::new);
        this.registerRenderer(BatchOperationResult.class, BatchOperationRenderer::new);
    }

    public <R extends OperationResult> void showResult(Object id, R result) {
        this.results.put(id, new RenderFadeEntry<OperationRenderer>(this.createRenderer(result)));
    }

    public void remove(Object id) {
        this.results.remove(id);
    }

    public void tick() {
        Iterator<RenderFadeEntry<? extends OperationRenderer>> iterator = this.results.values().iterator();
        while (iterator.hasNext()) {
            RenderFadeEntry<? extends OperationRenderer> entry = iterator.next();
            entry.tick();
            if (entry.isAlive()) continue;
            iterator.remove();
        }
    }

    public void render(Renderer renderer, float deltaTick) {
        OperationRenderer.RenderContext.Default renderParams = new OperationRenderer.RenderContext.Default(((ClientConfig)this.getEntrance().getConfigStorage().get()).renderConfig().showBlockPreview(), ((ClientConfig)this.getEntrance().getConfigStorage().get()).renderConfig().maxRenderVolume(), this.getEntrance().getClientManager().getRunningClient().getOptions().renderDistance() * 16 + 16);
        this.results.forEach((k, v) -> ((OperationRenderer)v.getValue()).render(renderer, renderParams, deltaTick));
    }
}

