/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.huskuraft.effortless.api.math.Matrix3f;
import dev.huskuraft.effortless.api.math.Matrix4f;
import dev.huskuraft.effortless.api.math.Quaternionf;
import dev.huskuraft.effortless.api.renderer.MatrixStack;
import dev.huskuraft.effortless.neoforge.core.MinecraftConvertor;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class MinecraftMatrixStack
extends Record
implements MatrixStack {
    private final PoseStack refs;

    public MinecraftMatrixStack(PoseStack refs) {
        this.refs = refs;
    }

    @Override
    public void push() {
        this.refs.pushPose();
    }

    @Override
    public void pop() {
        this.refs.popPose();
    }

    @Override
    public MatrixStack.Matrix last() {
        return new MatrixStack.Matrix(){

            @Override
            public Matrix4f pose() {
                return MinecraftConvertor.fromPlatformMatrix4f(MinecraftMatrixStack.this.refs.last().pose());
            }

            @Override
            public Matrix3f normal() {
                return MinecraftConvertor.fromPlatformMatrix3f(MinecraftMatrixStack.this.refs.last().normal());
            }
        };
    }

    @Override
    public void translate(float x, float y, float z) {
        this.refs.translate(x, y, z);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.refs.scale(x, y, z);
    }

    @Override
    public void rotate(Quaternionf quaternion) {
        this.refs.mulPose(MinecraftConvertor.toPlatformQuaternion(quaternion));
    }

    @Override
    public void multiply(Matrix4f matrix) {
        this.refs.mulPose(MinecraftConvertor.toPlatformMatrix4f(matrix));
    }

    @Override
    public void identity() {
        this.refs.setIdentity();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftMatrixStack.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftMatrixStack.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftMatrixStack.class, "refs", "refs"}, this, o);
    }

    public PoseStack refs() {
        return this.refs;
    }
}

