/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.platform;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.core.Stat;
import dev.huskuraft.effortless.api.core.StatTypes;
import dev.huskuraft.effortless.api.core.fluid.Fluid;
import dev.huskuraft.effortless.api.core.fluid.Fluids;
import dev.huskuraft.effortless.api.platform.ContentFactory;
import dev.huskuraft.effortless.api.platform.OperatingSystem;
import dev.huskuraft.effortless.api.platform.PlatformReference;
import dev.huskuraft.effortless.api.sound.Sound;
import dev.huskuraft.effortless.api.sound.Sounds;
import dev.huskuraft.effortless.api.tag.InputStreamTagReader;
import dev.huskuraft.effortless.api.tag.OutputStreamTagWriter;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.neoforge.core.MinecraftFluid;
import dev.huskuraft.effortless.neoforge.core.MinecraftItem;
import dev.huskuraft.effortless.neoforge.core.MinecraftItemStack;
import dev.huskuraft.effortless.neoforge.core.MinecraftResourceLocation;
import dev.huskuraft.effortless.neoforge.core.MinecraftText;
import dev.huskuraft.effortless.neoforge.sound.MinecraftSound;
import dev.huskuraft.effortless.neoforge.tag.MinecraftRecordTag;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

@AutoService(value={ContentFactory.class})
public class MinecraftContentFactory
implements ContentFactory {
    @Override
    public ResourceLocation newResourceLocation(String namespace, String path) {
        return new MinecraftResourceLocation(net.minecraft.resources.ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    @Override
    public Optional<dev.huskuraft.effortless.api.core.Item> newOptionalItem(ResourceLocation location) {
        return BuiltInRegistries.ITEM.getOptional((net.minecraft.resources.ResourceLocation)location.reference()).map(MinecraftItem::ofNullable);
    }

    @Override
    public ItemStack newItemStack() {
        return new MinecraftItemStack(net.minecraft.world.item.ItemStack.EMPTY);
    }

    @Override
    public ItemStack newItemStack(dev.huskuraft.effortless.api.core.Item item, int count) {
        return new MinecraftItemStack(new net.minecraft.world.item.ItemStack((ItemLike)((Item)item.reference()), count));
    }

    @Override
    public Text newText() {
        return new MinecraftText((Component)Component.empty());
    }

    @Override
    public Text newText(String text) {
        return new MinecraftText((Component)Component.literal((String)text));
    }

    @Override
    public Text newTranslatableText(String text) {
        return new MinecraftText((Component)Component.translatable((String)text));
    }

    @Override
    public Text newTranslatableText(String text, Object ... args) {
        return new MinecraftText((Component)Component.translatable((String)text, (Object[])args));
    }

    @Override
    public InputStreamTagReader getInputStreamTagReader() {
        return input -> new MinecraftRecordTag(NbtIo.readCompressed((InputStream)input, (NbtAccounter)NbtAccounter.unlimitedHeap()));
    }

    @Override
    public OutputStreamTagWriter getOutputStreamTagWriter() {
        return (output, config) -> NbtIo.writeCompressed((CompoundTag)((CompoundTag)config.reference()), (OutputStream)output);
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return switch (Util.getPlatform()) {
            default -> throw new MatchException(null, null);
            case Util.OS.LINUX -> OperatingSystem.LINUX;
            case Util.OS.SOLARIS -> OperatingSystem.SOLARIS;
            case Util.OS.WINDOWS -> OperatingSystem.WINDOWS;
            case Util.OS.OSX -> OperatingSystem.MACOS;
            case Util.OS.UNKNOWN -> OperatingSystem.UNKNOWN;
        };
    }

    @Override
    public Sound getSound(Sounds sounds) {
        SoundEvent sound = switch (sounds) {
            default -> throw new MatchException(null, null);
            case Sounds.UI_BUTTON_CLICK -> (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value();
            case Sounds.UI_TOAST_IN -> SoundEvents.UI_TOAST_IN;
            case Sounds.UI_TOAST_OUT -> SoundEvents.UI_TOAST_OUT;
        };
        return new MinecraftSound(sound);
    }

    @Override
    public Fluid getFluid(Fluids fluids) {
        net.minecraft.world.level.material.Fluid fluid = switch (fluids) {
            default -> throw new MatchException(null, null);
            case Fluids.EMPTY -> net.minecraft.world.level.material.Fluids.EMPTY;
            case Fluids.FLOWING_WATER -> net.minecraft.world.level.material.Fluids.FLOWING_WATER;
            case Fluids.WATER -> net.minecraft.world.level.material.Fluids.WATER;
            case Fluids.FLOWING_LAVA -> net.minecraft.world.level.material.Fluids.FLOWING_LAVA;
            case Fluids.LAVA -> net.minecraft.world.level.material.Fluids.LAVA;
        };
        return MinecraftFluid.ofNullable(fluid);
    }

    @Override
    public <T extends PlatformReference> dev.huskuraft.effortless.api.core.StatType<T> getStatType(StatTypes statTypes) {
        final StatType statType = switch (statTypes) {
            default -> throw new MatchException(null, null);
            case StatTypes.ITEM_USED -> Stats.ITEM_USED;
            case StatTypes.ITEM_BROKEN -> Stats.ITEM_BROKEN;
            case StatTypes.ITEM_PICKED_UP -> Stats.ITEM_PICKED_UP;
            case StatTypes.ITEM_DROPPED -> Stats.ITEM_DROPPED;
        };
        return new dev.huskuraft.effortless.api.core.StatType<T>(){

            @Override
            public Stat<T> get(T value) {
                return () -> statType.get((Object)((Item)value.reference()));
            }

            @Override
            public Object refs() {
                return statType;
            }
        };
    }
}

