/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.networking;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.networking.ByteBufReceiver;
import dev.huskuraft.effortless.api.networking.ByteBufSender;
import dev.huskuraft.effortless.api.networking.Networking;
import dev.huskuraft.effortless.api.networking.Side;
import dev.huskuraft.effortless.neoforge.core.MinecraftPlayer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@AutoService(value={Networking.class})
public class NeoForgeNetworking
implements Networking {
    private static final Map<CustomPacketPayload.Type<Payload>, List<IPayloadHandler<Payload>>> MAP = new HashMap<CustomPacketPayload.Type<Payload>, List<IPayloadHandler<Payload>>>();

    private static void register(final CustomPacketPayload.Type<Payload> type, IPayloadHandler<Payload> listener) {
        MAP.computeIfAbsent(type, id -> {
            StreamCodec<RegistryFriendlyByteBuf, Payload> codec = new StreamCodec<RegistryFriendlyByteBuf, Payload>(){

                public Payload decode(RegistryFriendlyByteBuf byteBuf) {
                    return new Payload((CustomPacketPayload.Type<Payload>)type, byteBuf.readBytes(byteBuf.readableBytes()));
                }

                public void encode(RegistryFriendlyByteBuf byteBuf, Payload payload) {
                    byteBuf.writeBytes(payload.byteBuf());
                }
            };
            ArrayList listeners = new ArrayList();
            String version = String.valueOf(13);
            new PayloadRegistrar(version).playBidirectional(type, (StreamCodec)codec, (payload, context) -> {
                for (IPayloadHandler listener1 : listeners) {
                    listener1.handle(payload, context);
                }
            });
            return listeners;
        }).add(listener);
    }

    public static ByteBufSender register(ResourceLocation channelId, Side side, ByteBufReceiver receiver) {
        CustomPacketPayload.Type type = new CustomPacketPayload.Type((net.minecraft.resources.ResourceLocation)channelId.reference());
        switch (side) {
            case CLIENT: {
                NeoForgeNetworking.register((CustomPacketPayload.Type<Payload>)type, (IPayloadHandler<Payload>)((IPayloadHandler)(payload, context) -> {
                    if (context.protocol().equals((Object)ConnectionProtocol.PLAY) && context.flow().isClientbound()) {
                        receiver.receiveBuffer(payload.byteBuf(), MinecraftPlayer.ofNullable(context.player()));
                    }
                }));
                break;
            }
            case SERVER: {
                NeoForgeNetworking.register((CustomPacketPayload.Type<Payload>)type, (IPayloadHandler<Payload>)((IPayloadHandler)(payload, context) -> {
                    if (context.protocol().equals((Object)ConnectionProtocol.PLAY) && context.flow().isServerbound()) {
                        receiver.receiveBuffer(payload.byteBuf(), MinecraftPlayer.ofNullable(context.player()));
                    }
                }));
            }
        }
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.CLIENT -> (byteBuf, player) -> PacketDistributor.sendToServer((CustomPacketPayload)new Payload((CustomPacketPayload.Type<Payload>)type, byteBuf), (CustomPacketPayload[])new CustomPacketPayload[0]);
            case Side.SERVER -> (byteBuf, player) -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player.reference()), (CustomPacketPayload)new Payload((CustomPacketPayload.Type<Payload>)type, byteBuf), (CustomPacketPayload[])new CustomPacketPayload[0]);
        };
    }

    private record Payload(CustomPacketPayload.Type<Payload> type, ByteBuf byteBuf) implements CustomPacketPayload
    {
        private final ByteBuf byteBuf;

        public ByteBuf byteBuf() {
            return this.byteBuf.duplicate();
        }
    }
}

