/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.events;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.events.impl.EventRegistry;
import dev.huskuraft.effortless.neoforge.core.MinecraftPlayer;
import dev.huskuraft.effortless.neoforge.core.MinecraftServer;
import dev.huskuraft.effortless.neoforge.core.MinecraftWorld;
import dev.huskuraft.effortless.neoforge.networking.NeoForgeNetworking;
import dev.huskuraft.effortless.neoforge.platform.NeoForgeInitializer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@AutoService(value={EventRegistry.class})
public class NeoForgeEventRegistry
extends EventRegistry {
    public NeoForgeEventRegistry() {
        NeoForgeInitializer.EVENT_BUS.addListener(this::onCommonSetup);
        NeoForgeInitializer.EVENT_BUS.addListener(this::onRegisterNetwork);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
    }

    public void onRegisterNetwork(RegisterPayloadHandlersEvent event) {
        this.getRegisterNetworkEvent().invoker().onRegisterNetwork(NeoForgeNetworking::register);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.getPlayerChangeWorldEvent().invoker().onPlayerChangeWorld(MinecraftPlayer.ofNullable(event.getEntity()), MinecraftWorld.ofNullable((Level)event.getEntity().getServer().getLevel(event.getFrom())), MinecraftWorld.ofNullable((Level)event.getEntity().getServer().getLevel(event.getTo())));
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.getPlayerRespawnEvent().invoker().onPlayerRespawn(MinecraftPlayer.ofNullable(event.getEntity()), MinecraftPlayer.ofNullable(event.getEntity()), event.isEndConquered());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.getPlayerLoggedInEvent().invoker().onPlayerLoggedIn(MinecraftPlayer.ofNullable(event.getEntity()));
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.getPlayerLoggedOutEvent().invoker().onPlayerLoggedOut(MinecraftPlayer.ofNullable(event.getEntity()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.getServerStartingEvent().invoker().onServerStarting(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void onSeverrStarted(ServerStartedEvent event) {
        this.getServerStartedEvent().invoker().onServerStarted(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.getServerStoppingEvent().invoker().onServerStopping(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        this.getServerStoppedEvent().invoker().onServerStopped(new MinecraftServer(event.getServer()));
    }
}

