/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.events;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.InteractionType;
import dev.huskuraft.effortless.api.events.impl.ClientEventRegistry;
import dev.huskuraft.effortless.api.events.lifecycle.ClientTick;
import dev.huskuraft.effortless.api.input.InputKey;
import dev.huskuraft.effortless.neoforge.core.MinecraftConvertor;
import dev.huskuraft.effortless.neoforge.networking.NeoForgeNetworking;
import dev.huskuraft.effortless.neoforge.platform.MinecraftClient;
import dev.huskuraft.effortless.neoforge.platform.NeoForgeInitializer;
import dev.huskuraft.effortless.neoforge.renderer.MinecraftRenderer;
import dev.huskuraft.effortless.neoforge.renderer.MinecraftShader;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@AutoService(value={ClientEventRegistry.class})
public class NeoForgeClientEventRegistry
extends ClientEventRegistry {
    public NeoForgeClientEventRegistry() {
        NeoForgeInitializer.EVENT_BUS.addListener(this::onClientSetup);
        NeoForgeInitializer.EVENT_BUS.addListener(this::onRegisterNetwork);
        NeoForgeInitializer.EVENT_BUS.addListener(this::onRegisterKeyMappings);
        NeoForgeInitializer.EVENT_BUS.addListener(this::onReloadShader);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        this.getClientStartEvent().invoker().onClientStart(new MinecraftClient(Minecraft.getInstance()));
    }

    public void onRegisterNetwork(RegisterPayloadHandlersEvent event) {
        this.getRegisterNetworkEvent().invoker().onRegisterNetwork(NeoForgeNetworking::register);
    }

    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.getRegisterKeysEvent().invoker().onRegisterKeys(key -> event.register((KeyMapping)key.getKeyBinding().reference()));
    }

    public void onReloadShader(RegisterShadersEvent event) {
        this.getRegisterShaderEvent().invoker().onRegisterShader((resource, format, consumer) -> {
            ShaderInstance minecraftShader = new ShaderInstance(event.getResourceProvider(), resource.getPath(), (VertexFormat)format.reference());
            event.registerShader(minecraftShader, shaderInstance -> consumer.accept(new MinecraftShader((ShaderInstance)shaderInstance)));
        });
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        this.getClientTickEvent().invoker().onClientTick(new MinecraftClient(Minecraft.getInstance()), ClientTick.Phase.START);
    }

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        this.getRenderWorldEvent().invoker().onRenderWorld(new MinecraftRenderer(new PoseStack()), event.getPartialTick().getGameTimeDeltaPartialTick(false));
    }

    @SubscribeEvent
    public void onRenderGui(CustomizeGuiOverlayEvent.Chat event) {
        this.getRenderGuiEvent().invoker().onRenderGui(new MinecraftRenderer(event.getGuiGraphics().pose()), event.getPartialTick().getGameTimeDeltaPartialTick(false));
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        this.getKeyInputEvent().invoker().onKeyInput(new InputKey(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers()));
    }

    @SubscribeEvent
    public void onInteractionInput(InputEvent.InteractionKeyMappingTriggered event) {
        InteractionType type = event.isAttack() ? InteractionType.ATTACK : (event.isUseItem() ? InteractionType.USE_ITEM : InteractionType.UNKNOWN);
        InteractionHand hand = MinecraftConvertor.fromPlatformInteractionHand(event.getHand());
        if (this.getInteractionInputEvent().invoker().onInteractionInput(type, hand).interruptsFurtherEvaluation()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }
}

