/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.core;

import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.GameMode;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.Inventory;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.PlayerProfile;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.platform.Client;
import dev.huskuraft.effortless.api.platform.Server;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.neoforge.core.MinecraftConvertor;
import dev.huskuraft.effortless.neoforge.core.MinecraftInventory;
import dev.huskuraft.effortless.neoforge.core.MinecraftPlayerProfile;
import dev.huskuraft.effortless.neoforge.core.MinecraftServer;
import dev.huskuraft.effortless.neoforge.core.MinecraftText;
import dev.huskuraft.effortless.neoforge.core.MinecraftWorld;
import dev.huskuraft.effortless.neoforge.platform.MinecraftClient;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;

public final class MinecraftPlayer
extends Record
implements dev.huskuraft.effortless.api.core.Player {
    private final Player refs;

    public MinecraftPlayer(Player refs) {
        this.refs = refs;
    }

    public static dev.huskuraft.effortless.api.core.Player ofNullable(Player refs) {
        if (refs == null) {
            return null;
        }
        return new MinecraftPlayer(refs);
    }

    @Override
    public UUID getId() {
        return this.refs.getUUID();
    }

    @Override
    public PlayerProfile getProfile() {
        return new MinecraftPlayerProfile(this.refs.getGameProfile());
    }

    @Override
    public Inventory getInventory() {
        return new MinecraftInventory(this.refs.getInventory());
    }

    @Override
    public boolean isDeadOrDying() {
        return this.refs.isDeadOrDying();
    }

    @Override
    public Client getClient() {
        return new MinecraftClient(Minecraft.getInstance());
    }

    @Override
    public Server getServer() {
        return new MinecraftServer(this.refs.getServer());
    }

    @Override
    public World getWorld() {
        return MinecraftWorld.ofNullable(this.refs.level());
    }

    @Override
    public Text getDisplayName() {
        return new MinecraftText(this.refs.getDisplayName());
    }

    @Override
    public Vector3d getPosition() {
        return MinecraftConvertor.fromPlatformVector3d(this.refs.position());
    }

    @Override
    public void drop(ItemStack itemStack, boolean dropAround, boolean includeThrowerName) {
        this.refs.drop((net.minecraft.world.item.ItemStack)itemStack.reference(), dropAround, includeThrowerName);
    }

    @Override
    public void sendMessage(Text message, boolean actionBar) {
        this.refs.displayClientMessage((Component)message.reference(), actionBar);
    }

    @Override
    public void swing(InteractionHand hand) {
        this.refs.swing(MinecraftConvertor.toPlatformInteractionHand(hand));
    }

    @Override
    public GameMode getGameMode() {
        Player player = this.refs;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return switch (serverPlayer.gameMode.getGameModeForPlayer()) {
                default -> throw new MatchException(null, null);
                case GameType.SURVIVAL -> GameMode.SURVIVAL;
                case GameType.CREATIVE -> GameMode.CREATIVE;
                case GameType.ADVENTURE -> GameMode.ADVENTURE;
                case GameType.SPECTATOR -> GameMode.SPECTATOR;
            };
        }
        player = this.refs;
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer localPlayer = (AbstractClientPlayer)player;
            return switch (localPlayer.getPlayerInfo().getGameMode()) {
                default -> throw new MatchException(null, null);
                case GameType.SURVIVAL -> GameMode.SURVIVAL;
                case GameType.CREATIVE -> GameMode.CREATIVE;
                case GameType.ADVENTURE -> GameMode.ADVENTURE;
                case GameType.SPECTATOR -> GameMode.SPECTATOR;
            };
        }
        return null;
    }

    @Override
    public BlockInteraction raytrace(double maxDistance, float deltaTick, boolean includeFluids) {
        return (BlockInteraction)MinecraftConvertor.fromPlatformInteraction(this.refs.pick(maxDistance, deltaTick, includeFluids));
    }

    @Override
    public float getEyeHeight() {
        return this.refs.getEyeHeight();
    }

    @Override
    public void setPosition(Vector3d position) {
        this.refs.setPos(MinecraftConvertor.toPlatformVector3d(position));
    }

    @Override
    public float getXRot() {
        return this.refs.getXRot();
    }

    @Override
    public void setXRot(float xRot) {
        this.refs.setXRot(xRot);
    }

    @Override
    public float getYRot() {
        return this.refs.getYRot();
    }

    @Override
    public void setYRot(float yRot) {
        this.refs.setYRot(yRot);
    }

    @Override
    public void awardStat(dev.huskuraft.effortless.api.core.Stat<?> stat, int increment) {
        this.refs.awardStat((Stat)stat.reference(), increment);
    }

    @Override
    public void resetStat(dev.huskuraft.effortless.api.core.Stat<?> stat) {
        this.refs.resetStat((Stat)stat.reference());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftPlayer.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftPlayer.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftPlayer.class, "refs", "refs"}, this, o);
    }

    public Player refs() {
        return this.refs;
    }
}

