/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.core;

import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.ChunkPosition;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.core.EntityInteraction;
import dev.huskuraft.effortless.api.core.Interaction;
import dev.huskuraft.effortless.api.math.Matrix4f;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.math.Vector3i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Quaternionf;

public final class MinecraftConvertor {
    public static dev.huskuraft.effortless.api.math.Quaternionf fromPlatformQuaternion(Quaternionf quaternion) {
        return new dev.huskuraft.effortless.api.math.Quaternionf(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
    }

    public static Quaternionf toPlatformQuaternion(dev.huskuraft.effortless.api.math.Quaternionf quaternion) {
        return new Quaternionf(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
    }

    public static dev.huskuraft.effortless.api.math.Matrix3f fromPlatformMatrix3f(Matrix3f matrix) {
        return new dev.huskuraft.effortless.api.math.Matrix3f(matrix.m00(), matrix.m01(), matrix.m02(), matrix.m10(), matrix.m11(), matrix.m12(), matrix.m20(), matrix.m21(), matrix.m22());
    }

    public static Matrix3f toPlatformMatrix3f(dev.huskuraft.effortless.api.math.Matrix3f matrix) {
        return new Matrix3f(matrix.m00(), matrix.m01(), matrix.m02(), matrix.m10(), matrix.m11(), matrix.m12(), matrix.m20(), matrix.m21(), matrix.m22());
    }

    public static Matrix4f fromPlatformMatrix4f(org.joml.Matrix4f matrix) {
        return new Matrix4f(matrix.m00(), matrix.m01(), matrix.m02(), matrix.m03(), matrix.m10(), matrix.m11(), matrix.m12(), matrix.m13(), matrix.m20(), matrix.m21(), matrix.m22(), matrix.m23(), matrix.m30(), matrix.m31(), matrix.m32(), matrix.m33());
    }

    public static org.joml.Matrix4f toPlatformMatrix4f(Matrix4f matrix) {
        return new org.joml.Matrix4f(matrix.m00(), matrix.m01(), matrix.m02(), matrix.m03(), matrix.m10(), matrix.m11(), matrix.m12(), matrix.m13(), matrix.m20(), matrix.m21(), matrix.m22(), matrix.m23(), matrix.m30(), matrix.m31(), matrix.m32(), matrix.m33());
    }

    public static BlockPos toPlatformBlockPosition(BlockPosition blockPosition) {
        return new BlockPos(blockPosition.x(), blockPosition.y(), blockPosition.z());
    }

    public static ChunkPos toPlatformChunkPosition(ChunkPosition chunkPosition) {
        return new ChunkPos(chunkPosition.x(), chunkPosition.z());
    }

    public static Vec3i toPlatformVector3i(Vector3i vector) {
        return new Vec3i(vector.x(), vector.y(), vector.z());
    }

    public static Vec3 toPlatformVector3d(Vector3d vector) {
        return new Vec3(vector.x(), vector.y(), vector.z());
    }

    public static BlockPosition toPlatformBlockPosition(BlockPos vector) {
        return new BlockPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector3d fromPlatformVector3d(Vec3 vector) {
        return new Vector3d(vector.x(), vector.y(), vector.z());
    }

    public static Vector3i fromPlatformVector3i(Vec3i vector) {
        return new Vector3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Interaction fromPlatformInteraction(HitResult hitResult) {
        if (hitResult == null) {
            return null;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            return MinecraftConvertor.fromPlatformBlockInteraction(blockHitResult);
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return MinecraftConvertor.fromPlatformEntityInteraction(entityHitResult);
        }
        throw new IllegalArgumentException("Unknown Interaction: " + String.valueOf(hitResult));
    }

    public static EntityInteraction fromPlatformEntityInteraction(EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            return null;
        }
        return new EntityInteraction(MinecraftConvertor.fromPlatformVector3d(entityHitResult.getLocation()), null);
    }

    public static BlockInteraction fromPlatformBlockInteraction(BlockHitResult blockHitResult) {
        if (blockHitResult == null) {
            return null;
        }
        return new BlockInteraction(MinecraftConvertor.fromPlatformVector3d(blockHitResult.getLocation()), MinecraftConvertor.fromPlatformDirection(blockHitResult.getDirection()), MinecraftConvertor.toPlatformBlockPosition(blockHitResult.getBlockPos()), blockHitResult.isInside(), blockHitResult.getType() == HitResult.Type.MISS);
    }

    public static BlockHitResult toPlatformBlockInteraction(BlockInteraction blockInteraction) {
        if (blockInteraction == null) {
            return null;
        }
        return new BlockHitResult(MinecraftConvertor.toPlatformVector3d(blockInteraction.getPosition()), MinecraftConvertor.toPlatformDirection(blockInteraction.getDirection()), MinecraftConvertor.toPlatformBlockPosition(blockInteraction.getBlockPosition()), blockInteraction.isInside());
    }

    public static dev.huskuraft.effortless.api.core.InteractionHand fromPlatformInteractionHand(InteractionHand interactionHand) {
        return switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> dev.huskuraft.effortless.api.core.InteractionHand.MAIN;
            case InteractionHand.OFF_HAND -> dev.huskuraft.effortless.api.core.InteractionHand.OFF;
        };
    }

    public static InteractionHand toPlatformInteractionHand(dev.huskuraft.effortless.api.core.InteractionHand interactionHand) {
        return switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case dev.huskuraft.effortless.api.core.InteractionHand.MAIN -> InteractionHand.MAIN_HAND;
            case dev.huskuraft.effortless.api.core.InteractionHand.OFF -> InteractionHand.OFF_HAND;
        };
    }

    public static Direction fromPlatformDirection(net.minecraft.core.Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case net.minecraft.core.Direction.DOWN -> Direction.DOWN;
            case net.minecraft.core.Direction.UP -> Direction.UP;
            case net.minecraft.core.Direction.NORTH -> Direction.NORTH;
            case net.minecraft.core.Direction.SOUTH -> Direction.SOUTH;
            case net.minecraft.core.Direction.WEST -> Direction.WEST;
            case net.minecraft.core.Direction.EAST -> Direction.EAST;
        };
    }

    public static net.minecraft.core.Direction toPlatformDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> net.minecraft.core.Direction.DOWN;
            case Direction.UP -> net.minecraft.core.Direction.UP;
            case Direction.NORTH -> net.minecraft.core.Direction.NORTH;
            case Direction.SOUTH -> net.minecraft.core.Direction.SOUTH;
            case Direction.WEST -> net.minecraft.core.Direction.WEST;
            case Direction.EAST -> net.minecraft.core.Direction.EAST;
        };
    }

    public static dev.huskuraft.effortless.api.core.InteractionResult fromPlatformInteractionResult(InteractionResult interactionResult) {
        return switch (interactionResult) {
            default -> throw new MatchException(null, null);
            case InteractionResult.SUCCESS -> dev.huskuraft.effortless.api.core.InteractionResult.SUCCESS;
            case InteractionResult.SUCCESS_NO_ITEM_USED -> dev.huskuraft.effortless.api.core.InteractionResult.SUCCESS_NO_ITEM_USED;
            case InteractionResult.CONSUME -> dev.huskuraft.effortless.api.core.InteractionResult.CONSUME;
            case InteractionResult.CONSUME_PARTIAL -> dev.huskuraft.effortless.api.core.InteractionResult.CONSUME_PARTIAL;
            case InteractionResult.PASS -> dev.huskuraft.effortless.api.core.InteractionResult.PASS;
            case InteractionResult.FAIL -> dev.huskuraft.effortless.api.core.InteractionResult.FAIL;
        };
    }

    public static BlockPlaceContext toPlatformBlockPlaceContext(dev.huskuraft.effortless.api.core.Player player, BlockInteraction blockInteraction) {
        return new BlockPlaceContext((Player)player.reference(), MinecraftConvertor.toPlatformInteractionHand(blockInteraction.getHand()), (ItemStack)player.getItemStack(blockInteraction.getHand()).reference(), MinecraftConvertor.toPlatformBlockInteraction(blockInteraction));
    }
}

