/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.neoforge.core;

import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.neoforge.core.MinecraftBlockState;
import dev.huskuraft.effortless.neoforge.core.MinecraftContainerBlockEntity;
import dev.huskuraft.effortless.neoforge.core.MinecraftConvertor;
import dev.huskuraft.effortless.neoforge.core.MinecraftWorld;
import dev.huskuraft.effortless.neoforge.tag.MinecraftRecordTag;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;

public final class MinecraftBlockEntity
extends Record
implements BlockEntity {
    private final net.minecraft.world.level.block.entity.BlockEntity refs;

    public MinecraftBlockEntity(net.minecraft.world.level.block.entity.BlockEntity refs) {
        this.refs = refs;
    }

    public static BlockEntity ofNullable(net.minecraft.world.level.block.entity.BlockEntity refs) {
        if (refs == null) {
            return null;
        }
        if (refs instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)refs;
            return new MinecraftContainerBlockEntity(baseContainerBlockEntity);
        }
        return new MinecraftBlockEntity(refs);
    }

    @Override
    public BlockState getBlockState() {
        return MinecraftBlockState.ofNullable(this.refs.getBlockState());
    }

    @Override
    public BlockPosition getBlockPosition() {
        return MinecraftConvertor.toPlatformBlockPosition(this.refs.getBlockPos());
    }

    @Override
    public World getWorld() {
        return MinecraftWorld.ofNullable(this.refs.getLevel());
    }

    @Override
    public RecordTag getTag() {
        return MinecraftRecordTag.ofNullable(this.refs.saveWithoutMetadata((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    @Override
    public void setTag(RecordTag recordTag) {
        this.refs.loadWithComponents((CompoundTag)recordTag.reference(), (HolderLookup.Provider)RegistryAccess.EMPTY);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftBlockEntity.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftBlockEntity.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftBlockEntity.class, "refs", "refs"}, this, o);
    }

    public net.minecraft.world.level.block.entity.BlockEntity refs() {
        return this.refs;
    }
}

