/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.gui.Typeface;
import dev.huskuraft.effortless.api.renderer.BufferSource;
import dev.huskuraft.effortless.api.renderer.MatrixStack;
import dev.huskuraft.effortless.api.renderer.RenderLayer;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.renderer.MinecraftBufferSource;
import dev.huskuraft.effortless.forge.renderer.MinecraftMatrixStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;

public class MinecraftRenderer
extends Renderer {
    private static final RandomSource RAND = RandomSource.create();
    private final Minecraft minecraftClient = Minecraft.getInstance();
    private final PoseStack minecraftMatrixStack;
    private final MultiBufferSource.BufferSource minecraftBufferSource;
    private final GuiGraphics minecraftRendererProvider;

    public MinecraftRenderer(PoseStack minecraftMatrixStack) {
        this.minecraftMatrixStack = minecraftMatrixStack;
        this.minecraftBufferSource = this.minecraftClient.renderBuffers().bufferSource();
        this.minecraftRendererProvider = new GuiGraphics(Minecraft.getInstance(), this.minecraftMatrixStack, this.minecraftBufferSource);
    }

    @Override
    public MatrixStack matrixStack() {
        return new MinecraftMatrixStack(this.minecraftMatrixStack);
    }

    @Override
    protected void enableScissor(int x, int y, int width, int height) {
        RenderSystem.enableScissor((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    protected void disableScissor() {
        RenderSystem.disableScissor();
    }

    @Override
    public void setRsShaderColor(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public BufferSource bufferSource() {
        return new MinecraftBufferSource(this.minecraftBufferSource);
    }

    @Override
    public void flush() {
        RenderSystem.disableDepthTest();
        this.minecraftBufferSource.endBatch();
        RenderSystem.enableDepthTest();
    }

    @Override
    protected int renderTextInternal(Typeface typeface, Text text, int x, int y, int color, int backgroundColor, boolean shadow, boolean seeThrough, int lightMap) {
        Font minecraftTypeface = (Font)typeface.reference();
        Component minecraftText = (Component)text.reference();
        return minecraftTypeface.drawInBatch(minecraftText, (float)x, (float)y, color, shadow, this.minecraftMatrixStack.last().pose(), (MultiBufferSource)this.minecraftBufferSource, seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor, lightMap);
    }

    @Override
    public void renderItem(ItemStack stack, int x, int y) {
        this.minecraftRendererProvider.renderItem((net.minecraft.world.item.ItemStack)stack.reference(), x, y);
    }

    @Override
    public void renderTooltip(Typeface typeface, List<Text> list, int x, int y) {
        this.minecraftRendererProvider.renderTooltip((Font)typeface.reference(), list.stream().map(text -> (Component)text.reference()).toList(), Optional.empty(), x, y);
    }

    @Override
    public void renderBlockState(RenderLayer renderLayer, World world, BlockPosition blockPosition, BlockState blockState) {
        BlockRenderDispatcher minecraftBlockRenderer = this.minecraftClient.getBlockRenderer();
        Level minecraftWorld = (Level)world.reference();
        RenderType minecraftRenderLayer = (RenderType)renderLayer.reference();
        net.minecraft.world.level.block.state.BlockState minecraftBlockState = (net.minecraft.world.level.block.state.BlockState)blockState.reference();
        BlockPos minecraftBlockPosition = MinecraftConvertor.toPlatformBlockPosition(blockPosition);
        minecraftBlockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)minecraftWorld, minecraftBlockRenderer.getBlockModel(minecraftBlockState), minecraftBlockState, minecraftBlockPosition, this.minecraftMatrixStack, this.minecraftBufferSource.getBuffer(minecraftRenderLayer), false, RAND, minecraftBlockState.getSeed(minecraftBlockPosition), OverlayTexture.NO_OVERLAY);
    }

    @Override
    public void renderBlockEntity(RenderLayer renderLayer, World world, BlockPosition blockPosition, BlockEntity blockEntity) {
        BlockEntityRenderDispatcher minecraftBlockEntityRenderDispatcher = this.minecraftClient.getBlockEntityRenderDispatcher();
        net.minecraft.world.level.block.entity.BlockEntity minecraftBlockEntity = (net.minecraft.world.level.block.entity.BlockEntity)blockEntity.reference();
        minecraftBlockEntity.setLevel((Level)world.reference());
        minecraftBlockEntityRenderDispatcher.render(minecraftBlockEntity, 0.0f, this.minecraftMatrixStack, (MultiBufferSource)this.minecraftBufferSource);
    }
}

