/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.renderer;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.huskuraft.effortless.api.renderer.RenderLayer;
import dev.huskuraft.effortless.api.renderer.RenderStateFactory;
import dev.huskuraft.effortless.api.renderer.Shader;
import dev.huskuraft.effortless.api.renderer.Shaders;
import dev.huskuraft.effortless.api.renderer.VertexFormat;
import dev.huskuraft.effortless.api.renderer.VertexFormats;
import dev.huskuraft.effortless.api.renderer.programs.CompositeRenderState;
import dev.huskuraft.effortless.api.renderer.programs.RenderState;
import dev.huskuraft.effortless.forge.renderer.MinecraftShader;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

@AutoService(value={RenderStateFactory.class})
public final class MinecraftRenderStateFactory
implements RenderStateFactory {
    @Override
    public RenderLayer createCompositeRenderLayer(String name, dev.huskuraft.effortless.api.renderer.VertexFormat vertexFormat, VertexFormat.Mode vertexFormatMode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, CompositeRenderState state) {
        RenderType.CompositeRenderType layer = RenderType.create((String)name, (VertexFormat)((VertexFormat)vertexFormat.reference()), (VertexFormat.Mode)((VertexFormat.Mode)vertexFormatMode.reference()), (int)bufferSize, (boolean)affectsCrumbling, (boolean)sortOnUpload, (RenderType.CompositeState)((RenderType.CompositeState)state.reference()));
        return () -> layer;
    }

    @Override
    public CompositeRenderState createCompositeState(RenderState.TextureState textureState, RenderState.ShaderState shaderState, RenderState.TransparencyState transparencyState, RenderState.DepthTestState depthTestState, RenderState.CullState cullState, RenderState.LightmapState lightmapState, RenderState.OverlayState overlayState, RenderState.LayeringState layeringState, RenderState.OutputState outputState, RenderState.TexturingState texturingState, RenderState.WriteMaskState writeMaskState, RenderState.LineState lineState, RenderState.ColorLogicState colorLogicState, boolean affectOutline) {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)textureState.reference()).setShaderState((RenderStateShard.ShaderStateShard)shaderState.reference()).setTransparencyState((RenderStateShard.TransparencyStateShard)transparencyState.reference()).setDepthTestState((RenderStateShard.DepthTestStateShard)depthTestState.reference()).setCullState((RenderStateShard.CullStateShard)cullState.reference()).setLightmapState((RenderStateShard.LightmapStateShard)lightmapState.reference()).setOverlayState((RenderStateShard.OverlayStateShard)overlayState.reference()).setLayeringState((RenderStateShard.LayeringStateShard)layeringState.reference()).setOutputState((RenderStateShard.OutputStateShard)outputState.reference()).setTexturingState((RenderStateShard.TexturingStateShard)texturingState.reference()).setWriteMaskState((RenderStateShard.WriteMaskStateShard)writeMaskState.reference()).setLineState((RenderStateShard.LineStateShard)lineState.reference()).setColorLogicState((RenderStateShard.ColorLogicStateShard)colorLogicState.reference()).createCompositeState(affectOutline);
        return () -> state;
    }

    @Override
    public RenderState createRenderState(String name, Runnable setupState, Runnable clearState) {
        RenderStateShard state = new RenderStateShard(this, name, setupState, clearState){};
        return () -> MinecraftRenderStateFactory.lambda$createRenderState$2(state);
    }

    @Override
    public RenderState.TextureState createTextureState(String name, RenderState.TextureState.Texture texture) {
        RenderStateShard.EmptyTextureStateShard state = texture == null ? RenderType.NO_TEXTURE : new RenderStateShard.TextureStateShard((ResourceLocation)texture.location().reference(), texture.blur(), texture.mipmap());
        return () -> state;
    }

    @Override
    public RenderState.ShaderState createShaderState(String name, Shader shader) {
        RenderStateShard.ShaderStateShard state = shader == null ? new RenderStateShard.ShaderStateShard() : new RenderStateShard.ShaderStateShard(shader::reference);
        return () -> state;
    }

    @Override
    public RenderState.TransparencyState createTransparencyState(String name, RenderState.TransparencyState.Type type) {
        RenderStateShard.TransparencyStateShard state = switch (type) {
            default -> throw new MatchException(null, null);
            case RenderState.TransparencyState.Type.NO -> RenderType.NO_TRANSPARENCY;
            case RenderState.TransparencyState.Type.ADDITIVE -> RenderType.ADDITIVE_TRANSPARENCY;
            case RenderState.TransparencyState.Type.LIGHTNING -> RenderType.LIGHTNING_TRANSPARENCY;
            case RenderState.TransparencyState.Type.GLINT -> RenderType.GLINT_TRANSPARENCY;
            case RenderState.TransparencyState.Type.CRUMBLING -> RenderType.CRUMBLING_TRANSPARENCY;
            case RenderState.TransparencyState.Type.TRANSLUCENT -> RenderType.TRANSLUCENT_TRANSPARENCY;
        };
        return () -> state;
    }

    @Override
    public RenderState.DepthTestState createDepthTestState(String name, int function) {
        RenderStateShard.DepthTestStateShard state = new RenderStateShard.DepthTestStateShard(name, function);
        return () -> state;
    }

    @Override
    public RenderState.CullState createCullState(String name, boolean cull) {
        RenderStateShard.CullStateShard state = cull ? RenderType.CULL : RenderType.NO_CULL;
        return () -> state;
    }

    @Override
    public RenderState.LightmapState createLightmapState(String name, boolean lightmap) {
        RenderStateShard.LightmapStateShard state = lightmap ? RenderType.LIGHTMAP : RenderType.NO_LIGHTMAP;
        return () -> state;
    }

    @Override
    public RenderState.OverlayState createOverlayState(String name, boolean overlay) {
        RenderStateShard.OverlayStateShard state = overlay ? RenderType.OVERLAY : RenderType.NO_OVERLAY;
        return () -> state;
    }

    @Override
    public RenderState.LayeringState createLayeringState(String name, RenderState.LayeringState.Type type) {
        RenderStateShard.LayeringStateShard state = switch (type) {
            default -> throw new MatchException(null, null);
            case RenderState.LayeringState.Type.NO -> RenderType.NO_LAYERING;
            case RenderState.LayeringState.Type.POLYGON_OFFSET -> RenderType.POLYGON_OFFSET_LAYERING;
            case RenderState.LayeringState.Type.VIEW_OFFSET_Z -> RenderType.VIEW_OFFSET_Z_LAYERING;
        };
        return () -> state;
    }

    @Override
    public RenderState.OutputState createOutputState(String name, RenderState.OutputState.Target target) {
        RenderStateShard.OutputStateShard state = switch (target) {
            default -> throw new MatchException(null, null);
            case RenderState.OutputState.Target.NO -> RenderType.MAIN_TARGET;
            case RenderState.OutputState.Target.OUTLINE -> RenderType.OUTLINE_TARGET;
            case RenderState.OutputState.Target.TRANSLUCENT -> RenderType.TRANSLUCENT_TARGET;
            case RenderState.OutputState.Target.PARTICLES -> RenderType.PARTICLES_TARGET;
            case RenderState.OutputState.Target.WEATHER -> RenderType.WEATHER_TARGET;
            case RenderState.OutputState.Target.CLOUDS -> RenderType.CLOUDS_TARGET;
            case RenderState.OutputState.Target.ITEM_ENTITY -> RenderType.ITEM_ENTITY_TARGET;
        };
        return () -> state;
    }

    @Override
    public RenderState.TexturingState createTexturingState(String name, Runnable setupState, Runnable clearState) {
        RenderStateShard.TexturingStateShard state = new RenderStateShard.TexturingStateShard(name, setupState, clearState);
        return () -> state;
    }

    @Override
    public RenderState.OffsetTexturingState createOffsetTexturingState(String name, float offsetX, float offsetY) {
        RenderStateShard.OffsetTexturingStateShard state = new RenderStateShard.OffsetTexturingStateShard(offsetX, offsetY);
        return () -> state;
    }

    @Override
    public RenderState.WriteMaskState createWriteMaskState(String name, boolean writeColor, boolean writeDepth) {
        RenderStateShard.WriteMaskStateShard state = new RenderStateShard.WriteMaskStateShard(writeColor, writeDepth);
        return () -> state;
    }

    @Override
    public RenderState.LineState createLineState(String name, Double width) {
        RenderStateShard.LineStateShard state = new RenderStateShard.LineStateShard(width == null ? OptionalDouble.empty() : OptionalDouble.of(width));
        return () -> state;
    }

    @Override
    public RenderState.ColorLogicState createColorLogicState(String name, RenderState.ColorLogicState.Op op) {
        RenderStateShard.ColorLogicStateShard state = switch (op) {
            default -> throw new MatchException(null, null);
            case RenderState.ColorLogicState.Op.NO_LOGIC -> RenderType.NO_COLOR_LOGIC;
            case RenderState.ColorLogicState.Op.OR_REVERSE_LOGIC -> RenderType.OR_REVERSE_COLOR_LOGIC;
        };
        return () -> state;
    }

    @Override
    public Shader getShader(Shaders shaders) {
        ShaderInstance shader = switch (shaders) {
            default -> throw new MatchException(null, null);
            case Shaders.POSITION_COLOR_LIGHTMAP -> GameRenderer.getPositionColorLightmapShader();
            case Shaders.POSITION -> GameRenderer.getPositionShader();
            case Shaders.POSITION_COLOR_TEX -> GameRenderer.getPositionTexShader();
            case Shaders.POSITION_TEX -> GameRenderer.getPositionTexShader();
            case Shaders.POSITION_COLOR_TEX_LIGHTMAP -> GameRenderer.getPositionColorTexLightmapShader();
            case Shaders.POSITION_COLOR -> GameRenderer.getPositionColorShader();
            case Shaders.SOLID -> GameRenderer.getRendertypeSolidShader();
            case Shaders.CUTOUT_MIPPED -> GameRenderer.getRendertypeCutoutMippedShader();
            case Shaders.CUTOUT -> GameRenderer.getRendertypeCutoutShader();
            case Shaders.TRANSLUCENT -> GameRenderer.getRendertypeTranslucentShader();
            case Shaders.TRANSLUCENT_MOVING_BLOCK -> GameRenderer.getRendertypeTranslucentMovingBlockShader();
            case Shaders.TRANSLUCENT_NO_CRUMBLING -> null;
            case Shaders.ARMOR_CUTOUT_NO_CULL -> GameRenderer.getRendertypeArmorCutoutNoCullShader();
            case Shaders.ENTITY_SOLID -> GameRenderer.getRendertypeEntitySolidShader();
            case Shaders.ENTITY_CUTOUT -> GameRenderer.getRendertypeEntityCutoutShader();
            case Shaders.ENTITY_CUTOUT_NO_CULL -> GameRenderer.getRendertypeEntityCutoutNoCullShader();
            case Shaders.ENTITY_CUTOUT_NO_CULL_Z_OFFSET -> GameRenderer.getRendertypeEntityCutoutNoCullZOffsetShader();
            case Shaders.ITEM_ENTITY_TRANSLUCENT_CULL -> GameRenderer.getRendertypeItemEntityTranslucentCullShader();
            case Shaders.ENTITY_TRANSLUCENT_CULL -> GameRenderer.getRendertypeEntityTranslucentCullShader();
            case Shaders.ENTITY_TRANSLUCENT -> GameRenderer.getRendertypeEntityTranslucentShader();
            case Shaders.ENTITY_TRANSLUCENT_EMISSIVE -> GameRenderer.getRendertypeEntityTranslucentEmissiveShader();
            case Shaders.ENTITY_SMOOTH_CUTOUT -> GameRenderer.getRendertypeEntitySmoothCutoutShader();
            case Shaders.BEACON_BEAM -> GameRenderer.getRendertypeBeaconBeamShader();
            case Shaders.ENTITY_DECAL -> GameRenderer.getRendertypeEntityDecalShader();
            case Shaders.ENTITY_NO_OUTLINE -> GameRenderer.getRendertypeEntityNoOutlineShader();
            case Shaders.ENTITY_SHADOW -> GameRenderer.getRendertypeEntityShadowShader();
            case Shaders.ENTITY_ALPHA -> GameRenderer.getRendertypeEntityAlphaShader();
            case Shaders.EYES -> GameRenderer.getRendertypeEyesShader();
            case Shaders.ENERGY_SWIRL -> GameRenderer.getRendertypeEnergySwirlShader();
            case Shaders.LEASH -> GameRenderer.getRendertypeLeashShader();
            case Shaders.WATER_MASK -> GameRenderer.getRendertypeWaterMaskShader();
            case Shaders.OUTLINE -> GameRenderer.getRendertypeOutlineShader();
            case Shaders.ARMOR_GLINT -> GameRenderer.getRendertypeArmorGlintShader();
            case Shaders.ARMOR_ENTITY_GLINT -> GameRenderer.getRendertypeArmorEntityGlintShader();
            case Shaders.GLINT_TRANSLUCENT -> GameRenderer.getRendertypeGlintTranslucentShader();
            case Shaders.GLINT -> GameRenderer.getRendertypeGlintShader();
            case Shaders.GLINT_DIRECT -> GameRenderer.getRendertypeGlintDirectShader();
            case Shaders.ENTITY_GLINT -> GameRenderer.getRendertypeEntityGlintShader();
            case Shaders.ENTITY_GLINT_DIRECT -> GameRenderer.getRendertypeEntityGlintDirectShader();
            case Shaders.CRUMBLING -> GameRenderer.getRendertypeCrumblingShader();
            case Shaders.TEXT -> GameRenderer.getRendertypeTextShader();
            case Shaders.TEXT_BACKGROUND -> GameRenderer.getRendertypeTextBackgroundShader();
            case Shaders.TEXT_INTENSITY -> GameRenderer.getRendertypeTextIntensityShader();
            case Shaders.TEXT_SEE_THROUGH -> GameRenderer.getRendertypeTextSeeThroughShader();
            case Shaders.TEXT_BACKGROUND_SEE_THROUGH -> GameRenderer.getRendertypeTextBackgroundSeeThroughShader();
            case Shaders.TEXT_INTENSITY_SEE_THROUGH -> GameRenderer.getRendertypeTextIntensitySeeThroughShader();
            case Shaders.LIGHTNING -> GameRenderer.getRendertypeLightningShader();
            case Shaders.TRIPWIRE -> GameRenderer.getRendertypeTripwireShader();
            case Shaders.END_PORTAL -> GameRenderer.getRendertypeEndPortalShader();
            case Shaders.END_GATEWAY -> GameRenderer.getRendertypeEndGatewayShader();
            case Shaders.LINES -> GameRenderer.getRendertypeLinesShader();
            case Shaders.GUI -> GameRenderer.getRendertypeGuiShader();
            case Shaders.GUI_OVERLAY -> GameRenderer.getRendertypeGuiOverlayShader();
            case Shaders.GUI_TEXT_HIGHLIGHT -> GameRenderer.getRendertypeGuiTextHighlightShader();
            case Shaders.GUI_GHOST_RECIPE_OVERLAY -> GameRenderer.getRendertypeGuiGhostRecipeOverlayShader();
        };
        return new MinecraftShader(shader);
    }

    @Override
    public dev.huskuraft.effortless.api.renderer.VertexFormat getVertexFormat(VertexFormats formats) {
        VertexFormat format = switch (formats) {
            default -> throw new MatchException(null, null);
            case VertexFormats.BLIT_SCREEN -> DefaultVertexFormat.BLIT_SCREEN;
            case VertexFormats.BLOCK -> DefaultVertexFormat.BLOCK;
            case VertexFormats.NEW_ENTITY -> DefaultVertexFormat.NEW_ENTITY;
            case VertexFormats.PARTICLE -> DefaultVertexFormat.PARTICLE;
            case VertexFormats.POSITION -> DefaultVertexFormat.POSITION;
            case VertexFormats.POSITION_COLOR -> DefaultVertexFormat.POSITION_COLOR;
            case VertexFormats.POSITION_COLOR_NORMAL -> DefaultVertexFormat.POSITION_COLOR_NORMAL;
            case VertexFormats.POSITION_COLOR_LIGHTMAP -> DefaultVertexFormat.POSITION_COLOR_LIGHTMAP;
            case VertexFormats.POSITION_TEX -> DefaultVertexFormat.POSITION_TEX;
            case VertexFormats.POSITION_COLOR_TEX -> null;
            case VertexFormats.POSITION_TEX_COLOR -> DefaultVertexFormat.POSITION_TEX_COLOR;
            case VertexFormats.POSITION_COLOR_TEX_LIGHTMAP -> DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP;
            case VertexFormats.POSITION_TEX_LIGHTMAP_COLOR -> DefaultVertexFormat.POSITION_TEX_LIGHTMAP_COLOR;
            case VertexFormats.POSITION_TEX_COLOR_NORMAL -> DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL;
        };
        return () -> format;
    }

    @Override
    public VertexFormat.Mode getVertexFormatMode(VertexFormats.Modes modes) {
        VertexFormat.Mode mode = switch (modes) {
            default -> throw new MatchException(null, null);
            case VertexFormats.Modes.LINES -> VertexFormat.Mode.LINES;
            case VertexFormats.Modes.LINE_STRIP -> VertexFormat.Mode.LINE_STRIP;
            case VertexFormats.Modes.DEBUG_LINES -> VertexFormat.Mode.DEBUG_LINES;
            case VertexFormats.Modes.DEBUG_LINE_STRIP -> VertexFormat.Mode.DEBUG_LINE_STRIP;
            case VertexFormats.Modes.TRIANGLES -> VertexFormat.Mode.TRIANGLES;
            case VertexFormats.Modes.TRIANGLE_STRIP -> VertexFormat.Mode.TRIANGLE_STRIP;
            case VertexFormats.Modes.TRIANGLE_FAN -> VertexFormat.Mode.TRIANGLE_FAN;
            case VertexFormats.Modes.QUADS -> VertexFormat.Mode.QUADS;
        };
        return () -> mode;
    }

    private static /* synthetic */ Object lambda$createRenderState$2(1 state) {
        return state;
    }
}

