/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.platform;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.input.KeyBinding;
import dev.huskuraft.effortless.api.platform.ClientContentFactory;
import dev.huskuraft.effortless.api.platform.SearchBy;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.forge.core.MinecraftItemStack;
import dev.huskuraft.effortless.forge.input.MinecraftKeyBinding;
import dev.huskuraft.effortless.forge.platform.MinecraftContentFactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;

@AutoService(value={ClientContentFactory.class})
public class MinecraftClientContentFactory
extends MinecraftContentFactory
implements ClientContentFactory {
    @Override
    public dev.huskuraft.effortless.api.platform.SearchTree<ItemStack> searchItemStack(SearchBy searchBy) {
        LocalPlayer minecraftPlayer = Minecraft.getInstance().player;
        CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)minecraftPlayer.connection.enabledFeatures(), (boolean)true, (HolderLookup.Provider)minecraftPlayer.clientLevel.registryAccess());
        SessionSearchTrees minecraftSearchTrees = Minecraft.getInstance().getConnection().searchTrees();
        SearchTree minecraftSearchTree = switch (searchBy) {
            default -> throw new MatchException(null, null);
            case SearchBy.NAME -> minecraftSearchTrees.creativeNameSearch();
            case SearchBy.TAG -> minecraftSearchTrees.creativeTagSearch();
        };
        return query -> minecraftSearchTree.search(query).stream().map(itemStack -> new MinecraftItemStack((net.minecraft.world.item.ItemStack)itemStack)).collect(Collectors.toList());
    }

    @Override
    public <T> dev.huskuraft.effortless.api.platform.SearchTree<T> search(List<T> list, Function<T, Stream<Text>> keyExtractor) {
        return null;
    }

    @Override
    public KeyBinding newKeyBinding(String name, String category, int code) {
        return new MinecraftKeyBinding(new KeyMapping(name, code, category));
    }
}

