/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.platform;

import dev.huskuraft.effortless.api.core.Interaction;
import dev.huskuraft.effortless.api.core.PlayerInfo;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.gui.Typeface;
import dev.huskuraft.effortless.api.platform.Client;
import dev.huskuraft.effortless.api.platform.Options;
import dev.huskuraft.effortless.api.platform.ParticleEngine;
import dev.huskuraft.effortless.api.renderer.Camera;
import dev.huskuraft.effortless.api.renderer.Window;
import dev.huskuraft.effortless.api.sound.SoundManager;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.core.MinecraftPlayer;
import dev.huskuraft.effortless.forge.core.MinecraftPlayerInfo;
import dev.huskuraft.effortless.forge.core.MinecraftWorld;
import dev.huskuraft.effortless.forge.gui.MinecraftProxyScreen;
import dev.huskuraft.effortless.forge.gui.MinecraftScreen;
import dev.huskuraft.effortless.forge.gui.MinecraftTypeface;
import dev.huskuraft.effortless.forge.platform.MinecraftOptions;
import dev.huskuraft.effortless.forge.renderer.MinecraftCamera;
import dev.huskuraft.effortless.forge.renderer.MinecraftWindow;
import dev.huskuraft.effortless.forge.sound.MinecraftParticleEngine;
import dev.huskuraft.effortless.forge.sound.MinecraftSoundManager;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class MinecraftClient
extends Record
implements Client {
    private final Minecraft refs;

    public MinecraftClient(Minecraft refs) {
        this.refs = refs;
    }

    @Override
    public Window getWindow() {
        return new MinecraftWindow(this.refs.getWindow());
    }

    @Override
    public Camera getCamera() {
        return new MinecraftCamera(this.refs.gameRenderer.getMainCamera());
    }

    @Override
    public dev.huskuraft.effortless.api.gui.Screen getPanel() {
        if (this.refs.screen == null) {
            return null;
        }
        Screen screen = this.refs.screen;
        if (screen instanceof MinecraftProxyScreen) {
            MinecraftProxyScreen proxyScreen = (MinecraftProxyScreen)screen;
            return proxyScreen.getProxy();
        }
        return new MinecraftScreen(this.refs.screen);
    }

    @Override
    public void setPanel(dev.huskuraft.effortless.api.gui.Screen screen) {
        if (screen == null) {
            this.refs.setScreen(null);
            return;
        }
        if (screen instanceof MinecraftScreen) {
            MinecraftScreen minecraftScreen = (MinecraftScreen)screen;
            this.refs.setScreen(minecraftScreen.refs());
            return;
        }
        this.refs.setScreen((Screen)new MinecraftProxyScreen(screen));
    }

    @Override
    public dev.huskuraft.effortless.api.core.Player getPlayer() {
        return MinecraftPlayer.ofNullable((Player)this.refs.player);
    }

    @Override
    public List<PlayerInfo> getOnlinePlayers() {
        if (this.refs.getConnection() == null) {
            return List.of();
        }
        return this.refs.getConnection().getOnlinePlayers().stream().map(MinecraftPlayerInfo::new).collect(Collectors.toList());
    }

    @Override
    public Typeface getTypeface() {
        return new MinecraftTypeface(this.refs.font);
    }

    @Override
    public World getWorld() {
        return MinecraftWorld.ofNullable((Level)this.refs.level);
    }

    @Override
    public boolean isLoaded() {
        return this.getWorld() != null;
    }

    @Override
    public Interaction getLastInteraction() {
        return MinecraftConvertor.fromPlatformInteraction(this.refs.hitResult);
    }

    @Override
    public String getClipboard() {
        return this.refs.keyboardHandler.getClipboard();
    }

    @Override
    public void setClipboard(String content) {
        this.refs.keyboardHandler.setClipboard(content);
    }

    @Override
    public SoundManager getSoundManager() {
        return new MinecraftSoundManager(this.refs.getSoundManager());
    }

    @Override
    public void sendChat(String chat) {
        this.refs.getConnection().sendChat(chat);
    }

    @Override
    public void sendCommand(String command) {
        this.refs.getConnection().sendCommand(command);
    }

    @Override
    public void execute(Runnable runnable) {
        this.refs.execute(runnable);
    }

    @Override
    public Options getOptions() {
        return new MinecraftOptions(this.refs.options);
    }

    @Override
    public ParticleEngine getParticleEngine() {
        return new MinecraftParticleEngine(this.refs.particleEngine);
    }

    @Override
    public boolean isLocalServer() {
        return this.refs.isLocalServer();
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return this.refs.hasSingleplayerServer();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftClient.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftClient.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftClient.class, "refs", "refs"}, this, o);
    }

    public Minecraft refs() {
        return this.refs;
    }
}

