/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.platform;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.platform.Environment;
import dev.huskuraft.effortless.api.platform.LoaderType;
import dev.huskuraft.effortless.api.platform.Mod;
import dev.huskuraft.effortless.api.platform.Platform;
import dev.huskuraft.effortless.forge.platform.ForgeMod;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;

@AutoService(value={Platform.class})
public class ForgePlatform
implements Platform {
    @Override
    public LoaderType getLoaderType() {
        return LoaderType.FORGE;
    }

    @Override
    public String getLoaderVersion() {
        return FMLLoader.versionInfo().forgeVersion();
    }

    @Override
    public String getGameVersion() {
        return FMLLoader.versionInfo().mcVersion();
    }

    @Override
    public List<Mod> getRunningMods() {
        return FMLLoader.getLoadingModList().getMods().stream().map(ForgeMod::new).collect(Collectors.toList());
    }

    @Override
    public Path getGameDir() {
        return FMLLoader.getGamePath();
    }

    @Override
    public Environment getEnvironment() {
        return switch (FMLLoader.getDist()) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> Environment.CLIENT;
            case Dist.DEDICATED_SERVER -> Environment.SERVER;
        };
    }

    @Override
    public boolean isDevelopment() {
        return !FMLLoader.isProduction();
    }
}

