/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.networking;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.networking.ByteBufReceiver;
import dev.huskuraft.effortless.api.networking.ByteBufSender;
import dev.huskuraft.effortless.api.networking.Networking;
import dev.huskuraft.effortless.api.networking.Side;
import dev.huskuraft.effortless.forge.core.MinecraftPlayer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.network.PacketDistributor;

@AutoService(value={Networking.class})
public class ForgeNetworking
implements Networking {
    private static final Map<ResourceLocation, EventNetworkChannel> MAP = new HashMap<ResourceLocation, EventNetworkChannel>();

    private static void register(ResourceLocation channelId, Consumer<CustomPayloadEvent> eventConsumer) {
        MAP.computeIfAbsent(channelId, id -> ChannelBuilder.named((net.minecraft.resources.ResourceLocation)((net.minecraft.resources.ResourceLocation)id.reference())).acceptedVersions((status, i) -> true).eventNetworkChannel()).addListener(eventConsumer);
    }

    public static ByteBufSender register(ResourceLocation channelId, Side side, ByteBufReceiver receiver) {
        switch (side) {
            case CLIENT: {
                ForgeNetworking.register(channelId, event -> {
                    if (event.getPayload() != null && event.getSource().isClientSide()) {
                        receiver.receiveBuffer((ByteBuf)event.getPayload(), MinecraftPlayer.ofNullable((Player)event.getSource().getSender()));
                        event.getSource().setPacketHandled(true);
                    }
                });
                break;
            }
            case SERVER: {
                ForgeNetworking.register(channelId, event -> {
                    if (event.getPayload() != null && event.getSource().isServerSide()) {
                        receiver.receiveBuffer((ByteBuf)event.getPayload(), MinecraftPlayer.ofNullable((Player)event.getSource().getSender()));
                        event.getSource().setPacketHandled(true);
                    }
                });
            }
        }
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.CLIENT -> (byteBuf, player) -> MAP.get(channelId).send((Object)new FriendlyByteBuf(byteBuf), PacketDistributor.SERVER.noArg());
            case Side.SERVER -> (byteBuf, player) -> MAP.get(channelId).send((Object)new FriendlyByteBuf(byteBuf), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player.reference())));
        };
    }
}

