/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.events;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.InteractionType;
import dev.huskuraft.effortless.api.events.impl.ClientEventRegistry;
import dev.huskuraft.effortless.api.events.lifecycle.ClientTick;
import dev.huskuraft.effortless.api.input.InputKey;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.networking.ForgeNetworking;
import dev.huskuraft.effortless.forge.platform.MinecraftClient;
import dev.huskuraft.effortless.forge.renderer.MinecraftRenderer;
import dev.huskuraft.effortless.forge.renderer.MinecraftShader;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@AutoService(value={ClientEventRegistry.class})
public class ForgeClientEventRegistry
extends ClientEventRegistry {
    public ForgeClientEventRegistry() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeyMappings);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onReloadShader);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        this.getClientStartEvent().invoker().onClientStart(new MinecraftClient(Minecraft.getInstance()));
        this.getRegisterNetworkEvent().invoker().onRegisterNetwork(ForgeNetworking::register);
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.getRegisterKeysEvent().invoker().onRegisterKeys(key -> event.register((KeyMapping)key.getKeyBinding().reference()));
    }

    @SubscribeEvent
    public void onReloadShader(RegisterShadersEvent event) {
        this.getRegisterShaderEvent().invoker().onRegisterShader((resource, format, consumer) -> {
            ShaderInstance minecraftShader = new ShaderInstance(event.getResourceProvider(), resource.getPath(), (VertexFormat)format.reference());
            event.registerShader(minecraftShader, shaderInstance -> consumer.accept(new MinecraftShader((ShaderInstance)shaderInstance)));
        });
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        this.getClientTickEvent().invoker().onClientTick(new MinecraftClient(Minecraft.getInstance()), ClientTick.Phase.START);
    }

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        this.getRenderWorldEvent().invoker().onRenderWorld(new MinecraftRenderer(new PoseStack()), event.getPartialTick());
    }

    @SubscribeEvent
    public void onRenderGui(CustomizeGuiOverlayEvent.Chat event) {
        this.getRenderGuiEvent().invoker().onRenderGui(new MinecraftRenderer(event.getGuiGraphics().pose()), event.getPartialTick());
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        this.getKeyInputEvent().invoker().onKeyInput(new InputKey(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers()));
    }

    @SubscribeEvent
    public void onInteractionInput(InputEvent.InteractionKeyMappingTriggered event) {
        InteractionType type = event.isAttack() ? InteractionType.ATTACK : (event.isUseItem() ? InteractionType.USE_ITEM : InteractionType.UNKNOWN);
        InteractionHand hand = MinecraftConvertor.fromPlatformInteractionHand(event.getHand());
        if (this.getInteractionInputEvent().invoker().onInteractionInput(type, hand).interruptsFurtherEvaluation()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }
}

