/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.DimensionType;
import dev.huskuraft.effortless.api.core.FluidState;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.ResourceKey;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.core.WorldBorder;
import dev.huskuraft.effortless.forge.core.MinecraftBlockEntity;
import dev.huskuraft.effortless.forge.core.MinecraftBlockState;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.core.MinecraftDimensionType;
import dev.huskuraft.effortless.forge.core.MinecraftFluidState;
import dev.huskuraft.effortless.forge.core.MinecraftPlayer;
import dev.huskuraft.effortless.forge.core.MinecraftResourceKey;
import dev.huskuraft.effortless.forge.core.MinecraftWorldBorder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.UUID;
import net.minecraft.world.level.Level;

public final class MinecraftWorld
extends Record
implements World {
    private final Level refs;

    public MinecraftWorld(Level refs) {
        this.refs = refs;
    }

    public static World ofNullable(Level refs) {
        if (refs == null) {
            return null;
        }
        return new MinecraftWorld(refs);
    }

    @Override
    public Player getPlayer(UUID uuid) {
        return MinecraftPlayer.ofNullable(this.refs.getPlayerByUUID(uuid));
    }

    @Override
    public BlockState getBlockState(BlockPosition blockPosition) {
        return MinecraftBlockState.ofNullable(this.refs.getBlockState(MinecraftConvertor.toPlatformBlockPosition(blockPosition)));
    }

    @Override
    public FluidState getFluidState(BlockPosition blockPosition) {
        return MinecraftFluidState.ofNullable(this.refs.getFluidState(MinecraftConvertor.toPlatformBlockPosition(blockPosition)));
    }

    @Override
    public BlockEntity getBlockEntity(BlockPosition blockPosition) {
        return MinecraftBlockEntity.ofNullable(this.refs.getBlockEntity(MinecraftConvertor.toPlatformBlockPosition(blockPosition)));
    }

    @Override
    public boolean setBlock(BlockPosition blockPosition, BlockState blockState, int flags, int recursionLeft) {
        return this.refs.setBlock(MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), flags, recursionLeft);
    }

    @Override
    public boolean isClient() {
        return this.refs.isClientSide();
    }

    @Override
    public ResourceKey<World> getDimensionId() {
        return new MinecraftResourceKey<World>(this.refs.dimension());
    }

    @Override
    public DimensionType getDimensionType() {
        return new MinecraftDimensionType(this.refs.dimensionType());
    }

    @Override
    public WorldBorder getWorldBorder() {
        return new MinecraftWorldBorder(this.refs.getWorldBorder());
    }

    @Override
    public boolean removeBlock(BlockPosition blockPosition, boolean moving) {
        return this.refs.removeBlock(MinecraftConvertor.toPlatformBlockPosition(blockPosition), moving);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftWorld.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftWorld.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftWorld.class, "refs", "refs"}, this, o);
    }

    public Level refs() {
        return this.refs;
    }
}

