/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import dev.huskuraft.effortless.api.core.Registry;
import dev.huskuraft.effortless.api.platform.PlatformReference;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;

public final class MinecraftRegistry<T extends PlatformReference, R>
extends Record
implements Registry<T> {
    private final IdMap<R> refs;
    private final Function<R, T> typeConvertor;

    public MinecraftRegistry(IdMap<R> refs, Function<R, T> typeConvertor) {
        this.refs = refs;
        this.typeConvertor = typeConvertor;
    }

    @Override
    public int getId(T value) {
        return this.refs.getId(value.reference());
    }

    @Override
    @Nullable
    public T byId(int key) {
        return (T)((PlatformReference)this.typeConvertor().apply(this.refs.byId(key)));
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.refs.iterator(), this.typeConvertor());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftRegistry.class, "refs;typeConvertor", "refs", "typeConvertor"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftRegistry.class, "refs;typeConvertor", "refs", "typeConvertor"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftRegistry.class, "refs;typeConvertor", "refs", "typeConvertor"}, this, o);
    }

    public IdMap<R> refs() {
        return this.refs;
    }

    public Function<R, T> typeConvertor() {
        return this.typeConvertor;
    }
}

