/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.forge.core.MinecraftItem;
import dev.huskuraft.effortless.forge.core.MinecraftText;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public final class MinecraftItemStack
extends Record
implements ItemStack {
    private final net.minecraft.world.item.ItemStack refs;

    public MinecraftItemStack(net.minecraft.world.item.ItemStack refs) {
        this.refs = refs;
    }

    public static ItemStack ofNullable(net.minecraft.world.item.ItemStack refs) {
        if (refs == null) {
            return null;
        }
        return new MinecraftItemStack(refs);
    }

    @Override
    public Item getItem() {
        return MinecraftItem.ofNullable(this.refs.getItem());
    }

    @Override
    public int getCount() {
        return this.refs.getCount();
    }

    @Override
    public void setCount(int count) {
        this.refs.setCount(count);
    }

    @Override
    public Text getHoverName() {
        return new MinecraftText(this.refs.getHoverName());
    }

    @Override
    public List<Text> getTooltips(dev.huskuraft.effortless.api.core.Player player, ItemStack.TooltipType flag) {
        TooltipFlag.Default minecraftFlag = switch (flag) {
            default -> throw new MatchException(null, null);
            case ItemStack.TooltipType.NORMAL -> TooltipFlag.NORMAL;
            case ItemStack.TooltipType.NORMAL_CREATIVE -> TooltipFlag.NORMAL.asCreative();
            case ItemStack.TooltipType.ADVANCED -> TooltipFlag.ADVANCED;
            case ItemStack.TooltipType.ADVANCED_CREATIVE -> TooltipFlag.ADVANCED.asCreative();
        };
        return this.refs.getTooltipLines(Item.TooltipContext.EMPTY, (Player)player.reference(), (TooltipFlag)minecraftFlag).stream().map(text -> new MinecraftText((Component)text)).collect(Collectors.toList());
    }

    @Override
    public ItemStack copy() {
        return new MinecraftItemStack(this.refs.copy());
    }

    @Override
    public int getDamageValue() {
        return this.refs.getDamageValue();
    }

    @Override
    public void setDamageValue(int damage) {
        this.refs.setDamageValue(damage);
    }

    @Override
    public int getMaxDamage() {
        return this.refs.getMaxDamage();
    }

    @Override
    public boolean isDamageableItem() {
        return this.refs.isDamageableItem();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftItemStack.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftItemStack.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftItemStack.class, "refs", "refs"}, this, o);
    }

    public net.minecraft.world.item.ItemStack refs() {
        return this.refs;
    }
}

