/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import dev.huskuraft.effortless.api.core.Block;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.InteractionResult;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.forge.core.MinecraftBlock;
import dev.huskuraft.effortless.forge.core.MinecraftBlockItem;
import dev.huskuraft.effortless.forge.core.MinecraftBucketItem;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.core.MinecraftDiggerItem;
import dev.huskuraft.effortless.forge.core.MinecraftItemStack;
import dev.huskuraft.effortless.forge.core.MinecraftResourceLocation;
import dev.huskuraft.effortless.forge.core.MinecraftText;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public final class MinecraftItem
extends Record
implements dev.huskuraft.effortless.api.core.Item {
    private final Item refs;

    public MinecraftItem(Item refs) {
        this.refs = refs;
    }

    public static dev.huskuraft.effortless.api.core.Item ofNullable(Item refs) {
        if (refs == null) {
            return null;
        }
        if (refs instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)refs;
            return new MinecraftBlockItem(blockItem);
        }
        if (refs instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)refs;
            return new MinecraftDiggerItem(diggerItem);
        }
        if (refs instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)refs;
            return new MinecraftBucketItem(bucketItem);
        }
        return new MinecraftItem(refs);
    }

    @Override
    public ItemStack getDefaultStack() {
        return new MinecraftItemStack(this.refs.getDefaultInstance());
    }

    @Override
    public Block getBlock() {
        return new MinecraftBlock(net.minecraft.world.level.block.Block.byItem((Item)this.refs));
    }

    @Override
    public ResourceLocation getId() {
        net.minecraft.resources.ResourceLocation minecraftResourceLocation = BuiltInRegistries.ITEM.getKey((Object)this.refs);
        return new MinecraftResourceLocation(minecraftResourceLocation);
    }

    @Override
    public InteractionResult useOnBlock(dev.huskuraft.effortless.api.core.Player player, BlockInteraction blockInteraction) {
        return MinecraftConvertor.fromPlatformInteractionResult(this.refs.useOn(new UseOnContext((Player)player.reference(), MinecraftConvertor.toPlatformInteractionHand(blockInteraction.getHand()), MinecraftConvertor.toPlatformBlockInteraction(blockInteraction))));
    }

    @Override
    public int getMaxStackSize() {
        return this.refs.getDefaultMaxStackSize();
    }

    @Override
    public boolean isCorrectToolForDrops(BlockState blockState) {
        return this.refs.isCorrectToolForDrops(this.refs.getDefaultInstance(), (net.minecraft.world.level.block.state.BlockState)blockState.reference());
    }

    @Override
    public int getMaxDamage() {
        return ((Tool)this.refs.getDefaultInstance().get(DataComponents.TOOL)).damagePerBlock();
    }

    @Override
    public boolean mineBlock(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, ItemStack itemStack) {
        return this.refs.mineBlock((net.minecraft.world.item.ItemStack)itemStack.reference(), (Level)world.reference(), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (LivingEntity)player.reference());
    }

    @Override
    public Text getName(ItemStack itemStack) {
        return new MinecraftText(this.refs.getName((net.minecraft.world.item.ItemStack)itemStack.reference()));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftItem.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftItem.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftItem.class, "refs", "refs"}, this, o);
    }

    public Item refs() {
        return this.refs;
    }
}

