/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import dev.huskuraft.effortless.api.core.Block;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.BucketItem;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.core.fluid.Fluid;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.core.MinecraftFluid;
import dev.huskuraft.effortless.forge.core.MinecraftItem;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public final class MinecraftBucketItem
extends Record
implements BucketItem {
    private final net.minecraft.world.item.BucketItem refs;

    public MinecraftBucketItem(net.minecraft.world.item.BucketItem refs) {
        this.refs = refs;
    }

    @Override
    public Fluid getContent() {
        return MinecraftFluid.ofNullable(this.refs.getFluid());
    }

    @Override
    public boolean useContent(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockInteraction blockInteraction) {
        return this.refs.emptyContents((Player)player.reference(), (Level)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), MinecraftConvertor.toPlatformBlockInteraction(blockInteraction));
    }

    @Override
    public void useExtraContent(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, ItemStack itemStack) {
        this.refs.checkExtraContent((Player)player.reference(), (Level)world.reference(), (net.minecraft.world.item.ItemStack)itemStack.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition));
    }

    @Override
    public ItemStack getDefaultStack() {
        return new MinecraftItem((Item)this.refs).getDefaultStack();
    }

    @Override
    public Block getBlock() {
        return new MinecraftItem((Item)this.refs).getBlock();
    }

    @Override
    public ResourceLocation getId() {
        return new MinecraftItem((Item)this.refs).getId();
    }

    @Override
    public boolean isCorrectToolForDrops(BlockState blockState) {
        return new MinecraftItem((Item)this.refs).isCorrectToolForDrops(blockState);
    }

    @Override
    public int getMaxStackSize() {
        return new MinecraftItem((Item)this.refs).getMaxStackSize();
    }

    @Override
    public int getMaxDamage() {
        return new MinecraftItem((Item)this.refs).getMaxDamage();
    }

    @Override
    public boolean mineBlock(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, ItemStack itemStack) {
        return new MinecraftItem((Item)this.refs).mineBlock(world, player, blockPosition, blockState, itemStack);
    }

    @Override
    public Text getName(ItemStack itemStack) {
        return new MinecraftItem((Item)this.refs).getName(itemStack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftBucketItem.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftBucketItem.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftBucketItem.class, "refs", "refs"}, this, o);
    }

    public net.minecraft.world.item.BucketItem refs() {
        return this.refs;
    }
}

