/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import dev.huskuraft.effortless.api.core.Block;
import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.FluidState;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.core.fluid.BucketCollectable;
import dev.huskuraft.effortless.api.core.fluid.Fluid;
import dev.huskuraft.effortless.api.core.fluid.LiquidPlaceable;
import dev.huskuraft.effortless.api.sound.Sound;
import dev.huskuraft.effortless.forge.core.MinecraftBlockEntity;
import dev.huskuraft.effortless.forge.core.MinecraftBlockState;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.core.MinecraftItem;
import dev.huskuraft.effortless.forge.core.MinecraftItemStack;
import dev.huskuraft.effortless.forge.sound.MinecraftSound;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;

public final class MinecraftBlock
extends Record
implements Block {
    private final net.minecraft.world.level.block.Block refs;

    public MinecraftBlock(net.minecraft.world.level.block.Block refs) {
        this.refs = refs;
    }

    @Override
    public BlockState getDefaultBlockState() {
        return MinecraftBlockState.ofNullable(this.refs.defaultBlockState());
    }

    @Override
    public BlockState getBlockState(dev.huskuraft.effortless.api.core.Player player, BlockInteraction interaction) {
        return MinecraftBlockState.ofNullable(this.refs.getStateForPlacement(MinecraftConvertor.toPlatformBlockPlaceContext(player, interaction)));
    }

    @Override
    public BucketCollectable getBucketCollectable() {
        net.minecraft.world.level.block.Block block = this.refs;
        if (block instanceof BucketPickup) {
            final BucketPickup bucketPickup = (BucketPickup)block;
            return new BucketCollectable(){

                @Override
                public ItemStack pickupBlock(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState) {
                    return new MinecraftItemStack(bucketPickup.pickupBlock((Player)player.reference(), (LevelAccessor)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference()));
                }

                @Override
                public Optional<Sound> getPickupSound() {
                    return bucketPickup.getPickupSound().map(MinecraftSound::new);
                }
            };
        }
        return null;
    }

    @Override
    public LiquidPlaceable getLiquidPlaceable() {
        net.minecraft.world.level.block.Block block = this.refs;
        if (block instanceof LiquidBlockContainer) {
            final LiquidBlockContainer liquidPlace = (LiquidBlockContainer)block;
            return new LiquidPlaceable(){

                @Override
                public boolean canPlaceLiquid(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, Fluid fluid) {
                    return liquidPlace.canPlaceLiquid((Player)player.reference(), (BlockGetter)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), (net.minecraft.world.level.material.Fluid)fluid.reference());
                }

                @Override
                public boolean placeLiquid(World world, BlockPosition blockPosition, BlockState blockState, FluidState fluidState) {
                    return liquidPlace.placeLiquid((LevelAccessor)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), (net.minecraft.world.level.material.FluidState)fluidState.reference());
                }
            };
        }
        return null;
    }

    @Override
    public void destroy(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState) {
        this.refs.destroy((LevelAccessor)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference());
    }

    @Override
    public void destroyStart(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack) {
        this.refs.playerWillDestroy((Level)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), (Player)player.reference());
    }

    @Override
    public void destroyEnd(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack) {
        this.refs.playerDestroy((Level)world.reference(), (Player)player.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), blockEntity == null ? null : (net.minecraft.world.level.block.entity.BlockEntity)blockEntity.reference(), (net.minecraft.world.item.ItemStack)itemStack.reference());
    }

    @Override
    public void place(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, ItemStack itemStack) {
        this.refs.setPlacedBy((Level)world.reference(), MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference(), (LivingEntity)player.reference(), (net.minecraft.world.item.ItemStack)itemStack.reference());
    }

    @Override
    public Item asItem() {
        return MinecraftItem.ofNullable(this.refs.asItem());
    }

    @Override
    public BlockEntity getEntity(BlockPosition blockPosition, BlockState blockState) {
        net.minecraft.world.level.block.Block block = this.refs;
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            return MinecraftBlockEntity.ofNullable(entityBlock.newBlockEntity(MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.state.BlockState)blockState.reference()));
        }
        return null;
    }

    @Override
    public List<ItemStack> getDrops(World world, dev.huskuraft.effortless.api.core.Player player, BlockPosition blockPosition, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        return net.minecraft.world.level.block.Block.getDrops((net.minecraft.world.level.block.state.BlockState)((net.minecraft.world.level.block.state.BlockState)blockState.reference()), (ServerLevel)((ServerLevel)world.reference()), (BlockPos)MinecraftConvertor.toPlatformBlockPosition(blockPosition), (net.minecraft.world.level.block.entity.BlockEntity)(blockEntity == null ? null : (net.minecraft.world.level.block.entity.BlockEntity)blockEntity.reference()), (Entity)((Entity)player.reference()), (net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)itemStack.reference())).stream().map(MinecraftItemStack::ofNullable).toList();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftBlock.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftBlock.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftBlock.class, "refs", "refs"}, this, o);
    }

    public net.minecraft.world.level.block.Block refs() {
        return this.refs;
    }
}

