/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.fabric.platform;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.platform.Environment;
import dev.huskuraft.effortless.api.platform.LoaderType;
import dev.huskuraft.effortless.api.platform.Mod;
import dev.huskuraft.effortless.api.platform.Platform;
import dev.huskuraft.effortless.fabric.platform.FabricMod;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;

@AutoService(value={Platform.class})
public class FabricPlatform
implements Platform {
    @Override
    public LoaderType getLoaderType() {
        return LoaderType.FABRIC;
    }

    @Override
    public String getLoaderVersion() {
        return "0.16.10";
    }

    @Override
    public String getGameVersion() {
        return FabricLoaderImpl.INSTANCE.getGameProvider().getRawGameVersion();
    }

    @Override
    public List<Mod> getRunningMods() {
        return FabricLoader.getInstance().getAllMods().stream().map(FabricMod::new).collect(Collectors.toList());
    }

    @Override
    public Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Environment getEnvironment() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new MatchException(null, null);
            case EnvType.CLIENT -> Environment.CLIENT;
            case EnvType.SERVER -> Environment.SERVER;
        };
    }

    @Override
    public boolean isDevelopment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

