/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.fabric.networking;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.networking.ByteBufReceiver;
import dev.huskuraft.effortless.api.networking.ByteBufSender;
import dev.huskuraft.effortless.api.networking.Networking;
import dev.huskuraft.effortless.api.networking.Side;
import dev.huskuraft.effortless.fabric.core.MinecraftPlayer;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@AutoService(value={Networking.class})
public class FabricNetworking
implements Networking {
    public static final Map<ResourceLocation, class_8710.class_9154<Payload>> MAP = new HashMap<ResourceLocation, class_8710.class_9154<Payload>>();

    public static ByteBufSender register(ResourceLocation channelId, Side side, ByteBufReceiver receiver) {
        class_8710.class_9154 payloadType = MAP.computeIfAbsent(channelId, resourceLocation -> {
            final class_8710.class_9154 type = new class_8710.class_9154((class_2960)channelId.reference());
            class_9139<class_9129, Payload> codec = new class_9139<class_9129, Payload>(){

                public Payload decode(class_9129 byteBuf) {
                    return new Payload((class_8710.class_9154<Payload>)type, byteBuf.readBytes(byteBuf.readableBytes()));
                }

                public void encode(class_9129 byteBuf, Payload payload) {
                    byteBuf.method_52975(payload.byteBuf());
                }
            };
            PayloadTypeRegistry.playC2S().register(type, (class_9139)codec);
            PayloadTypeRegistry.playS2C().register(type, (class_9139)codec);
            return type;
        });
        FabricNetworking fabricSide = switch (side) {
            default -> throw new MatchException(null, null);
            case Side.CLIENT -> new Client();
            case Side.SERVER -> new Server();
        };
        fabricSide.registerReceiver((class_8710.class_9154<Payload>)payloadType, (payload, player) -> receiver.receiveBuffer(payload.byteBuf(), (Player)player));
        return (byteBuf, player) -> fabricSide.send(new Payload((class_8710.class_9154<Payload>)payloadType, byteBuf), player);
    }

    void registerReceiver(class_8710.class_9154<Payload> type, BiConsumer<Payload, Player> receiver) {
    }

    void send(Payload payload, Player player) {
    }

    static class Client
    extends FabricNetworking {
        Client() {
        }

        @Override
        public void registerReceiver(class_8710.class_9154<Payload> type, BiConsumer<Payload, Player> receiver) {
            ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> receiver.accept((Payload)payload, MinecraftPlayer.ofNullable((class_1657)context.player())));
        }

        @Override
        public void send(Payload payload, Player player) {
            ClientPlayNetworking.send((class_8710)payload);
        }
    }

    static class Server
    extends FabricNetworking {
        Server() {
        }

        @Override
        public void registerReceiver(class_8710.class_9154<Payload> type, BiConsumer<Payload, Player> receiver) {
            ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> receiver.accept((Payload)payload, MinecraftPlayer.ofNullable((class_1657)context.player())));
        }

        @Override
        public void send(Payload payload, Player player) {
            ServerPlayNetworking.send((class_3222)((class_3222)player.reference()), (class_8710)payload);
        }
    }

    public static final class Payload
    extends Record
    implements class_8710 {
        private final class_8710.class_9154<Payload> type;
        private final ByteBuf byteBuf;

        public Payload(class_8710.class_9154<Payload> type, ByteBuf byteBuf) {
            this.type = type;
            this.byteBuf = byteBuf;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Payload.class, "type;byteBuf", "type", "byteBuf"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Payload.class, "type;byteBuf", "type", "byteBuf"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Payload.class, "type;byteBuf", "type", "byteBuf"}, this, o);
        }

        public class_8710.class_9154<Payload> method_56479() {
            return this.type;
        }

        public ByteBuf byteBuf() {
            return this.byteBuf;
        }
    }
}

