/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.CircleStart;
import dev.huskuraft.effortless.building.structure.PlaneFacing;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Circle;
import dev.huskuraft.effortless.building.structure.builder.standard.Floor;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import dev.huskuraft.effortless.building.structure.builder.standard.Square;
import dev.huskuraft.effortless.building.structure.builder.standard.Wall;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public record Sphere(CircleStart circleStart, PlaneFacing planeFacing, PlaneFilling planeFilling, PlaneLength planeLength) implements BlockStructure
{
    public Sphere() {
        this(CircleStart.CORNER, PlaneFacing.BOTH, PlaneFilling.FILLED, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.CIRCLE_START -> new Sphere((CircleStart)feature, this.planeFacing, this.planeFilling, this.planeLength);
            case BuildFeatures.PLANE_FACING -> new Sphere(this.circleStart, (PlaneFacing)feature, this.planeFilling, this.planeLength);
            case BuildFeatures.PLANE_FILLING -> new Sphere(this.circleStart, this.planeFacing, (PlaneFilling)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Sphere(this.circleStart, this.planeFacing, this.planeFilling, (PlaneLength)feature);
            default -> this;
        };
    }

    public static boolean isPosInSphere(float centerX, float centerY, float centerZ, float radiusX, float radiusY, float radiusZ, int x, int y, int z, boolean fill) {
        float xn = Math.abs((float)x - centerX) / (radiusX += 0.5f);
        float yn = Math.abs((float)y - centerY) / (radiusY += 0.5f);
        float zn = Math.abs((float)z - centerZ) / (radiusZ += 0.5f);
        float xn1 = (Math.abs((float)x - centerX) + 1.0f) / radiusX;
        float yn1 = (Math.abs((float)y - centerY) + 1.0f) / radiusY;
        float zn1 = (Math.abs((float)z - centerZ) + 1.0f) / radiusZ;
        if (fill) {
            return BlockStructure.lengthSq(xn, yn, zn) < 1.0;
        }
        return !(!(BlockStructure.lengthSq(xn, yn, zn) < 1.0) || BlockStructure.lengthSq(xn1, yn, zn) <= 1.0 && BlockStructure.lengthSq(xn, yn1, zn) <= 1.0 && BlockStructure.lengthSq(xn, yn, zn1) <= 1.0);
    }

    public static void addSphereBlocks(Set<BlockPosition> set, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerY, float centerZ, float radiusX, float radiusY, float radiusZ, boolean fill) {
        int x11 = x1;
        while (x1 < x2 ? x11 <= x2 : x11 >= x2) {
            int z11 = z1;
            while (z1 < z2 ? z11 <= z2 : z11 >= z2) {
                int y11 = y1;
                while (y1 < y2 ? y11 <= y2 : y11 >= y2) {
                    if (Sphere.isPosInSphere(centerX, centerY, centerZ, radiusX, radiusY, radiusZ, x11, y11, z11, fill)) {
                        set.add(new BlockPosition(x11, y11, z11));
                    }
                    y11 += y1 < y2 ? 1 : -1;
                }
                z11 += z1 < z2 ? 1 : -1;
            }
            x11 += x1 < x2 ? 1 : -1;
        }
    }

    public static Stream<BlockPosition> collectSphereBlocks(Context context, CircleStart circleStart, PlaneFilling planeFilling) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        boolean isCenter = circleStart == CircleStart.CENTER;
        boolean isFull = planeFilling == PlaneFilling.FILLED;
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        BlockPosition pos3 = context.getPosition(2);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        int x3 = pos3.x();
        int y3 = pos3.y();
        int z3 = pos3.z();
        if (isCenter) {
            x1 = (x1 - x2) * 2 + x1;
            y1 = (y1 - y2) * 2 + y1;
            z1 = (z1 - z2) * 2 + z1;
        }
        int minX = MathUtils.min(x1, MathUtils.min(x2, x3));
        int minY = MathUtils.min(y1, MathUtils.min(y2, y3));
        int minZ = MathUtils.min(z1, MathUtils.min(z2, z3));
        int maxX = MathUtils.max(x1, MathUtils.max(x2, x3));
        int maxY = MathUtils.max(y1, MathUtils.max(y2, y3));
        int maxZ = MathUtils.max(z1, MathUtils.max(z2, z3));
        float centerX = (float)(minX + maxX) / 2.0f;
        float centerY = (float)(minY + maxY) / 2.0f;
        float centerZ = (float)(minZ + maxZ) / 2.0f;
        float radiusX = (float)(maxX - minX) / 2.0f;
        float radiusY = (float)(maxY - minY) / 2.0f;
        float radiusZ = (float)(maxZ - minZ) / 2.0f;
        Sphere.addSphereBlocks(set, minX, minY, minZ, maxX, maxY, maxZ, centerX, centerY, centerZ, radiusX, radiusY, radiusZ, isFull);
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> {
                switch (this.planeFacing()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOTH: {
                        yield Square.traceSquare(player, context, this.planeFacing, this.planeLength);
                    }
                    case VERTICAL: {
                        yield Wall.traceWall(player, context, this.planeLength);
                    }
                    case HORIZONTAL: 
                }
                yield Floor.traceFloor(player, context, this.planeLength);
            }
            case 2 -> {
                switch (this.planeFacing()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOTH: {
                        yield Line.traceLineOnPlane(player, context.getPosition(0), context.getPosition(1));
                    }
                    case VERTICAL: {
                        yield Line.traceLineOnVerticalPlane(player, context.getPosition(0), context.getPosition(1));
                    }
                    case HORIZONTAL: 
                }
                yield Line.traceLineOnHorizontalPlane(player, context.getPosition(0), context.getPosition(1));
            }
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Circle.collectCircleBlocks(context, this.circleStart, this.planeFilling);
            case 3 -> Sphere.collectSphereBlocks(context, this.circleStart, this.planeFilling);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 3;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.SPHERE;
    }
}

