/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Floor;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import java.util.LinkedHashSet;
import java.util.stream.Stream;

public record Pyramid(PlaneFilling planeFilling, PlaneLength planeLength) implements BlockStructure
{
    public Pyramid() {
        this(PlaneFilling.FILLED, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.PLANE_FILLING -> new Pyramid((PlaneFilling)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Pyramid(this.planeFilling, (PlaneLength)feature);
            default -> this;
        };
    }

    protected static Stream<BlockPosition> collectPyramidBlocks(Context context) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        BlockPosition pos3 = context.getPosition(2);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        int x3 = pos3.x();
        int y3 = pos3.y();
        int z3 = pos3.z();
        int minX = Math.min(x1, x2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxZ = Math.max(z1, z2);
        int radiusX = maxX - minX;
        int radiusZ = maxZ - minZ;
        int centerX = (maxX + minX) / 2;
        int centerZ = (maxZ + minZ) / 2;
        int radiusX1 = radiusX;
        int radiusZ1 = radiusZ;
        for (int y = y1; y <= y3; ++y) {
            if (y3 - y1 != 0) {
                radiusX1 = radiusX * (y3 - y) / (y3 - y1) / 2;
                radiusZ1 = radiusZ * (y3 - y) / (y3 - y1) / 2;
            }
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (Math.abs(x - centerX) > radiusX1 || Math.abs(z - centerZ) > radiusZ1) continue;
                    set.add(new BlockPosition(x, y, z));
                }
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Floor.traceFloor(player, context, this.planeLength);
            case 2 -> Line.traceLineY(player, context.getPosition(1));
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Floor.collectFloorBlocks(context, this.planeFilling);
            case 3 -> Pyramid.collectPyramidBlocks(context);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 3;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.PYRAMID;
    }
}

