/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.LineDirection;
import dev.huskuraft.effortless.building.structure.PlaneFacing;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.TraceShape;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public record Line(LineDirection lineDirection) implements BlockStructure
{
    public Line() {
        this(LineDirection.ALL);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.LINE_DIRECTION -> new Line((LineDirection)feature);
            default -> this;
        };
    }

    public static BlockInteraction traceLineOnPlane(Player player, Context context, PlaneFacing planeFacing) {
        return Line.traceLineOnPlane(player, context.getPosition(0), context.getPosition(1), planeFacing);
    }

    public static BlockInteraction traceLineOnPlane(Player player, BlockPosition pos1, BlockPosition pos2, PlaneFacing planeFacing) {
        return switch (BlockStructure.getShape(pos1, pos2)) {
            case TraceShape.PLANE_X -> {
                switch (planeFacing) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOTH: 
                    case VERTICAL: {
                        yield Line.traceLineX(player, pos2);
                    }
                    case HORIZONTAL: 
                }
                yield null;
            }
            case TraceShape.PLANE_Y -> {
                switch (planeFacing) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOTH: 
                    case HORIZONTAL: {
                        yield Line.traceLineY(player, pos2);
                    }
                    case VERTICAL: 
                }
                yield null;
            }
            case TraceShape.PLANE_Z -> {
                switch (planeFacing) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOTH: 
                    case VERTICAL: {
                        yield Line.traceLineZ(player, pos2);
                    }
                    case HORIZONTAL: 
                }
                yield null;
            }
            default -> null;
        };
    }

    public static BlockInteraction traceLineOnPlane(Player player, BlockPosition pos1, BlockPosition pos2) {
        return switch (BlockStructure.getShape(pos1, pos2)) {
            case TraceShape.PLANE_X -> Line.traceLineX(player, pos2);
            case TraceShape.PLANE_Y -> Line.traceLineY(player, pos2);
            case TraceShape.PLANE_Z -> Line.traceLineZ(player, pos2);
            default -> null;
        };
    }

    public static BlockInteraction traceLineOnVerticalPlane(Player player, BlockPosition pos1, BlockPosition pos2) {
        return switch (BlockStructure.getShape(pos1, pos2)) {
            case TraceShape.PLANE_X -> Line.traceLineX(player, pos2);
            case TraceShape.PLANE_Z -> Line.traceLineZ(player, pos2);
            default -> null;
        };
    }

    public static BlockInteraction traceLineOnHorizontalPlane(Player player, BlockPosition pos1, BlockPosition pos2) {
        return switch (BlockStructure.getShape(pos1, pos2)) {
            case TraceShape.PLANE_Y -> Line.traceLineY(player, pos2);
            default -> null;
        };
    }

    public static BlockInteraction traceLine(Player player, Context context, LineDirection lineDirection) {
        return Line.traceLine(player, context.getPosition(0), lineDirection.getAxes());
    }

    public static BlockInteraction traceLineX(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.X));
    }

    public static BlockInteraction traceLineY(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.Y));
    }

    public static BlockInteraction traceLineZ(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.Z));
    }

    public static BlockInteraction traceLineXZ(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.X, Axis.Z));
    }

    public static BlockInteraction traceLineYZ(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.Y, Axis.Z));
    }

    public static BlockInteraction traceLineXY(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.X, Axis.Y));
    }

    public static BlockInteraction traceLine(Player player, BlockPosition start) {
        return Line.traceLine(player, start, Set.of(Axis.X, Axis.Y, Axis.Z));
    }

    public static BlockInteraction traceLine(Player player, BlockPosition start, Set<Axis> axes) {
        Vector3d center = start.getCenter();
        int reach = 1024;
        boolean skipRaytrace = false;
        return Stream.of(new BlockStructure.NearestAxisLineCriteria(axes, Axis.X, player, center, reach, skipRaytrace), new BlockStructure.NearestAxisLineCriteria(axes, Axis.Y, player, center, reach, skipRaytrace), new BlockStructure.NearestAxisLineCriteria(axes, Axis.Z, player, center, reach, skipRaytrace)).filter(BlockStructure.AxisCriteria::isInRange).min(Comparator.comparing(BlockStructure.NearestLineCriteria::distanceToLineSqr)).map(BlockStructure.AxisCriteria::traceLine).orElse(null);
    }

    public static Stream<BlockPosition> collectLineBlocks(Context context) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        Line.addLineBlocks(set, x1, y1, z1, x2, y2, z2);
        return set.stream();
    }

    public static void addLineBlocks(Set<BlockPosition> set, int x1, int y1, int z1, int x2, int y2, int z2) {
        switch (BlockStructure.getShape(x1, y1, z1, x2, y2, z2)) {
            case SINGLE: {
                Single.addSingleBlock(set, x1, y1, z1);
                break;
            }
            case LINE_X: {
                Line.addXLineBlocks(set, x1, x2, y1, z1);
                break;
            }
            case LINE_Y: {
                Line.addYLineBlocks(set, y1, y2, x1, z1);
                break;
            }
            case LINE_Z: {
                Line.addZLineBlocks(set, z1, z2, x1, y1);
            }
        }
    }

    public static void addXLineBlocks(Set<BlockPosition> set, int x1, int x2, int y, int z) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            set.add(new BlockPosition(x, y, z));
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addYLineBlocks(Set<BlockPosition> set, int y1, int y2, int x, int z) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            set.add(new BlockPosition(x, y, z));
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addZLineBlocks(Set<BlockPosition> set, int z1, int z2, int x, int y) {
        int z = z1;
        while (z1 < z2 ? z <= z2 : z >= z2) {
            set.add(new BlockPosition(x, y, z));
            z += z1 < z2 ? 1 : -1;
        }
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Line.traceLine(player, context, this.lineDirection);
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Line.collectLineBlocks(context);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 2;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.LINE;
    }
}

