/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.CircleStart;
import dev.huskuraft.effortless.building.structure.PlaneFacing;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Circle;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import dev.huskuraft.effortless.building.structure.builder.standard.Square;
import java.util.LinkedHashSet;
import java.util.stream.Stream;

public record Cylinder(CircleStart circleStart, PlaneFilling planeFilling, PlaneFacing planeFacing, PlaneLength planeLength) implements BlockStructure
{
    public Cylinder() {
        this(CircleStart.CORNER, PlaneFilling.FILLED, PlaneFacing.BOTH, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.CIRCLE_START -> new Cylinder((CircleStart)feature, this.planeFilling, this.planeFacing, this.planeLength);
            case BuildFeatures.PLANE_FILLING -> new Cylinder(this.circleStart, (PlaneFilling)feature, this.planeFacing, this.planeLength);
            case BuildFeatures.PLANE_FACING -> new Cylinder(this.circleStart, this.planeFilling, (PlaneFacing)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Cylinder(this.circleStart, this.planeFilling, this.planeFacing, (PlaneLength)feature);
            default -> this;
        };
    }

    public static Stream<BlockPosition> collectCylinderBlocks(Context context, CircleStart circleStart, PlaneFilling planeFilling) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        BlockPosition pos3 = context.getPosition(2);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x3 = pos3.x();
        int y3 = pos3.y();
        int z3 = pos3.z();
        switch (BlockStructure.getShape(pos1, pos2)) {
            case PLANE_X: {
                int x = x1;
                while (x1 < x3 ? x <= x3 : x >= x3) {
                    int x0 = x;
                    set.addAll(Circle.collectCircleBlocks(context, circleStart, planeFilling).map(blockPosition -> new BlockPosition(x0, blockPosition.y(), blockPosition.z())).toList());
                    x += x1 < x3 ? 1 : -1;
                }
                break;
            }
            case PLANE_Y: {
                int y = y1;
                while (y1 < y3 ? y <= y3 : y >= y3) {
                    int y0 = y;
                    set.addAll(Circle.collectCircleBlocks(context, circleStart, planeFilling).map(blockPosition -> new BlockPosition(blockPosition.x(), y0, blockPosition.z())).toList());
                    y += y1 < y3 ? 1 : -1;
                }
                break;
            }
            case PLANE_Z: {
                int z = z1;
                while (z1 < z3 ? z <= z3 : z >= z3) {
                    int z0 = z;
                    set.addAll(Circle.collectCircleBlocks(context, circleStart, planeFilling).map(blockPosition -> new BlockPosition(blockPosition.x(), blockPosition.y(), z0)).toList());
                    z += z1 < z3 ? 1 : -1;
                }
                break;
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Square.traceSquare(player, context, this.planeFacing, this.planeLength);
            case 2 -> {
                switch (this.planeFacing) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOTH: {
                        yield Line.traceLineOnPlane(player, context.getPosition(0), context.getPosition(1));
                    }
                    case VERTICAL: {
                        yield Line.traceLineOnVerticalPlane(player, context.getPosition(0), context.getPosition(1));
                    }
                    case HORIZONTAL: 
                }
                yield Line.traceLineOnHorizontalPlane(player, context.getPosition(0), context.getPosition(1));
            }
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Circle.collectCircleBlocks(context, this.circleStart, this.planeFilling);
            case 3 -> Cylinder.collectCylinderBlocks(context, this.circleStart, this.planeFilling);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 3;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.CYLINDER;
    }
}

