/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.CircleStart;
import dev.huskuraft.effortless.building.structure.PlaneFacing;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import dev.huskuraft.effortless.building.structure.builder.standard.Square;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public record Circle(CircleStart circleStart, PlaneFacing planeFacing, PlaneFilling planeFilling, PlaneLength planeLength) implements BlockStructure
{
    public Circle() {
        this(CircleStart.CORNER, PlaneFacing.BOTH, PlaneFilling.FILLED, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.CIRCLE_START -> new Circle((CircleStart)feature, this.planeFacing, this.planeFilling, this.planeLength);
            case BuildFeatures.PLANE_FACING -> new Circle(this.circleStart, (PlaneFacing)feature, this.planeFilling, this.planeLength);
            case BuildFeatures.PLANE_FILLING -> new Circle(this.circleStart, this.planeFacing, (PlaneFilling)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Circle(this.circleStart, this.planeFacing, this.planeFilling, (PlaneLength)feature);
            default -> this;
        };
    }

    public static boolean isPosInCircle(float centerX, float centerY, float radiusX, float radiusY, int x, int y, boolean fill) {
        float xn = Math.abs((float)x - centerX) / (radiusX += 0.5f);
        float yn = Math.abs((float)y - centerY) / (radiusY += 0.5f);
        float xn1 = (Math.abs((float)x - centerX) + 1.0f) / radiusX;
        float yn1 = (Math.abs((float)y - centerY) + 1.0f) / radiusY;
        if (fill) {
            return BlockStructure.lengthSq(xn, yn) < 1.0;
        }
        return !(!(BlockStructure.lengthSq(xn, yn) < 1.0) || BlockStructure.lengthSq(xn1, yn) <= 1.0 && BlockStructure.lengthSq(xn, yn1) <= 1.0);
    }

    public static void addCircleBlocksX(Set<BlockPosition> set, int x1, int y1, int z1, int x2, int y2, int z2, float centerY, float centerZ, float radiusY, float radiusZ, boolean fill) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            int z = z1;
            while (z1 < z2 ? z <= z2 : z >= z2) {
                boolean radius = Circle.isPosInCircle(centerY, centerZ, radiusY, radiusZ, y, z, fill);
                if (radius) {
                    set.add(new BlockPosition(x1, y, z));
                }
                z += z1 < z2 ? 1 : -1;
            }
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addCircleBlocksY(Set<BlockPosition> set, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerZ, float radiusX, float radiusZ, boolean fill) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                boolean radius = Circle.isPosInCircle(centerX, centerZ, radiusX, radiusZ, l, n, fill);
                if (radius) {
                    set.add(new BlockPosition(l, y1, n));
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addCircleBlocksZ(Set<BlockPosition> set, int x1, int y1, int z1, int x2, int y2, int z2, float centerY, float centerX, float radiusY, float radiusX, boolean fill) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            int x = x1;
            while (x1 < x2 ? x <= x2 : x >= x2) {
                boolean radius = Circle.isPosInCircle(centerY, centerX, radiusY, radiusX, y, x, fill);
                if (radius) {
                    set.add(new BlockPosition(x, y, z1));
                }
                x += x1 < x2 ? 1 : -1;
            }
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static Stream<BlockPosition> collectCircleBlocks(Context context, CircleStart circleStart, PlaneFilling planeFilling) {
        float centerZ;
        LinkedHashSet set = Sets.newLinkedHashSet();
        boolean isCenter = circleStart == CircleStart.CENTER;
        boolean isFill = planeFilling == PlaneFilling.FILLED;
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        float centerX = isCenter ? (float)x1 : (float)x1 + (float)(x2 - x1) / 2.0f;
        float centerY = isCenter ? (float)y1 : (float)y1 + (float)(y2 - y1) / 2.0f;
        float f = centerZ = isCenter ? (float)z1 : (float)z1 + (float)(z2 - z1) / 2.0f;
        if (isCenter) {
            x1 = (x1 - x2) * 2 + x1;
            y1 = (y1 - y2) * 2 + y1;
            z1 = (z1 - z2) * 2 + z1;
        }
        float radiusX = MathUtils.abs((float)x2 - centerX);
        float radiusY = MathUtils.abs((float)y2 - centerY);
        float radiusZ = MathUtils.abs((float)z2 - centerZ);
        switch (BlockStructure.getShape(pos1, pos2)) {
            case SINGLE: {
                Single.addSingleBlock(set, x1, y1, z1);
                break;
            }
            case LINE_X: 
            case LINE_Y: 
            case LINE_Z: {
                Line.addLineBlocks(set, x1, y1, z1, x2, y2, z2);
                break;
            }
            case PLANE_X: {
                Circle.addCircleBlocksX(set, x1, y1, z1, x2, y2, z2, centerY, centerZ, radiusY, radiusZ, isFill);
                break;
            }
            case PLANE_Y: {
                Circle.addCircleBlocksY(set, x1, y1, z1, x2, y2, z2, centerX, centerZ, radiusX, radiusZ, isFill);
                break;
            }
            case PLANE_Z: {
                Circle.addCircleBlocksZ(set, x1, y1, z1, x2, y2, z2, centerY, centerX, radiusY, radiusX, isFill);
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Square.traceSquare(player, context, this.planeFacing, this.planeLength);
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Circle.collectCircleBlocks(context, this.circleStart, this.planeFilling);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 2;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.CIRCLE;
    }
}

