/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.randomize;

import dev.huskuraft.effortless.api.core.BlockItem;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.BuildStage;
import dev.huskuraft.effortless.building.BuildState;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.batch.DeferredBatchOperation;
import dev.huskuraft.effortless.building.pattern.RefactorContext;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.randomize.Chance;
import dev.huskuraft.effortless.building.pattern.randomize.Producer;
import dev.huskuraft.effortless.building.pattern.randomize.Randomizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record ItemRandomizer(UUID id, Text name, Randomizer.Order order, Randomizer.Target target, Source source, Collection<Chance<Item>> chances) implements Randomizer<Item>
{
    public static final int MAX_CHANCE_SIZE = 36;
    public static final ItemRandomizer RANDOM_INVENTORY = ItemRandomizer.create(Text.translate("effortless.transformer.randomizer.item.random_inventory"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, Source.INVENTORY, Collections.emptyList());
    public static final ItemRandomizer RANDOM_HOTBAR = ItemRandomizer.create(Text.translate("effortless.transformer.randomizer.item.random_hotbar"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, Source.HOTBAR, Collections.emptyList());
    public static final ItemRandomizer RANDOM_HANDS = ItemRandomizer.create(Text.translate("effortless.transformer.randomizer.item.random_hands"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, Source.HANDS, Collections.emptyList());
    public static final ItemRandomizer SEQUENCE_INVENTORY = ItemRandomizer.create(Text.translate("effortless.transformer.randomizer.item.sequence_inventory"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, Source.INVENTORY, Collections.emptyList());
    public static final ItemRandomizer SEQUENCE_HOTBAR = ItemRandomizer.create(Text.translate("effortless.transformer.randomizer.item.sequence_hotbar"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, Source.HOTBAR, Collections.emptyList());
    public static final ItemRandomizer SEQUENCE_HANDS = ItemRandomizer.create(Text.translate("effortless.transformer.randomizer.item.sequence_hands"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, Source.HANDS, Collections.emptyList());
    public static final ItemRandomizer EMPTY = ItemRandomizer.create(Text.empty(), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, Source.CUSTOMIZE, Collections.emptyList());

    public static ItemRandomizer customize(Text name, Randomizer.Order order, Randomizer.Target target, Collection<Chance<Item>> chances) {
        return ItemRandomizer.create(name, order, target, Source.CUSTOMIZE, chances);
    }

    public static ItemRandomizer single(Text name, Item content) {
        return ItemRandomizer.customize(name, Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(content)));
    }

    public static ItemRandomizer create(Text name, Randomizer.Order order, Randomizer.Target target, Source source, Collection<Chance<Item>> chances) {
        List<Chance<Item>> filtered = chances.stream().filter(chance -> chance.content() instanceof BlockItem).toList();
        return new ItemRandomizer(UUID.randomUUID(), name, order, target, source, filtered);
    }

    private static Text name(String key) {
        return Text.translate("effortless.transformer.randomizer.item.example.%s".formatted(key));
    }

    public static List<ItemRandomizer> getDefaultItemRandomizers() {
        ItemRandomizer variantCobblestone = ItemRandomizer.customize(ItemRandomizer.name("variant_cobblestone"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, List.of(Chance.of(Items.COBBLESTONE.item(), 1), Chance.of(Items.MOSSY_COBBLESTONE.item(), 1)));
        ItemRandomizer variantStoneBrick = ItemRandomizer.customize(ItemRandomizer.name("variant_stone_brick"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, List.of(Chance.of(Items.STONE_BRICKS.item(), 1), Chance.of(Items.MOSSY_STONE_BRICKS.item(), 1), Chance.of(Items.CRACKED_STONE_BRICKS.item(), 1)));
        ItemRandomizer allOres = ItemRandomizer.customize(ItemRandomizer.name("all_ores"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, List.of(Chance.of(Items.COAL_ORE.item(), 1), Chance.of(Items.COPPER_ORE.item(), 1), Chance.of(Items.LAPIS_ORE.item(), 1), Chance.of(Items.IRON_ORE.item(), 1), Chance.of(Items.REDSTONE_ORE.item(), 1), Chance.of(Items.GOLD_ORE.item(), 1), Chance.of(Items.DIAMOND_ORE.item(), 1), Chance.of(Items.EMERALD_ORE.item(), 1)));
        ItemRandomizer allDeepslateOres = ItemRandomizer.customize(ItemRandomizer.name("all_deepslate_ores"), Randomizer.Order.RANDOM, Randomizer.Target.SINGLE, List.of(Chance.of(Items.DEEPSLATE_COAL_ORE.item(), 1), Chance.of(Items.DEEPSLATE_COPPER_ORE.item(), 1), Chance.of(Items.DEEPSLATE_LAPIS_ORE.item(), 1), Chance.of(Items.DEEPSLATE_IRON_ORE.item(), 1), Chance.of(Items.DEEPSLATE_REDSTONE_ORE.item(), 1), Chance.of(Items.DEEPSLATE_GOLD_ORE.item(), 1), Chance.of(Items.DEEPSLATE_DIAMOND_ORE.item(), 1), Chance.of(Items.DEEPSLATE_EMERALD_ORE.item(), 1)));
        ItemRandomizer colorfulCarpet = ItemRandomizer.customize(ItemRandomizer.name("colorful_carpet"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_CARPET.item(), 1), Chance.of(Items.LIGHT_GRAY_CARPET.item(), 1), Chance.of(Items.GRAY_CARPET.item(), 1), Chance.of(Items.BLACK_CARPET.item(), 1), Chance.of(Items.BROWN_CARPET.item(), 1), Chance.of(Items.RED_CARPET.item(), 1), Chance.of(Items.ORANGE_CARPET.item(), 1), Chance.of(Items.YELLOW_CARPET.item(), 1), Chance.of(Items.LIME_CARPET.item(), 1), Chance.of(Items.GREEN_CARPET.item(), 1), Chance.of(Items.CYAN_CARPET.item(), 1), Chance.of(Items.LIGHT_BLUE_CARPET.item(), 1), Chance.of(Items.BLUE_CARPET.item(), 1), Chance.of(Items.PURPLE_CARPET.item(), 1), Chance.of(Items.MAGENTA_CARPET.item(), 1), Chance.of(Items.PINK_CARPET.item(), 1)));
        ItemRandomizer colorfulConcrete = ItemRandomizer.customize(ItemRandomizer.name("colorful_concrete"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_CONCRETE.item(), 1), Chance.of(Items.LIGHT_GRAY_CONCRETE.item(), 1), Chance.of(Items.GRAY_CONCRETE.item(), 1), Chance.of(Items.BLACK_CONCRETE.item(), 1), Chance.of(Items.BROWN_CONCRETE.item(), 1), Chance.of(Items.RED_CONCRETE.item(), 1), Chance.of(Items.ORANGE_CONCRETE.item(), 1), Chance.of(Items.YELLOW_CONCRETE.item(), 1), Chance.of(Items.LIME_CONCRETE.item(), 1), Chance.of(Items.GREEN_CONCRETE.item(), 1), Chance.of(Items.CYAN_CONCRETE.item(), 1), Chance.of(Items.LIGHT_BLUE_CONCRETE.item(), 1), Chance.of(Items.BLUE_CONCRETE.item(), 1), Chance.of(Items.PURPLE_CONCRETE.item(), 1), Chance.of(Items.MAGENTA_CONCRETE.item(), 1), Chance.of(Items.PINK_CONCRETE.item(), 1)));
        ItemRandomizer colorfulConcretePowder = ItemRandomizer.customize(ItemRandomizer.name("colorful_concrete_powder"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_CONCRETE_POWDER.item(), 1), Chance.of(Items.LIGHT_GRAY_CONCRETE_POWDER.item(), 1), Chance.of(Items.GRAY_CONCRETE_POWDER.item(), 1), Chance.of(Items.BLACK_CONCRETE_POWDER.item(), 1), Chance.of(Items.BROWN_CONCRETE_POWDER.item(), 1), Chance.of(Items.RED_CONCRETE_POWDER.item(), 1), Chance.of(Items.ORANGE_CONCRETE_POWDER.item(), 1), Chance.of(Items.YELLOW_CONCRETE_POWDER.item(), 1), Chance.of(Items.LIME_CONCRETE_POWDER.item(), 1), Chance.of(Items.GREEN_CONCRETE_POWDER.item(), 1), Chance.of(Items.CYAN_CONCRETE_POWDER.item(), 1), Chance.of(Items.LIGHT_BLUE_CONCRETE_POWDER.item(), 1), Chance.of(Items.BLUE_CONCRETE_POWDER.item(), 1), Chance.of(Items.PURPLE_CONCRETE_POWDER.item(), 1), Chance.of(Items.MAGENTA_CONCRETE_POWDER.item(), 1), Chance.of(Items.PINK_CONCRETE_POWDER.item(), 1)));
        ItemRandomizer colorfulWool = ItemRandomizer.customize(ItemRandomizer.name("colorful_wool"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_WOOL.item(), 1), Chance.of(Items.LIGHT_GRAY_WOOL.item(), 1), Chance.of(Items.GRAY_WOOL.item(), 1), Chance.of(Items.BLACK_WOOL.item(), 1), Chance.of(Items.BROWN_WOOL.item(), 1), Chance.of(Items.RED_WOOL.item(), 1), Chance.of(Items.ORANGE_WOOL.item(), 1), Chance.of(Items.YELLOW_WOOL.item(), 1), Chance.of(Items.LIME_WOOL.item(), 1), Chance.of(Items.GREEN_WOOL.item(), 1), Chance.of(Items.CYAN_WOOL.item(), 1), Chance.of(Items.LIGHT_BLUE_WOOL.item(), 1), Chance.of(Items.BLUE_WOOL.item(), 1), Chance.of(Items.PURPLE_WOOL.item(), 1), Chance.of(Items.MAGENTA_WOOL.item(), 1), Chance.of(Items.PINK_WOOL.item(), 1)));
        ItemRandomizer colorfulStainedGlass = ItemRandomizer.customize(ItemRandomizer.name("colorful_stained_glass"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_STAINED_GLASS.item(), 1), Chance.of(Items.LIGHT_GRAY_STAINED_GLASS.item(), 1), Chance.of(Items.GRAY_STAINED_GLASS.item(), 1), Chance.of(Items.BLACK_STAINED_GLASS.item(), 1), Chance.of(Items.BROWN_STAINED_GLASS.item(), 1), Chance.of(Items.RED_STAINED_GLASS.item(), 1), Chance.of(Items.ORANGE_STAINED_GLASS.item(), 1), Chance.of(Items.YELLOW_STAINED_GLASS.item(), 1), Chance.of(Items.LIME_STAINED_GLASS.item(), 1), Chance.of(Items.GREEN_STAINED_GLASS.item(), 1), Chance.of(Items.CYAN_STAINED_GLASS.item(), 1), Chance.of(Items.LIGHT_BLUE_STAINED_GLASS.item(), 1), Chance.of(Items.BLUE_STAINED_GLASS.item(), 1), Chance.of(Items.PURPLE_STAINED_GLASS.item(), 1), Chance.of(Items.MAGENTA_STAINED_GLASS.item(), 1), Chance.of(Items.PINK_STAINED_GLASS.item(), 1)));
        ItemRandomizer colorfulStainedGlassPane = ItemRandomizer.customize(ItemRandomizer.name("colorful_stained_glass_pane"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.LIGHT_GRAY_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.GRAY_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.BLACK_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.BROWN_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.RED_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.ORANGE_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.YELLOW_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.LIME_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.GREEN_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.CYAN_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.LIGHT_BLUE_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.BLUE_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.PURPLE_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.MAGENTA_STAINED_GLASS_PANE.item(), 1), Chance.of(Items.PINK_STAINED_GLASS_PANE.item(), 1)));
        ItemRandomizer colorfulTerracotta = ItemRandomizer.customize(ItemRandomizer.name("colorful_terracotta"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_TERRACOTTA.item(), 1), Chance.of(Items.LIGHT_GRAY_TERRACOTTA.item(), 1), Chance.of(Items.GRAY_TERRACOTTA.item(), 1), Chance.of(Items.BLACK_TERRACOTTA.item(), 1), Chance.of(Items.BROWN_TERRACOTTA.item(), 1), Chance.of(Items.RED_TERRACOTTA.item(), 1), Chance.of(Items.ORANGE_TERRACOTTA.item(), 1), Chance.of(Items.YELLOW_TERRACOTTA.item(), 1), Chance.of(Items.LIME_TERRACOTTA.item(), 1), Chance.of(Items.GREEN_TERRACOTTA.item(), 1), Chance.of(Items.CYAN_TERRACOTTA.item(), 1), Chance.of(Items.LIGHT_BLUE_TERRACOTTA.item(), 1), Chance.of(Items.BLUE_TERRACOTTA.item(), 1), Chance.of(Items.PURPLE_TERRACOTTA.item(), 1), Chance.of(Items.MAGENTA_TERRACOTTA.item(), 1), Chance.of(Items.PINK_TERRACOTTA.item(), 1)));
        ItemRandomizer colorfulGlazedTerracotta = ItemRandomizer.customize(ItemRandomizer.name("colorful_glazed_terracotta"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.LIGHT_GRAY_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.GRAY_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.BLACK_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.BROWN_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.RED_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.ORANGE_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.YELLOW_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.LIME_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.GREEN_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.CYAN_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.LIGHT_BLUE_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.BLUE_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.PURPLE_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.MAGENTA_GLAZED_TERRACOTTA.item(), 1), Chance.of(Items.PINK_GLAZED_TERRACOTTA.item(), 1)));
        ItemRandomizer colorfulShulkerBox = ItemRandomizer.customize(ItemRandomizer.name("colorful_shulker_box"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_SHULKER_BOX.item(), 1), Chance.of(Items.LIGHT_GRAY_SHULKER_BOX.item(), 1), Chance.of(Items.GRAY_SHULKER_BOX.item(), 1), Chance.of(Items.BLACK_SHULKER_BOX.item(), 1), Chance.of(Items.BROWN_SHULKER_BOX.item(), 1), Chance.of(Items.RED_SHULKER_BOX.item(), 1), Chance.of(Items.ORANGE_SHULKER_BOX.item(), 1), Chance.of(Items.YELLOW_SHULKER_BOX.item(), 1), Chance.of(Items.LIME_SHULKER_BOX.item(), 1), Chance.of(Items.GREEN_SHULKER_BOX.item(), 1), Chance.of(Items.CYAN_SHULKER_BOX.item(), 1), Chance.of(Items.LIGHT_BLUE_SHULKER_BOX.item(), 1), Chance.of(Items.BLUE_SHULKER_BOX.item(), 1), Chance.of(Items.PURPLE_SHULKER_BOX.item(), 1), Chance.of(Items.MAGENTA_SHULKER_BOX.item(), 1), Chance.of(Items.PINK_SHULKER_BOX.item(), 1)));
        ItemRandomizer colorfulBed = ItemRandomizer.customize(ItemRandomizer.name("colorful_bed"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_BED.item(), 1), Chance.of(Items.LIGHT_GRAY_BED.item(), 1), Chance.of(Items.GRAY_BED.item(), 1), Chance.of(Items.BLACK_BED.item(), 1), Chance.of(Items.BROWN_BED.item(), 1), Chance.of(Items.RED_BED.item(), 1), Chance.of(Items.ORANGE_BED.item(), 1), Chance.of(Items.YELLOW_BED.item(), 1), Chance.of(Items.LIME_BED.item(), 1), Chance.of(Items.GREEN_BED.item(), 1), Chance.of(Items.CYAN_BED.item(), 1), Chance.of(Items.LIGHT_BLUE_BED.item(), 1), Chance.of(Items.BLUE_BED.item(), 1), Chance.of(Items.PURPLE_BED.item(), 1), Chance.of(Items.MAGENTA_BED.item(), 1), Chance.of(Items.PINK_BED.item(), 1)));
        ItemRandomizer colorfulBanner = ItemRandomizer.customize(ItemRandomizer.name("colorful_banner"), Randomizer.Order.SEQUENCE, Randomizer.Target.SINGLE, List.of(Chance.of(Items.WHITE_BANNER.item(), 1), Chance.of(Items.LIGHT_GRAY_BANNER.item(), 1), Chance.of(Items.GRAY_BANNER.item(), 1), Chance.of(Items.BLACK_BANNER.item(), 1), Chance.of(Items.BROWN_BANNER.item(), 1), Chance.of(Items.RED_BANNER.item(), 1), Chance.of(Items.ORANGE_BANNER.item(), 1), Chance.of(Items.YELLOW_BANNER.item(), 1), Chance.of(Items.LIME_BANNER.item(), 1), Chance.of(Items.GREEN_BANNER.item(), 1), Chance.of(Items.CYAN_BANNER.item(), 1), Chance.of(Items.LIGHT_BLUE_BANNER.item(), 1), Chance.of(Items.BLUE_BANNER.item(), 1), Chance.of(Items.PURPLE_BANNER.item(), 1), Chance.of(Items.MAGENTA_BANNER.item(), 1), Chance.of(Items.PINK_BANNER.item(), 1)));
        return Stream.of(EMPTY, RANDOM_INVENTORY, RANDOM_HOTBAR, RANDOM_HANDS, variantCobblestone, variantStoneBrick, allOres, allDeepslateOres, colorfulCarpet, colorfulConcrete, colorfulConcretePowder, colorfulWool, colorfulStainedGlass, colorfulStainedGlassPane, colorfulTerracotta, colorfulGlazedTerracotta, colorfulShulkerBox, colorfulBed, colorfulBanner).collect(Collectors.toList());
    }

    public ItemRandomizer withOrder(Randomizer.Order order) {
        return new ItemRandomizer(this.id, this.name, order, this.target, this.source, this.chances);
    }

    public ItemRandomizer withTarget(Randomizer.Target target) {
        return new ItemRandomizer(this.id, this.name, this.order, target, this.source, this.chances);
    }

    public ItemRandomizer withSource(Source source) {
        return new ItemRandomizer(this.id, this.name, this.order, this.target, source, this.chances);
    }

    @Override
    public Text getName() {
        if (!this.name().getString().isEmpty()) {
            return this.name();
        }
        switch (this.getSource().ordinal()) {
            case 0: {
                switch (this.getOrder()) {
                    case SEQUENCE: {
                        return Text.translate("effortless.transformer.randomizer.item.sequence_inventory");
                    }
                    case RANDOM: {
                        return Text.translate("effortless.transformer.randomizer.item.random_inventory");
                    }
                }
                break;
            }
            case 1: {
                switch (this.getOrder()) {
                    case SEQUENCE: {
                        return Text.translate("effortless.transformer.randomizer.item.sequence_hotbar");
                    }
                    case RANDOM: {
                        return Text.translate("effortless.transformer.randomizer.item.random_hotbar");
                    }
                }
                break;
            }
            case 2: {
                switch (this.getOrder()) {
                    case SEQUENCE: {
                        return Text.translate("effortless.transformer.randomizer.item.sequence_hands");
                    }
                    case RANDOM: {
                        return Text.translate("effortless.transformer.randomizer.item.random_hands");
                    }
                }
                break;
            }
            case 3: {
                if (this.getChances().isEmpty()) {
                    return Text.translate("effortless.transformer.randomizer.item.empty");
                }
                switch (this.getOrder()) {
                    case SEQUENCE: {
                        return Text.translate("effortless.transformer.randomizer.item.sequence_customized");
                    }
                    case RANDOM: {
                        return Text.translate("effortless.transformer.randomizer.item.random_customized");
                    }
                }
            }
        }
        return this.name();
    }

    @Override
    public Randomizer.Order getOrder() {
        return this.order;
    }

    @Override
    public Randomizer.Target getTarget() {
        return this.target;
    }

    @Override
    public Randomizer.Category getCategory() {
        return Randomizer.Category.ITEM;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    public Collection<Chance<Item>> getChances() {
        return this.chances;
    }

    @Override
    public Producer<Item> asProducer(long seed, boolean limitedProducer) {
        return switch (this.order) {
            default -> throw new MatchException(null, null);
            case Randomizer.Order.SEQUENCE -> Producer.createSequence(this, seed, limitedProducer && this.getSource() != Source.CUSTOMIZE);
            case Randomizer.Order.RANDOM -> Producer.createUnordered(this, seed, limitedProducer && this.getSource() != Source.CUSTOMIZE);
        };
    }

    @Override
    public Operation transform(Operation operation) {
        if (operation.getContext().buildState() != BuildState.PLACE_BLOCK) {
            return operation;
        }
        if (!this.isValid()) {
            return new DeferredBatchOperation(operation.getContext(), () -> Stream.of(operation));
        }
        Producer<Item> source = this.asProducer(operation.getContext().extras().seed(), operation.getContext().extras().gameMode().isSurvival());
        if (operation instanceof DeferredBatchOperation) {
            DeferredBatchOperation deferredBatchOperation = (DeferredBatchOperation)operation;
            return switch (this.target) {
                default -> throw new MatchException(null, null);
                case Randomizer.Target.SINGLE -> deferredBatchOperation.mapEach(o -> (Operation)o.refactor(RefactorContext.of((Item)source.next())));
                case Randomizer.Target.GROUP -> deferredBatchOperation.map(o -> (Operation)o.refactor(RefactorContext.of((Item)source.next())));
            };
        }
        return new DeferredBatchOperation(operation.getContext(), () -> Stream.of((Operation)operation.refactor(RefactorContext.of((Item)source.next()))));
    }

    @Override
    public List<Text> getDescriptions() {
        ArrayList<Text> descriptions = new ArrayList<Text>();
        for (Chance<Item> chance : this.chances) {
            descriptions.add(chance.content().getName().append(" x" + chance.chance()));
        }
        return descriptions;
    }

    @Override
    public Transformers getType() {
        return Transformers.RANDOMIZER;
    }

    @Override
    public Stream<Text> getSearchableTags() {
        return Stream.concat(Stream.of(this.getName(), this.order.getDisplayName(), this.target.getDisplayName()), this.chances.stream().map(Chance::content).map(item -> item.getDefaultStack().getHoverName()));
    }

    @Override
    public boolean isValid() {
        return !this.getChances().isEmpty();
    }

    @Override
    public ItemRandomizer withRandomId() {
        return this.withId(UUID.randomUUID());
    }

    @Override
    public ItemRandomizer withName(Text name) {
        return new ItemRandomizer(this.id, name, this.order, this.target, this.source, this.chances);
    }

    @Override
    public ItemRandomizer withId(UUID id) {
        return new ItemRandomizer(id, this.name, this.order, this.target, this.source, this.chances);
    }

    public ItemRandomizer withChances(Collection<Chance<Item>> items) {
        return new ItemRandomizer(this.id, this.name, this.order, this.target, this.source, items);
    }

    @Override
    public ItemRandomizer finalize(Player player, BuildStage stage) {
        switch (stage) {
            case TICK: 
            case SET_PATTERN: 
            case INTERACT: {
                if (this.getSource() == Source.CUSTOMIZE) break;
                List<ItemStack> itemStacks = switch (this.getSource().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> Stream.of(player.getInventory().getBagItems(), player.getInventory().getOffhandItems()).flatMap(Collection::stream).toList();
                    case 1 -> player.getInventory().getHotbarItems();
                    case 2 -> List.of(player.getInventory().getSelectedItem(), player.getInventory().getOffhandItem());
                    case 3 -> List.of(ItemStack.empty());
                };
                return this.withChances(itemStacks.stream().filter(itemStack -> itemStack.getItem() instanceof BlockItem).map(itemStack -> Chance.of(itemStack.getItem(), itemStack.getCount())).toList());
            }
        }
        return this;
    }

    public static enum Source {
        INVENTORY("inventory"),
        HOTBAR("hotbar"),
        HANDS("hands"),
        CUSTOMIZE("customize");

        private final String name;

        private Source(String name) {
            this.name = name;
        }

        public Text getDisplayName() {
            return Text.translate("effortless.transformer.randomizer.source.%s".formatted(this.name));
        }

        public String getName() {
            return this.name;
        }
    }
}

