/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.randomize;

import dev.huskuraft.effortless.api.core.Item;
import java.util.Objects;

public interface Chance<T> {
    public static final int MIN_ITEM_COUNT = 0;
    public static final int MAX_ITEM_COUNT = 127;

    public static Chance<Item> item(Item item, int chance) {
        return Chance.of(item, chance);
    }

    public static <T> Chance<T> of(T content) {
        return Chance.of(content, 1);
    }

    public static <T> Chance<T> of(final T content, final int chance) {
        return new Chance<T>(){

            @Override
            public T content() {
                return content;
            }

            @Override
            public int chance() {
                return chance;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Chance)) {
                    return false;
                }
                Chance o1 = (Chance)o;
                if (chance != o1.chance()) {
                    return false;
                }
                return Objects.equals(content, o1.content());
            }

            public int hashCode() {
                int result = content != null ? content.hashCode() : 0;
                result = 31 * result + chance;
                return result;
            }

            public String toString() {
                return "Chance[content=" + String.valueOf(content) + ", chance=" + chance + "]";
            }
        };
    }

    public T content();

    public int chance();
}

