/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern;

import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.building.BuildStage;
import dev.huskuraft.effortless.building.Option;
import dev.huskuraft.effortless.building.pattern.Patterns;
import dev.huskuraft.effortless.building.pattern.Transformer;
import java.util.List;

public record Pattern(boolean enabled, List<Transformer> transformers) implements Option
{
    public static final Pattern DISABLED = new Pattern(false, List.of());
    public static final Pattern EMPTY = new Pattern(true, List.of());

    public Pattern withEnabled(boolean enabled) {
        return new Pattern(enabled, this.transformers);
    }

    public Pattern withRandomId() {
        return new Pattern(this.enabled, this.transformers);
    }

    public Pattern withTransformers(List<Transformer> transformers) {
        return new Pattern(this.enabled, transformers);
    }

    public Pattern toggled() {
        return new Pattern(!this.enabled, this.transformers);
    }

    public Pattern finalize(Player player, BuildStage stage) {
        return this.withTransformers(this.transformers().stream().map(transformer -> transformer.finalize(player, stage)).toList());
    }

    public float volumeMultiplier() {
        float multiplier = 1.0f;
        for (Transformer transformer : this.transformers()) {
            multiplier *= transformer.volumeMultiplier();
        }
        return multiplier;
    }

    @Override
    public String getName() {
        if (this.enabled) {
            return Patterns.ENABLED.getName();
        }
        return Patterns.DISABLED.getName();
    }

    @Override
    public String getCategory() {
        if (this.enabled) {
            return Patterns.ENABLED.getCategory();
        }
        return Patterns.DISABLED.getCategory();
    }
}

