/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.operation.block.Extras;
import dev.huskuraft.effortless.building.pattern.PositionBounded;

public record MirrorContext(Vector3d center, BoundingBox3d bounds, Axis axis) implements PositionBounded
{
    public static MirrorContext MIRROR_X = new MirrorContext(new Vector3d(0.5, 0.5, 0.5), new BoundingBox3d(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE), Axis.X);
    public static MirrorContext MIRROR_Y = new MirrorContext(new Vector3d(0.5, 0.5, 0.5), new BoundingBox3d(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE), Axis.Y);
    public static MirrorContext MIRROR_Z = new MirrorContext(new Vector3d(0.5, 0.5, 0.5), new BoundingBox3d(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE), Axis.Z);

    public Vector3d mirror(Vector3d vec) {
        return switch (this.axis) {
            default -> throw new MatchException(null, null);
            case Axis.Y -> new Vector3d(vec.x(), this.center.y() + (this.center.y() - vec.y()), vec.z());
            case Axis.X -> new Vector3d(this.center.x() + (this.center.x() - vec.x()), vec.y(), vec.z());
            case Axis.Z -> new Vector3d(vec.x(), vec.y(), this.center.z() + (this.center.z() - vec.z()));
        };
    }

    public BlockPosition mirror(BlockPosition blockPosition) {
        Vector3d vector = this.mirror(blockPosition.getCenter());
        return BlockPosition.at(vector);
    }

    public Direction mirror(Direction direction) {
        return direction.getAxis() != this.axis ? direction : direction.getOpposite();
    }

    public BlockInteraction mirror(BlockInteraction blockInteraction) {
        Direction direction = this.mirror(blockInteraction.getDirection());
        Vector3d position = this.mirror(blockInteraction.getPosition());
        BlockPosition blockPosition = this.mirror(blockInteraction.getBlockPosition());
        return blockInteraction.withDirection(direction).withPosition(position).withBlockPosition(blockPosition);
    }

    public BlockState mirror(BlockState blockState) {
        if (blockState == null) {
            return blockState;
        }
        return blockState.mirror(this.axis);
    }

    public BlockEntity mirror(BlockEntity blockEntity) {
        return blockEntity;
    }

    public Extras mirror(Extras extras) {
        return extras;
    }

    @Override
    public boolean isInBounds(Vector3d position) {
        return this.bounds.contains(position);
    }
}

